﻿----------------------------------------------------------------------------------------------------
-- DroodFocus 4.0.0 - Libs
-- Meranannon - Discordia - Vol'jin (EU)
-- rev 1
----------------------------------------------------------------------------------------------------

local DF = DF_namespace
local _

DF.LSM = LibStub("LibSharedMedia-3.0")

DF.LSM:Register("font", "DF Font Normal",[[Interface\AddOns\DroodFocus\datas\font.ttf]])
DF.LSM:Register("font", "DF Font Texte",[[Interface\AddOns\DroodFocus\datas\font_text.ttf]])
DF.LSM:Register("font", "DF Font Digital",[[Interface\AddOns\DroodFocus\datas\font_digital.ttf]])
DF.LSM:Register("font", "DF Font Typewriter",[[Interface\AddOns\DroodFocus\datas\font_typewriter.ttf]])
DF.LSM:Register("font", "DF Font Unispace",[[Interface\AddOns\DroodFocus\datas\font_unispace.ttf]])
DF.LSM:Register("font", "DF Font Arial Narrow (WoW)",[[Fonts\ARIALN.TTF]])
DF.LSM:Register("font", "DF Font Friz Quadrata TT (WoW)",[[Fonts\FRIZQT__.TTF]])
DF.LSM:Register("font", "DF Font Morpheus (WoW)",[[Fonts\MORPHEUS.TTF]])
DF.LSM:Register("font", "DF Font Skurri (WoW)",[[Fonts\SKURRI.TTF]])

DF.LSM:Register("statusbar", "DF Statusbar 1",[[Interface\AddOns\DroodFocus\datas\statusbar.tga]])
DF.LSM:Register("statusbar", "DF Statusbar 2",[[Interface\AddOns\DroodFocus\datas\statusbar2.tga]])
DF.LSM:Register("statusbar", "DF Statusbar 3",[[Interface\AddOns\DroodFocus\datas\statusbar3.tga]])
DF.LSM:Register("statusbar", "DF Statusbar 4",[[Interface\AddOns\DroodFocus\datas\statusbar4.tga]])
DF.LSM:Register("statusbar", "DF Statusbar 5",[[Interface\AddOns\DroodFocus\datas\statusbar5.tga]])

DF.LSM:Register("background", "DF Blood 1", [[Interface\AddOns\DroodFocus\datas\blood1.tga]])
DF.LSM:Register("background", "DF Blood 2", [[Interface\AddOns\DroodFocus\datas\blood2.tga]])
DF.LSM:Register("background", "DF Blood 3", [[Interface\AddOns\DroodFocus\datas\blood3.tga]])
DF.LSM:Register("background", "DF Icon Behind", [[Interface\AddOns\DroodFocus\datas\alertBehind.tga]])
DF.LSM:Register("background", "DF Icon OutOfRange", [[Interface\AddOns\DroodFocus\datas\alertRange.tga]])
DF.LSM:Register("background", "DF icon Aggro", [[Interface\AddOns\DroodFocus\datas\alertSkull.tga]])
DF.LSM:Register("background", "DF icon Warning", [[Interface\AddOns\DroodFocus\datas\alertWarning.tga]])
DF.LSM:Register("background", "DF Combo: Bear", [[Interface\AddOns\DroodFocus\custom\combo_bear.tga]])
DF.LSM:Register("background", "DF Combo: Blue", [[Interface\AddOns\DroodFocus\custom\combo_blue.tga]])
DF.LSM:Register("background", "DF Combo: Close eye", [[Interface\AddOns\DroodFocus\custom\combo_closeEye.tga]])
DF.LSM:Register("background", "DF Combo: Gray", [[Interface\AddOns\DroodFocus\custom\combo_gray.tga]])
DF.LSM:Register("background", "DF Combo: Black", [[Interface\AddOns\DroodFocus\custom\combo_black.tga]])
DF.LSM:Register("background", "DF Combo: Gray square", [[Interface\AddOns\DroodFocus\custom\combo_square_gray.tga]])
DF.LSM:Register("background", "DF Combo: Green", [[Interface\AddOns\DroodFocus\custom\combo_green.tga]])
DF.LSM:Register("background", "DF Combo: Holy", [[Interface\AddOns\DroodFocus\custom\combo_holy.tga]])
DF.LSM:Register("background", "DF Combo: Open eye", [[Interface\AddOns\DroodFocus\custom\combo_openEye.tga]])
DF.LSM:Register("background", "DF Combo: Red", [[Interface\AddOns\DroodFocus\custom\combo_red.tga]])
DF.LSM:Register("background", "DF Combo: Red square", [[Interface\AddOns\DroodFocus\custom\combo_square_red.tga]])
DF.LSM:Register("background", "DF Combo: Blood rune", [[Interface\AddOns\DroodFocus\custom\combo_rune_blood.tga]])
DF.LSM:Register("background", "DF Combo: Frost rune", [[Interface\AddOns\DroodFocus\custom\combo_rune_frost.tga]])
DF.LSM:Register("background", "DF Combo: unholy rune", [[Interface\AddOns\DroodFocus\custom\combo_rune_unholy.tga]])
DF.LSM:Register("background", "DF Combo: Yellow", [[Interface\AddOns\DroodFocus\custom\combo_yellow.tga]])
DF.LSM:Register("background", "DF Combo: Yellow square", [[Interface\AddOns\DroodFocus\custom\combo_square_yellow.tga]])
DF.LSM:Register("background", "DF Combo: Ying", [[Interface\AddOns\DroodFocus\custom\ying.tga]])
DF.LSM:Register("background", "DF Combo: Yang", [[Interface\AddOns\DroodFocus\custom\yang.tga]])
DF.LSM:Register("background", "DF Defense 1: Active", [[Interface\AddOns\DroodFocus\custom\defense_on.tga]])
DF.LSM:Register("background", "DF Defense 1: Inactive", [[Interface\AddOns\DroodFocus\custom\defense_off.tga]])
DF.LSM:Register("background", "DF Defense 1: No rage", [[Interface\AddOns\DroodFocus\custom\defense_norage.tga]])
DF.LSM:Register("background", "DF Defense 2: Active", [[Interface\AddOns\DroodFocus\custom\savage_on.tga]])
DF.LSM:Register("background", "DF Defense 2: Inactive", [[Interface\AddOns\DroodFocus\custom\savage_off.tga]])
DF.LSM:Register("background", "DF Defense 2: No rage", [[Interface\AddOns\DroodFocus\custom\savage_norage.tga]])
DF.LSM:Register("background", "DF UI 1", [[Interface\AddOns\DroodFocus\datas\UI_texture1.tga]])
DF.LSM:Register("background", "DF UI 2", [[Interface\AddOns\DroodFocus\datas\UI_texture2.tga]])
DF.LSM:Register("background", "DF Form humanoïd", [[Interface\AddOns\DroodFocus\datas\noform.tga]])
DF.LSM:Register("background", "DF Form Bear", [[Interface\AddOns\DroodFocus\datas\bearform.tga]])
DF.LSM:Register("background", "DF Form Cat", [[Interface\AddOns\DroodFocus\datas\catform.tga]])
DF.LSM:Register("background", "DF Form Flight", [[Interface\AddOns\DroodFocus\datas\flightform.tga]])
DF.LSM:Register("background", "DF Form Moonkin", [[Interface\AddOns\DroodFocus\datas\moonkinform.tga]])
DF.LSM:Register("background", "DF Form Travel", [[Interface\AddOns\DroodFocus\datas\travelform.tga]])
DF.LSM:Register("background", "DF Form Tree", [[Interface\AddOns\DroodFocus\datas\treeform.tga]])
DF.LSM:Register("background", "DF Form Aquatic", [[Interface\AddOns\DroodFocus\datas\aquaform.tga]])

-- special fx
DF.LSM:Register("background", "DF Aura 01", [[Textures\SpellActivationOverlays\Sword_and_Board]])
DF.LSM:Register("background", "DF Aura 02", [[Textures\SpellActivationOverlays\Arcane_Missiles]])
DF.LSM:Register("background", "DF Aura 03", [[Textures\SpellActivationOverlays\Art_of_War]])
DF.LSM:Register("background", "DF Aura 04", [[Textures\SpellActivationOverlays\Blood_Surge]])
DF.LSM:Register("background", "DF Aura 05", [[Textures\SpellActivationOverlays\BRAIN_FREEZE]])
DF.LSM:Register("background", "DF Aura 06", [[Textures\SpellActivationOverlays\Eclipse_Moon]])
DF.LSM:Register("background", "DF Aura 07", [[Textures\SpellActivationOverlays\Eclipse_Sun]])
DF.LSM:Register("background", "DF Aura 08", [[Textures\SpellActivationOverlays\Focus_Fire]])
DF.LSM:Register("background", "DF Aura 09", [[Textures\SpellActivationOverlays\FROZEN_FINGERS]])
DF.LSM:Register("background", "DF Aura 10", [[Textures\SpellActivationOverlays\GenericArc_01]])
DF.LSM:Register("background", "DF Aura 11", [[Textures\SpellActivationOverlays\GenericArc_02]])
DF.LSM:Register("background", "DF Aura 12", [[Textures\SpellActivationOverlays\GenericArc_03]])
DF.LSM:Register("background", "DF Aura 13", [[Textures\SpellActivationOverlays\GenericArc_04]])
DF.LSM:Register("background", "DF Aura 14", [[Textures\SpellActivationOverlays\GenericArc_05]])
DF.LSM:Register("background", "DF Aura 15", [[Textures\SpellActivationOverlays\GenericArc_06]])
DF.LSM:Register("background", "DF Aura 16", [[Textures\SpellActivationOverlays\GenericTop_01]])
DF.LSM:Register("background", "DF Aura 17", [[Textures\SpellActivationOverlays\GenericTop_02]])
DF.LSM:Register("background", "DF Aura 18", [[Textures\SpellActivationOverlays\Grand_Crusader]])
DF.LSM:Register("background", "DF Aura 19", [[Textures\SpellActivationOverlays\Hot_Streak]])
DF.LSM:Register("background", "DF Aura 20", [[Textures\SpellActivationOverlays\Imp_Empowerment]])
DF.LSM:Register("background", "DF Aura 21", [[Textures\SpellActivationOverlays\Impact]])
DF.LSM:Register("background", "DF Aura 22", [[Textures\SpellActivationOverlays\Lock_and_Load]])
DF.LSM:Register("background", "DF Aura 23", [[Textures\SpellActivationOverlays\MAELSTROM_WEAPON]])
DF.LSM:Register("background", "DF Aura 24", [[Textures\SpellActivationOverlays\Master_Marksman]])
DF.LSM:Register("background", "DF Aura 25", [[Textures\SpellActivationOverlays\Natures_Grace]])
DF.LSM:Register("background", "DF Aura 26", [[Textures\SpellActivationOverlays\Nightfall]])
DF.LSM:Register("background", "DF Aura 27", [[Textures\SpellActivationOverlays\Rime]])
DF.LSM:Register("background", "DF Aura 28", [[Textures\SpellActivationOverlays\Slice_and_Dice]])
DF.LSM:Register("background", "DF Aura 29", [[Textures\SpellActivationOverlays\spellActivationOverlay_0]])
DF.LSM:Register("background", "DF Aura 30", [[Textures\SpellActivationOverlays\Sudden_Death]])
DF.LSM:Register("background", "DF Aura 31", [[Textures\SpellActivationOverlays\Sudden_Doom]])
DF.LSM:Register("background", "DF Aura 32", [[Textures\SpellActivationOverlays\Surge_of_Light]])
DF.LSM:Register("background", "DF Aura 33", [[Textures\SpellActivationOverlays\Backlash.blp]])
DF.LSM:Register("background", "DF Aura 34", [[Textures\SpellActivationOverlays\Berserk.blp]])
DF.LSM:Register("background", "DF Aura 35", [[Textures\SpellActivationOverlays\Blood_Boil.blp]])
DF.LSM:Register("background", "DF Aura 36", [[Textures\SpellActivationOverlays\Dark_Tiger.blp]])
DF.LSM:Register("background", "DF Aura 37", [[Textures\SpellActivationOverlays\Dark_Transformation.blp]])
DF.LSM:Register("background", "DF Aura 38", [[Textures\SpellActivationOverlays\DAYBREAK.blp]])
DF.LSM:Register("background", "DF Aura 39", [[Textures\SpellActivationOverlays\Denounce.blp]])
DF.LSM:Register("background", "DF Aura 40", [[Textures\SpellActivationOverlays\Feral_OmenOfClarity.blp]])
DF.LSM:Register("background", "DF Aura 41", [[Textures\SpellActivationOverlays\Fulmination.blp]])
DF.LSM:Register("background", "DF Aura 42", [[Textures\SpellActivationOverlays\Fury_of_Stormrage.blp]])
DF.LSM:Register("background", "DF Aura 43", [[Textures\SpellActivationOverlays\Hand_of_Light.blp]])
DF.LSM:Register("background", "DF Aura 44", [[Textures\SpellActivationOverlays\Impact.blp]])
DF.LSM:Register("background", "DF Aura 45", [[Textures\SpellActivationOverlays\Killing_Machine.blp]])
DF.LSM:Register("background", "DF Aura 46", [[Textures\SpellActivationOverlays\Lock_and_Load.blp]])
DF.LSM:Register("background", "DF Aura 47", [[Textures\SpellActivationOverlays\Molten_Core.blp]])
DF.LSM:Register("background", "DF Aura 48", [[Textures\SpellActivationOverlays\Monk_Ox.blp]])
DF.LSM:Register("background", "DF Aura 49", [[Textures\SpellActivationOverlays\Monk_Serpent.blp]])
DF.LSM:Register("background", "DF Aura 50", [[Textures\SpellActivationOverlays\Monk_Tiger.blp]])
DF.LSM:Register("background", "DF Aura 51", [[Textures\SpellActivationOverlays\Necropolis.blp]])
DF.LSM:Register("background", "DF Aura 52", [[Textures\SpellActivationOverlays\Serendipity.blp]])
DF.LSM:Register("background", "DF Aura 53", [[Textures\SpellActivationOverlays\Shadow_of_Death.blp]])
DF.LSM:Register("background", "DF Aura 54", [[Textures\SpellActivationOverlays\Shooting_Stars.blp]])
DF.LSM:Register("background", "DF Aura 55", [[Textures\SpellActivationOverlays\Surge_of_Darkness.blp]])
DF.LSM:Register("background", "DF Aura 56", [[Textures\SpellActivationOverlays\Ultimatum.blp]])
DF.LSM:Register("background", "DF Aura 57", [[Textures\SpellActivationOverlays\White_Tiger.blp]])
DF.LSM:Register("background", "DF Aura 58", [[Interface\AddOns\DroodFocus\datas\picture.tga]])
--
DF.LSM:Register("background", "DF Glow 00", [[Interface\AddOns\DroodFocus\datas\fx_ooc.tga]])
DF.LSM:Register("background", "DF Glow 01", [[Interface\AddOns\DroodFocus\datas\fx_glow1.tga]])
DF.LSM:Register("background", "DF Glow 02", [[Interface\AddOns\DroodFocus\datas\fx_glow2.tga]])
DF.LSM:Register("background", "DF Glow 03", [[Interface\AddOns\DroodFocus\datas\fx_glow3.tga]])
DF.LSM:Register("background", "DF Glow 04", [[Interface\AddOns\DroodFocus\datas\fx_glow4.tga]])
DF.LSM:Register("background", "DF Glow 05", [[Interface\AddOns\DroodFocus\datas\fx_glow5.tga]])
DF.LSM:Register("background", "DF Glow 06", [[Interface\AddOns\DroodFocus\datas\fx_glow6.tga]])
DF.LSM:Register("background", "DF Glow 07", [[Interface\AddOns\DroodFocus\datas\fx_glow7.tga]])
DF.LSM:Register("background", "DF Glow 08", [[Interface\AddOns\DroodFocus\datas\fx_glow8.tga]])
DF.LSM:Register("background", "DF Glow 09", [[Interface\AddOns\DroodFocus\datas\fx_glow9.tga]])
DF.LSM:Register("background", "DF Glow 10", [[Interface\AddOns\DroodFocus\datas\fx_glow10.tga]])
DF.LSM:Register("background", "DF Glow 11", [[Interface\AddOns\DroodFocus\datas\fx_glow11.tga]])
DF.LSM:Register("background", "DF Glow 12", [[Interface\AddOns\DroodFocus\datas\fx_glow12.tga]])
DF.LSM:Register("background", "DF Glow 13", [[Interface\AddOns\DroodFocus\datas\fx_glow13.tga]])
DF.LSM:Register("background", "DF Glow 14", [[Interface\AddOns\DroodFocus\datas\fx_glow14.tga]])
DF.LSM:Register("background", "DF Glow 15", [[Interface\AddOns\DroodFocus\datas\fx_glow15.tga]])
DF.LSM:Register("background", "DF Glow 16", [[Interface\AddOns\DroodFocus\datas\fx_glow16.tga]])
DF.LSM:Register("background", "DF Glow 17", [[Interface\AddOns\DroodFocus\datas\fx_glow17.tga]])
DF.LSM:Register("background", "DF Glow 18", [[Interface\AddOns\DroodFocus\datas\fx_glow18.tga]])
DF.LSM:Register("background", "DF Glow 19", [[Interface\AddOns\DroodFocus\datas\fx_glow19.tga]])
DF.LSM:Register("background", "DF Glow 20", [[Interface\AddOns\DroodFocus\datas\fx_glow20.tga]])
DF.LSM:Register("background", "DF Glow 21", [[Interface\AddOns\DroodFocus\datas\fx_glow21.tga]])
DF.LSM:Register("background", "DF Glow 22", [[Interface\AddOns\DroodFocus\datas\fx_glow22.tga]])
DF.LSM:Register("background", "DF Glow 23", [[Interface\AddOns\DroodFocus\datas\fx_glow23.tga]])
DF.LSM:Register("background", "DF Aura FX", [[Interface\AddOns\DroodFocus\datas\fx.tga]])
DF.LSM:Register("background", "DF Aura COMBO", [[Interface\AddOns\DroodFocus\datas\fx_combo.tga]])
DF.LSM:Register("background", "DF PA dot", [[Interface\AddOns\DroodFocus\datas\pa_dot.tga]])


--
DF.LSM:Register("sound", "DF Cat roar",[[Sound\Spells\Druid_FeralCharge.wav]])
DF.LSM:Register("sound", "DF Bear roar",[[Sound\Spells\Druid_Pounce.wav]])
DF.LSM:Register("sound", "DF Chicken",[[Sound\Character\BloodElf\BloodElfMaleChicken01.wav]])
DF.LSM:Register("sound", "DF Bell 1",[[Sound\Event Sounds\Wisp\WispYes1.wav]])
DF.LSM:Register("sound", "DF Bell 2",[[Sound\Spells\DirectDamage\HolyImpactDDHigh.wav]])
DF.LSM:Register("sound", "DF Bell 3",[[Sound\Spells\Tradeskills\FishReelIn.wav]])
DF.LSM:Register("sound", "DF Cower",[[Sound\Spells\Cower.wav]])
DF.LSM:Register("sound", "DF BellToll Alliance",[[Sound\Doodad\BellTollAlliance.wav]])
DF.LSM:Register("sound", "DF BellToll Horde",[[Sound\Doodad\BellTollHorde.wav]])
DF.LSM:Register("sound", "DF BellToll NightElf",[[Sound\Doodad\BellTollNightElf.wav]])
DF.LSM:Register("sound", "DF BellToll Tribal",[[Sound\Doodad\BellTollTribal.wav]])
DF.LSM:Register("sound", "DF Alert",[[Interface\AddOns\DroodFocus\datas\DF_alert.ogg]])
DF.LSM:Register("sound", "DF Pulled Aggro",[[Sound\INTERFACE\Aggro_Pulled_Aggro.ogg]])
DF.LSM:Register("sound", "DF Alarm Clock Warning2",[[Sound\INTERFACE\AlarmClockWarning2.ogg]])
DF.LSM:Register("sound", "DF Alarm Clock Warning3",[[Sound\INTERFACE\AlarmClockWarning3.ogg]])
DF.LSM:Register("sound", "DF Glyph_MajorCreate",[[Sound\INTERFACE\Glyph_MajorCreate.ogg]])
DF.LSM:Register("sound", "DF GM_ChatWarning",[[Sound\INTERFACE\GM_ChatWarning.ogg]])
DF.LSM:Register("sound", "DF iQuestUpdate",[[Sound\INTERFACE\iQuestUpdate.ogg]])
DF.LSM:Register("sound", "DF GunFire01",[[Sound\Item\Weapons\GunFire01.ogg]])
DF.LSM:Register("sound", "DF YarrrrImpact",[[Sound\Spells\YarrrrImpact.ogg]])
DF.LSM:Register("sound", "DF Vanish",[[Sound\Spells\Vanish.ogg]])
DF.LSM:Register("sound", "DF UnyieldingWillTarget",[[Sound\Spells\UnyieldingWillTarget.ogg]])
DF.LSM:Register("sound", "DF ConstrictingChains",[[Sound\Spells\ConstrictingChains.ogg]])
DF.LSM:Register("sound", "DF Fart",[[Sound\Spells\Fart_02.ogg]])
DF.LSM:Register("sound", "DF UI_GuildLevelUp",[[Sound\INTERFACE\UI_GuildLevelUp.ogg]])
DF.LSM:Register("sound",	"DF Big Bad Wolf", 		"Sound\\Creature\\HoodWolf\\HoodWolfTransformPlayer01.wav")
DF.LSM:Register("sound", 	"DF Murderous Rampage", 	"Sound\\Character\\Gnome\\GnomeVocalFemale\\GnomeFemalePissed01.wav")
DF.LSM:Register("sound", 	"DF Karazhan Bell", 		"Sound\\Doodad\\KharazahnBellToll.wav")
DF.LSM:Register("sound", 	"DF Fireworks", 			"Sound\\Doodad\\G_FireworkLauncher02Custom0.wav")
DF.LSM:Register("sound", 	"DF Springs", 				"Sound\\Doodad\\Goblin_Lottery_Open03.wav")
DF.LSM:Register("sound", 	"DF Troll Drums", 			"Sound\\Doodad\\TrollDrumLoop1.wav")
DF.LSM:Register("sound", 	"DF Ogre Drums", 			"Sound\\Event Sounds\\Event_wardrum_ogre.wav")
DF.LSM:Register("sound", 	"DF Roars Tauren", 			"Sound\\Character\\PlayerRoars\\CharacterRoarsTaurenMale.ogg")
DF.LSM:Register("sound", 	"DF Cat Step A", 			"Sound\\Creature\\Cat\\CatStepA.ogg")
DF.LSM:Register("sound", 	"DF Cat Step B", 			"Sound\\Creature\\Cat\\CatStepB.ogg")
DF.LSM:Register("sound", 	"DF Cow Death", 			"Sound\\Creature\\Cow\\CowDeath.ogg")
DF.LSM:Register("sound", 	"DF Hozen Run", 			"Sound\\Creature\\Hozen\\MON_Hozen_Jungle_Run_02.OGG")
DF.LSM:Register("sound", 	"DF Pug Dog", 			"Sound\\Creature\\PugDog\\PugDog_Clickable_06.ogg")
DF.LSM:Register("sound", 	"DF Tiger Attack", 			"Sound\\Creature\\Tiger\\mTigerAttackB.ogg")
DF.LSM:Register("sound", 	"DF Man Scream", 			"Sound\\Events\\EbonHold_ManScream2_01.ogg")
DF.LSM:Register("sound", 	"DF Blade Impact", 			"Sound\\Spells\\Blade_of_Azzinoth_Impact.ogg")
DF.LSM:Register("sound", 	"DF Bonk 1", 			"Sound\\Spells\\Bonk1.ogg")
DF.LSM:Register("sound", 	"DF Bonk 2", 			"Sound\\Spells\\Bonk2.ogg")
DF.LSM:Register("sound", 	"DF Bonk 3", 			"Sound\\Spells\\Bonk3.ogg")
DF.LSM:Register("sound", 	"DF Rope Break Snap", 			"Sound\\Spells\\FX_UNI_Rope_BreakSnap03.ogg")
DF.LSM:Register("sound", 	"DF Pet Call", 			"Sound\\Spells\\PetCall.ogg")
DF.LSM:Register("sound", 	"DF Shield Break", 			"Sound\\Spells\\ShieldBreak.ogg")

function DF:libs_AddFile(ftype,fname,fpath)
	DF.LSM:Register(ftype, fname, fpath)
end

function DF:libs_registerUsersFiles()
	for k,_ in pairs(DF_sharemedia) do
		DF.LSM:Register(DF_sharemedia[k].ftype, k, DF_sharemedia[k].fpath)
	end
end

function DF:libs_saveNewFile(ftype,fname,fpath)

	fpath=fpath:gsub("\\\\", "\\")
	fpath=fpath:sub(2)
	
	DF_sharemedia[fname]={["ftype"]=ftype,["fpath"]=fpath}
	DF:libs_registerUsersFiles()
	
	DF:options_ShareMediaLists()
	
end





 