local DF = DF_namespace
local _

DF.dotPowerDatas={}

-- RAKE
local rakeName, _, _, _, _, _ = GetSpellInfo(155722)
DF.dotPowerDatas[rakeName]={
	base=99,				--	base damage
	baseap=0.30665,	--	damage give by power attack
	basecp=0,				--	base damage per combo point (if spell use combo point, else zero)
}

-- RIP
local ripName, _, _, _, _, _ = GetSpellInfo(1079)
DF.dotPowerDatas[ripName]={
	base=112.76,
	baseap=0.0484,
	basecp=320,
}

-- THRASH
local trashName, _, _, _, _, _ = GetSpellInfo(106830)
DF.dotPowerDatas[trashName]={
	base=686,
	baseap=0.0936,
	basecp=0,
}

function DF:GetBleedAbilityDamageCoefficient(docActive)
    
    -- ancienne formule avec trinket
    -- local _, _, _, _, _, _, damageCoeff = UnitDamage("player");
    
    -- nouvelle formule, ne tiens compte que du rugissement, fureur du tigre et bloodtalons
    local damageCoeff=1
    if DF:spell_exist(nil,DF.SavageRoarName,"player","HELPFUL|PLAYER",false) or DF.GlyphOfSavagery or (DF.ImpRakeTimer>0 and DF.GlyphOfSavageRoar) then
    	damageCoeff=damageCoeff*1.40
    end
    if DF:spell_exist(nil,DF.TigerFuryName,"player","HELPFUL|PLAYER",false) then
    	damageCoeff=damageCoeff*1.15
    end
            
    --local masteryCoeff = 1 + GetMastery() / 8 * 0.2504
    
    local docCoeff = 1
		if docActive then docCoeff = 1.30 end		
		
    local result = damageCoeff * docCoeff
    
    return result
    
end

function DF:GetDotPower(spellid,docActive,forceCP)
   
    local bleedCoeff
    local CP = UnitPower('player', 4)
    local dotPower=0
    local bleedBase
    
    if DF.dotPowerDatas[spellid] then
	
			bleedCoeff = DF:GetBleedAbilityDamageCoefficient(docActive)
			
	    if forceCP then CP=forceCP end
	    if DF.dotPowerDatas[spellid].basecp==0 then CP=1 end
	    
	    bleedBase = (DF.dotPowerDatas[spellid].base+(DF.dotPowerDatas[spellid].basecp*CP))+((DF.dotPowerDatas[spellid].baseap*DF.playerAP)*CP)
	    
	    dotPower = bleedCoeff * bleedBase
	    
	    if (DF.ImpRakeTimer>0 and spellid==rakeName and DF.ImprovedRakePerk) then
	    	-- 100% sous rder (lvl 92+ perk)
	    	dotPower=dotPower*2
	    end
	    
	  end
	  
    return dotPower
    
end

function DF:GetAbiPower(spellid)
	local targetID=UnitGUID("playertarget")
	if targetID and DF.abiPowers[targetID] and DF.abiPowers[targetID][spellid] then
		return DF.abiPowers[targetID][spellid]
	else
		return nil
	end
end

