﻿local frame = CreateFrame("Frame", "BTBMainFrame", UIParent)
-- Threat Bar width and height
frame:SetHeight(20)
frame:SetWidth(200)
frame:SetPoint("BOTTOMRIGHT", UIParent, "BOTTOMRIGHT", -500 , 500)
frame:EnableMouse(true)
frame:SetMovable(true)
-- to lock resiz function: (false)
frame:SetResizable(true)
frame:SetUserPlaced(true)
frame:SetClampedToScreen( true )
-- this locks the resiz function to specified max/min size
frame:SetMaxResize(500,190);
frame:SetMinResize(100,10);
frame:RegisterForDrag("LeftButton");
frame:SetScript("OnDragStart", function(s) 
	if IsAltKeyDown() and IsShiftKeyDown() then s:StartSizing() 
	elseif IsShiftKeyDown() then s:StartMoving()
	end 
end)
frame:SetScript("OnDragStop", function(s) s:StopMovingOrSizing() end)
frame:SetScript("OnEnter", function(s) 
	if not UnitAffectingCombat("player") then
		GameTooltip:SetOwner(s, "ANCHOR_TOP")
        GameTooltip:AddLine("Threat-Bar", 0, 1, 1, 1, 1, 1)
        GameTooltip:AddLine("SHIFT+鼠标 移动.", 1, 1, 1, 1, 1, 1)
		GameTooltip:AddLine("ALT+SHIFT+鼠标 改变大小.", 1, 1, 1, 1, 1, 1)
		GameTooltip:AddLine("/btb hide 和 /btb show来隐藏显示", 1, 1, 1, 1, 1, 1)
        GameTooltip:Show()
	end
end)
frame:SetScript("OnLeave", function(s)
GameTooltip:Hide()
end)
-- change Border and Backdrop textur here
frame:SetBackdrop({
    bgFile = "Interface\\AddOns\\BasicThreatBar\\Flat",
    edgeFile = "Interface\\AddOns\\BasicThreatBar\\Border-3",
    tile = false,
    edgeSize = 4,
    insets = {
        left = 1,
        right = 1,
        top = 1,
        bottom = 1
    }
});
frame:SetBackdropColor(0, 0, 0, 0)
frame:SetBackdropBorderColor(0, 0, 0, 1)

frame:RegisterEvent("UNIT_THREAT_SITUATION_UPDATE")
frame:RegisterEvent("UNIT_THREAT_LIST_UPDATE")
frame:RegisterEvent("PLAYER_TARGET_CHANGED")
frame:RegisterEvent("PARTY_MEMBERS_CHANGED")

local threatbar = CreateFrame("StatusBar", "ThreatBar", frame)
threatbar:SetPoint("TOPLEFT", frame, "TOPLEFT", 1, -1)
threatbar:SetPoint("BOTTOMRIGHT", frame, "BOTTOMRIGHT", -1, 1)
threatbar:SetStatusBarTexture("Interface\\AddOns\\BasicThreatBar\\Flat")
threatbar:SetMinMaxValues(0, 100)
threatbar:SetValue(0)
threatbar:SetBackdrop({ 
	bgFile = "Interface\\AddOns\\BasicThreatBar\\Flat",
	insets = {left = 0, right = 0, top = 0, bottom = 0}
})
threatbar:SetBackdropColor(0, 0, 0, .35)

local font1 = threatbar:CreateFontString("UnitName", "ARTWORK", "GameFontNormal")

-- change name position here available: BOTTOMRIGHT,BOTTOMLEFT,TOPLEFT,CENTER
font1:SetPoint("TOPRIGHT", threatbar, "TOPRIGHT", -3, 15)

-- change Font here
font1:SetFont("Fonts\\ARKai_T.TTF", 12)

local font2 = threatbar:CreateFontString("Percent", "OVERLAY", "GameFontNormal")

-- change Percent position here available: BOTTOMRIGHT,BOTTOMLEFT,TOPLEFT,TOPRIGHT
font2:SetPoint("CENTER", threatbar, "CENTER")
font2:SetTextColor(1, 1, 1)

-- change Font here
font2:SetFont("Fonts\\ARKai_T.TTF", 12)


SLASH_ThreatBar1 = "/btb";
local function handler(msg, editbox)
	if (msg=="show") then
		frame:Show()
		hidden = nil
	elseif (msg=="hide") then
		frame:Hide()
		hidden = true
	--[[elseif (msg=="lock") then
	frame:EnableMouse(nil)
	frame:SetMovable(nil)
	frame:SetResizable(nil)
	frame:SetScript("OnEnter", nil)
	frame:SetScript("OnLeave", nil)]]
	end
end
SlashCmdList["ThreatBar"] = handler;


local function GetThreat(unitId, mobId)
	local _, _, threatpct, _, _ = UnitDetailedThreatSituation(unitId, mobId)
	if not threatpct then threatpct = 0 end
	return floor(threatpct)
end

local function GetThreatStatus(unitId, mobId)
	local _,status,_,_, _ = UnitDetailedThreatSituation(unitId, mobId)
	return status
end

local function GetTank(unitId, mobId)
	local isTanking,_,_,_, _ = UnitDetailedThreatSituation(unitId, mobId)
	if not isTanking then isTanking = 0 end
	return isTanking
end

local function GetThreatValue(unitId, mobId)
	local _, _, _, _, threatvalue = UnitDetailedThreatSituation(unitId, mobId)
	if not threatvalue then threatvalue = 0 end
	return threatvalue
end

local function GetClassColor(unit)
	local unitClass, englishClass = UnitClass(unit)
	local classColor = "ff848484" --Pets
	if englishClass == "DEATHKNIGHT" then
		classColor = "ffC41F3B"
		
	elseif englishClass == "DRUID" then
		classColor = "ffFF7D0A"
	
	elseif englishClass == "HUNTER" then
		classColor = "ffABD473"
	
	elseif englishClass == "MAGE" then
		classColor = "ff69CCF0"
	
	elseif englishClass == "PALADIN" then
		classColor = "ffF58CBA"
	
	elseif englishClass == "PRIEST" then
		classColor = "ffFFFFFF"
	
	elseif englishClass == "ROGUE" then
		classColor = "ffFFF569"
	
	elseif englishClass == "SHAMAN" then
		classColor = "ff2459FF"
	
	elseif englishClass == "WARLOCK" then
		classColor = "ff9482C9"
	
	elseif englishClass == "WARRIOR" then
		classColor = "ffC79C6E"
	end
	return classColor
end

local function UpdateDisplay()
	font1:SetText("")
	font2:SetText("")
	--icon:Hide()
	threatbar:SetValue(0)
	threatbar:SetBackdropColor(0, 0, 0, .35)

	local status = nil
	local highUnit = ""
	local unitThreat = 0
	local highThreat = 0
	local tankName = nil
	local unitThreatValue = 0
	local playerThreatValue = 0
	local partynum = GetNumPartyMembers()
	local raidnum = GetNumRaidMembers()
	if hidden == true then -- hide frame
		frame:Hide()
	end
	if (partynum == 0 and raidnum == 0) and UnitCanAttack("player", "target") and not(UnitIsDead("target") or UnitIsFriend("player", "target") or UnitPlayerControlled("target")) -- Solo Target
	then			
		status = GetThreatStatus("player", "target")
		threatpct = GetThreat("player", "target")
		playerThreatValue = GetThreatValue("player", "target")
		if HasPetUI() then
			unitThreatValue = GetThreatValue("pet", "target")
			highThreat = GetThreat("pet", "target")
			highUnit = UnitName("pet")
			highUnitColor = GetClassColor("pet")
			unitTanking = GetTank("pet", "target")
			if unitTanking == 1 then
				unitTankingColor = GetClassColor("pet")
				tankName = UnitName("pet")
			end
		end
	elseif (partynum == 0 and raidnum == 0) and UnitCanAttack("player", "targettarget") and not (UnitCanAttack("player", "target") or UnitIsDead("targettarget") or UnitIsFriend("player", "targettarget") or UnitPlayerControlled("targettarget")) -- Solo Target of Target
	then
		status = GetThreatStatus("player", "targettarget")
		threatpct = GetThreat("player", "targettarget")
		playerThreatValue = GetThreatValue("player", "targettarget")
		if HasPetUI() then
			unitThreatValue = GetThreatValue("pet", "targettarget")
			highThreat = GetThreat("pet", "targettarget")
			highUnit = UnitName("pet")
			highUnitColor = GetClassColor("pet")
			unitTanking = GetTank("pet", "targettarget")
			if unitTanking == 1 then
				unitTankingColor = GetClassColor("pet")
				tankName = UnitName("pet")
			end
		end
	elseif (raidnum > 0) and UnitCanAttack("player", "target") and not (UnitIsDead("target") or UnitIsFriend("player", "target") or UnitPlayerControlled("target")) --Raid Target
	then 
		status = GetThreatStatus("player", "target")
		threatpct = GetThreat("player", "target")
		playerThreatValue = GetThreatValue("player", "target")
		for i = 1, (raidnum -1) do
			unitThreat = GetThreat("raid"..i, "target") 	
				if unitThreat > highThreat then 
					highThreat = unitThreat	
					highUnit = UnitName("raid"..i)
					highUnitColor = GetClassColor("raid"..i)
					unitThreatValue = GetThreatValue("raid"..i, "target")
				end
			unitThreat = GetThreat("raidpet"..i, "target")	
				if unitThreat > highThreat then 
					highThreat = unitThreat	
					highUnit = UnitName("raidpet"..i)
					highUnitColor = GetClassColor("pet")
					unitThreatValue = GetThreatValue("raidpet"..i, "target")
				end
			unitThreat = GetThreat("pet", "target")
				if unitThreat > highThreat then
					highThreat = unitThreat
					highUnit = UnitName("pet")
					highUnitColor = GetClassColor("pet")
					unitThreatValue = GetThreatValue("pet", "target")
				end
			unitTanking = GetTank("raid"..i, "target")
			if unitTanking == 1 then
				unitTankingColor = GetClassColor("raid"..i)
				tankName = UnitName("raid"..i)
			end
			unitTanking = GetTank("raidpet"..i, "target")
			if unitTanking == 1 then
				unitTankingColor = GetClassColor("raidpet"..i)
				tankName = UnitName("raidpet"..i)
			end
			unitTanking = GetTank("pet", "target")
			if unitTanking == 1 then
				unitTankingColor = GetClassColor("pet")
				tankName = UnitName("pet")
			end
		end
	elseif (raidnum > 0) and UnitCanAttack("player", "targettarget") and not (UnitCanAttack("player", "target") or UnitIsDead("targettarget") or UnitIsFriend("player", "targettarget") or UnitPlayerControlled("targettarget")) --Raid Target of Target
	then
		status = GetThreatStatus("player", "targettarget")
		threatpct = GetThreat("player", "targettarget")
		playerThreatValue = GetThreatValue("player", "targettarget")		
		for i = 1, (raidnum -1) do
			unitThreat = GetThreat("raid"..i, "targettarget") 	
				if unitThreat > highThreat then 
					highThreat = unitThreat	
					highUnit = UnitName("raid"..i)
					highUnitColor = GetClassColor("raid"..i)
					unitThreatValue = GetThreatValue("raid"..i, "targettarget")
				end
			unitThreat = GetThreat("raidpet"..i, "targettarget")	
				if unitThreat > highThreat then 
					highThreat = unitThreat	
					highUnit = UnitName("raidpet"..i)
					highUnitColor = GetClassColor("pet")
					unitThreatValue = GetThreatValue("raidpet"..i, "targettarget")
				end
			unitThreat = GetThreat("pet", "targettarget")
				if unitThreat > highThreat then
					highThreat = unitThreat
					highUnit = UnitName("pet")
					highUnitColor = GetClassColor("pet")
					unitThreatValue = GetThreatValue("pet", "targettarget")
				end
			unitTanking = GetTank("raid"..i, "targettarget")
			if unitTanking == 1 then
				unitTankingColor = GetClassColor("raid"..i)
				tankName = UnitName("raid"..i)
			end
			unitTanking = GetTank("raidpet"..i, "targettarget")
			if unitTanking == 1 then
				unitTankingColor = GetClassColor("raidpet"..i)
				tankName = UnitName("raidpet"..i)
			end
			unitTanking = GetTank("pet", "targettarget")
			if unitTanking == 1 then
				unitTankingColor = GetClassColor("pet")
				tankName = UnitName("pet")
			end
		end
	elseif (partynum > 0) and UnitCanAttack("player", "target") and not (UnitIsDead("target") or UnitIsFriend("player", "target") or UnitPlayerControlled("target")) -- Party Target
	then 
		status = GetThreatStatus("player", "target")
		threatpct = GetThreat("player", "target")
		playerThreatValue = GetThreatValue("player", "target")
		for i = 1, partynum do
			unitThreat = GetThreat("party"..i, "target") 	
				if unitThreat > highThreat then 
					highThreat = unitThreat	
					highUnit = UnitName("party"..i)
					highUnitColor = GetClassColor("party"..i)
					unitThreatValue = GetThreatValue("party"..i, "target")
				end
			unitThreat = GetThreat("partypet"..i, "target")	
				if unitThreat > highThreat then 
					highThreat = unitThreat	
					highUnit = UnitName("partypet"..i)
					highUnitColor = GetClassColor("partypet"..i)
					unitThreatValue = GetThreatValue("partypet"..i, "target")
				end
			unitThreat = GetThreat("pet", "target")
				if unitThreat > highThreat then
					highThreat = unitThreat
					highUnit = UnitName("pet")
					highUnitColor = GetClassColor("pet")
					unitThreatValue = GetThreatValue("pet", "target")
				end
			unitTanking = GetTank("party"..i, "target")
			if unitTanking == 1 then
				unitTankingColor = GetClassColor("party"..i)
				tankName = UnitName("party"..i)
			end
			unitTanking = GetTank("partypet"..i, "target")
			if unitTanking == 1 then
				unitTankingColor = GetClassColor("partypet"..i)
				tankName = UnitName("partypet"..i)
			end
			unitTanking = GetTank("pet", "target")
			if unitTanking == 1 then
				unitTankingColor = GetClassColor("pet")
				tankName = UnitName("pet")
			end
		end
	elseif (partynum > 0) and UnitCanAttack("player", "targettarget") and not (UnitCanAttack("player", "target") or UnitIsDead("targettarget") or UnitIsFriend("player", "targettarget") or UnitPlayerControlled("targettarget")) --Party Target of Target
	then
		status = GetThreatStatus("player", "targettarget")
		threatpct = GetThreat("player", "targettarget")
		playerThreatValue = GetThreatValue("player", "targettarget")
		for i = 1, partynum do
			unitThreat = GetThreat("party"..i, "targettarget") 	
				if unitThreat > highThreat then 
					highThreat = unitThreat	
					highUnit = UnitName("party"..i)
					highUnitColor = GetClassColor("party"..i)
					unitThreatValue = GetThreatValue("party"..i, "targettarget")
				end
			unitThreat = GetThreat("partypet"..i, "targettarget")	
				if unitThreat > highThreat then 
					highThreat = unitThreat	
					highUnit = UnitName("partypet"..i)
					highUnitColor = GetClassColor("partypet"..i)
					unitThreatValue = GetThreatValue("partypet"..i, "targettarget")
				end
			unitThreat = GetThreat("pet", "targettarget")
				if unitThreat > highThreat then
					highThreat = unitThreat
					highUnit = UnitName("pet")
					highUnitColor = GetClassColor("pet")
					unitThreatValue = GetThreatValue("pet", "targettarget")
				end
			unitTanking = GetTank("party"..i, "targettarget")
			if unitTanking == 1 then
				unitTankingColor = GetClassColor("party"..i)
				tankName = UnitName("party"..i)
			end
			unitTanking = GetTank("partypet"..i, "targettarget")
			if unitTanking == 1 then
				unitTankingColor = GetClassColor("partypet"..i)
				tankName = UnitName("partypet"..i)
			end
			unitTanking = GetTank("pet", "target")
			if unitTanking == 1 then
				unitTankingColor = GetClassColor("pet")
				tankName = UnitName("pet")
			end
		end
	end
	if status then -- show frame
		--icon:Show()
		if hidden == true and not frame:IsShown() then
			frame:Show()
		end
	end
	if status == 0
	then
		--icon:SetTexCoord(GetTexCoordsForRoleSmallCircle("DAMAGER"))
		font2:SetText(string.format("%d %%", threatpct ))
		threatbar:SetValue(threatpct)
		threatbar:SetStatusBarColor(0, 1, 0, 1)

		if tankName
		then
			threatValuediff = ((unitThreatValue - playerThreatValue) / 100000 )
			font1:SetText(string.format("|c%s%s|r", unitTankingColor, tankName ))
			font2:SetText(string.format("%2.1fk | %d %%", threatValuediff, threatpct ))
			threatbar:SetValue(threatpct)
		end
	elseif status == 1
	then
		--icon:SetTexCoord(GetTexCoordsForRoleSmallCircle("DAMAGER"))
		font2:SetText(string.format("%d %%", threatpct ))
		threatbar:SetValue(threatpct)
		threatbar:SetStatusBarColor(1, 1, 0, 1)

		if tankName
		then
			threatValuediff = ((unitThreatValue - playerThreatValue) / 100000 )
			font1:SetText(string.format("|c%s%s|r", unitTankingColor, tankName ))
			font2:SetText(string.format("%2.1fk | %d %%", threatValuediff, threatpct ))
			threatbar:SetValue(threatpct)
		end
	elseif status == 2
	then
		--icon:SetTexCoord(GetTexCoordsForRoleSmallCircle("TANK"))
		font2:SetText("低仇恨值!")
		threatbar:SetValue(threatpct)
		threatbar:SetStatusBarColor(1, .5, 0, 1)

		if highThreat ~= 0
		then
			threatValuediff = ((playerThreatValue - unitThreatValue) / 100000 )
			threatdiff = (100 - highThreat)
			font1:SetText(string.format("|c%s%s|r", highUnitColor, highUnit ))
			font2:SetText(string.format("%2.1fk | %s %%", threatValuediff, threatdiff ))
			threatbar:SetValue(threatdiff)
			threatbar:SetBackdropColor(1, .5, 0, .4)
		end	
	elseif status == 3
	then
		--icon:SetTexCoord(GetTexCoordsForRoleSmallCircle("TANK"))
		font2:SetText("OT!")
		threatbar:SetValue(threatpct)
		threatbar:SetStatusBarColor(1, 0, 0, 1)

		if highThreat ~= 0
		then
			threatValuediff = ((playerThreatValue - unitThreatValue) / 100000 )
			threatdiff = (100 - highThreat)
			font1:SetText(string.format("|c%s%s|r", highUnitColor, highUnit ))
			font2:SetText(string.format("%2.1fk | %s %%", threatValuediff, threatdiff ))
			threatbar:SetValue(threatdiff)
			threatbar:SetBackdropColor(1, 0, 0, .4)
		end
	end
end

frame:SetScript("OnEvent", function() UpdateDisplay() end )

