/*
 * Decompiled with CFR 0.152.
 */
package mobac.mapsources.mappacks.openstreetmap;

import java.io.IOException;
import java.util.concurrent.Semaphore;
import mobac.exceptions.TileException;
import mobac.mapsources.mappacks.openstreetmap.AbstractOsmMapSource;
import mobac.program.interfaces.HttpMapSource;
import mobac.program.interfaces.MapSource;

public class Mapnik
extends AbstractOsmMapSource {
    private static final String MAP_MAPNIK = "http://tile.openstreetmap.org";
    private static final Semaphore SEM = new Semaphore(2);

    public Mapnik() {
        super("Mapnik");
        this.maxZoom = 16;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getTileData(int zoom, int x, int y, MapSource.LoadMethod loadMethod) throws IOException, TileException, InterruptedException {
        SEM.acquire();
        try {
            byte[] byArray = super.getTileData(zoom, x, y, loadMethod);
            return byArray;
        }
        finally {
            SEM.release();
        }
    }

    @Override
    public String getTileUrl(int zoom, int tilex, int tiley) {
        return MAP_MAPNIK + super.getTileUrl(zoom, tilex, tiley);
    }

    public HttpMapSource.TileUpdate getTileUpdate() {
        return HttpMapSource.TileUpdate.IfNoneMatch;
    }

    public String toString() {
        return "OpenStreetMap Mapnik";
    }
}

