/*
 * Decompiled with CFR 0.152.
 */
package mobac.mapsources.mappacks.openstreetmap;

import java.io.IOException;
import java.util.concurrent.Semaphore;
import mobac.exceptions.TileException;
import mobac.mapsources.mappacks.openstreetmap.AbstractOsmMapSource;
import mobac.program.interfaces.HttpMapSource;
import mobac.program.interfaces.MapSource;
import mobac.program.model.TileImageType;

public class MapQuest
extends AbstractOsmMapSource {
    private static String[] SERVERS = new String[]{"otile1", "otile2", "otile3", "otile4"};
    private static int SERVER_NUM = 0;
    private static final Semaphore SEM = new Semaphore(2);

    public MapQuest() {
        super("MapQuest");
        this.minZoom = 0;
        this.maxZoom = 18;
        this.tileUpdate = HttpMapSource.TileUpdate.IfModifiedSince;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getTileData(int zoom, int x, int y, MapSource.LoadMethod loadMethod) throws IOException, TileException, InterruptedException {
        SEM.acquire();
        try {
            byte[] byArray = super.getTileData(zoom, x, y, loadMethod);
            return byArray;
        }
        finally {
            SEM.release();
        }
    }

    @Override
    public TileImageType getTileImageType() {
        return TileImageType.JPG;
    }

    @Override
    public String getTileUrl(int zoom, int tilex, int tiley) {
        String server = SERVERS[SERVER_NUM];
        SERVER_NUM = (SERVER_NUM + 1) % SERVERS.length;
        String baseUrl = "http://" + server + ".mqcdn.com/tiles/1.0.0/osm";
        return baseUrl + super.getTileUrl(zoom, tilex, tiley);
    }

    public String toString() {
        return "OpenStreetMap MapQuest";
    }
}

