/*
 * Decompiled with CFR 0.152.
 */
package mobac.mapsources.mappacks.openstreetmap;

import java.awt.image.BufferedImage;
import java.io.IOException;
import mobac.exceptions.TileException;
import mobac.mapsources.AbstractHttpMapSource;
import mobac.mapsources.AbstractMultiLayerMapSource;
import mobac.program.interfaces.HttpMapSource;
import mobac.program.interfaces.MapSource;
import mobac.program.model.TileImageType;

public class Hikebikemap
extends AbstractMultiLayerMapSource {
    public Hikebikemap() {
        super("OpenStreetMap Hikebikemap.de", TileImageType.PNG);
        this.mapSources = new MapSource[]{new HikebikemapBase(), new HikebikemapRelief()};
        this.initializeValues();
    }

    public static class HikebikemapRelief
    extends AbstractHttpMapSource {
        public HikebikemapRelief() {
            super("HikebikemapRelief", 0, 17, TileImageType.PNG, HttpMapSource.TileUpdate.None);
        }

        public String getTileUrl(int zoom, int tilex, int tiley) {
            return "http://toolserver.org/~cmarqu/hill/" + zoom + "/" + tilex + "/" + tiley + ".png";
        }

        public BufferedImage getTileImage(int zoom, int x, int y, MapSource.LoadMethod loadMethod) throws IOException, TileException, InterruptedException {
            if (zoom > 16) {
                return null;
            }
            return super.getTileImage(zoom, x, y, loadMethod);
        }
    }

    public static class HikebikemapBase
    extends AbstractHttpMapSource {
        public HikebikemapBase() {
            super("HikebikemapTiles", 0, 17, TileImageType.PNG, HttpMapSource.TileUpdate.None);
        }

        public String toString() {
            return "OpenStreetMap Hikebikemap Map";
        }

        public String getTileUrl(int zoom, int tilex, int tiley) {
            return "http://toolserver.org/tiles/hikebike/" + zoom + "/" + tilex + "/" + tiley + ".png";
        }
    }
}

