/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tidy;

import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Stack;
import java.util.Vector;
import org.w3c.tidy.AttVal;
import org.w3c.tidy.AttributeTable;
import org.w3c.tidy.Configuration;
import org.w3c.tidy.EntityTable;
import org.w3c.tidy.IStack;
import org.w3c.tidy.MutableBoolean;
import org.w3c.tidy.MutableInteger;
import org.w3c.tidy.MutableObject;
import org.w3c.tidy.Node;
import org.w3c.tidy.ParserImpl;
import org.w3c.tidy.Report;
import org.w3c.tidy.StreamIn;
import org.w3c.tidy.Style;

public class Lexer {
    public StreamIn in;
    public PrintWriter errout;
    public short badAccess;
    public short badLayout;
    public short badChars;
    public short badForm;
    public short warnings;
    public short errors;
    public int lines;
    public int columns;
    public boolean waswhite;
    public boolean pushed;
    public boolean insertspace;
    public boolean excludeBlocks;
    public boolean exiled;
    public boolean isvoyager;
    public short versions;
    public int doctype;
    public boolean badDoctype;
    public int txtstart;
    public int txtend;
    public short state;
    public Node token;
    public byte[] lexbuf;
    public int lexlength;
    public int lexsize;
    public Node inode;
    public int insert;
    public Stack istack;
    public int istackbase;
    public Style styles;
    public Configuration configuration;
    protected int seenBodyEndTag;
    private Vector nodeList;
    private static short[] lexmap = new short[128];
    private static W3CVersionInfo[] W3CVersion;

    public Lexer(StreamIn streamIn, Configuration configuration) {
        this.in = streamIn;
        this.lines = 1;
        this.columns = 1;
        this.state = 0;
        this.badAccess = 0;
        this.badLayout = 0;
        this.badChars = 0;
        this.badForm = 0;
        this.warnings = 0;
        this.errors = 0;
        this.waswhite = false;
        this.pushed = false;
        this.insertspace = false;
        this.exiled = false;
        this.isvoyager = false;
        this.versions = (short)479;
        this.doctype = 0;
        this.badDoctype = false;
        this.txtstart = 0;
        this.txtend = 0;
        this.token = null;
        this.lexbuf = null;
        this.lexlength = 0;
        this.lexsize = 0;
        this.inode = null;
        this.insert = -1;
        this.istack = new Stack();
        this.istackbase = 0;
        this.styles = null;
        this.configuration = configuration;
        this.seenBodyEndTag = 0;
        this.nodeList = new Vector();
    }

    public Node newNode() {
        Node node = new Node();
        this.nodeList.addElement(node);
        return node;
    }

    public Node newNode(short s, byte[] byArray, int n, int n2) {
        Node node = new Node(s, byArray, n, n2);
        this.nodeList.addElement(node);
        return node;
    }

    public Node newNode(short s, byte[] byArray, int n, int n2, String string) {
        Node node = new Node(s, byArray, n, n2, string, this.configuration.tt);
        this.nodeList.addElement(node);
        return node;
    }

    public Node cloneNode(Node node) {
        Node node2 = (Node)node.clone();
        this.nodeList.addElement(node2);
        AttVal attVal = node2.attributes;
        while (attVal != null) {
            if (attVal.asp != null) {
                this.nodeList.addElement(attVal.asp);
            }
            if (attVal.php != null) {
                this.nodeList.addElement(attVal.php);
            }
            attVal = attVal.next;
        }
        return node2;
    }

    public AttVal cloneAttributes(AttVal attVal) {
        AttVal attVal2;
        AttVal attVal3 = attVal2 = (AttVal)attVal.clone();
        while (attVal3 != null) {
            if (attVal3.asp != null) {
                this.nodeList.addElement(attVal3.asp);
            }
            if (attVal3.php != null) {
                this.nodeList.addElement(attVal3.php);
            }
            attVal3 = attVal3.next;
        }
        return attVal2;
    }

    protected void updateNodeTextArrays(byte[] byArray, byte[] byArray2) {
        for (int i = 0; i < this.nodeList.size(); ++i) {
            Node node = (Node)this.nodeList.elementAt(i);
            if (node.textarray != byArray) continue;
            node.textarray = byArray2;
        }
    }

    public Node newLineNode() {
        Node node = this.newNode();
        node.textarray = this.lexbuf;
        node.start = this.lexsize;
        this.addCharToLexer(10);
        node.end = this.lexsize;
        return node;
    }

    public static byte[] getBytes(String string) {
        try {
            return string.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new Error("string to UTF-8 conversion failed: " + unsupportedEncodingException.getMessage());
        }
    }

    public static String getString(byte[] byArray, int n, int n2) {
        try {
            return new String(byArray, n, n2, "UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new Error("UTF-8 to string conversion failed: " + unsupportedEncodingException.getMessage());
        }
    }

    public boolean endOfInput() {
        return this.in.isEndOfStream();
    }

    public void addByte(int n) {
        if (this.lexsize + 1 >= this.lexlength) {
            while (this.lexsize + 1 >= this.lexlength) {
                if (this.lexlength == 0) {
                    this.lexlength = 8192;
                    continue;
                }
                this.lexlength *= 2;
            }
            byte[] byArray = this.lexbuf;
            this.lexbuf = new byte[this.lexlength];
            if (byArray != null) {
                System.arraycopy(byArray, 0, this.lexbuf, 0, byArray.length);
                this.updateNodeTextArrays(byArray, this.lexbuf);
            }
        }
        this.lexbuf[this.lexsize++] = (byte)n;
        this.lexbuf[this.lexsize] = 0;
    }

    public void changeChar(byte by) {
        if (this.lexsize > 0) {
            this.lexbuf[this.lexsize - 1] = by;
        }
    }

    public void addCharToLexer(int n) {
        if (n < 128) {
            this.addByte(n);
        } else if (n <= 2047) {
            this.addByte(0xC0 | n >> 6);
            this.addByte(0x80 | n & 0x3F);
        } else if (n <= 65535) {
            this.addByte(0xE0 | n >> 12);
            this.addByte(0x80 | n >> 6 & 0x3F);
            this.addByte(0x80 | n & 0x3F);
        } else if (n <= 0x1FFFFF) {
            this.addByte(0xF0 | n >> 18);
            this.addByte(0x80 | n >> 12 & 0x3F);
            this.addByte(0x80 | n >> 6 & 0x3F);
            this.addByte(0x80 | n & 0x3F);
        } else {
            this.addByte(0xF8 | n >> 24);
            this.addByte(0x80 | n >> 18 & 0x3F);
            this.addByte(0x80 | n >> 12 & 0x3F);
            this.addByte(0x80 | n >> 6 & 0x3F);
            this.addByte(0x80 | n & 0x3F);
        }
    }

    public void parseEntity(short s) {
        int n;
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        int n2 = this.lexsize - 1;
        int n3 = this.in.curcol - 1;
        while ((n = this.in.readChar()) != -1) {
            if (n == 59) {
                bl2 = true;
                break;
            }
            if (bl && n == 35) {
                this.addCharToLexer(n);
                bl = false;
                bl3 = true;
                continue;
            }
            bl = false;
            short s2 = Lexer.MAP((char)n);
            if (bl3 && (n == 120 || (s2 & 1) != 0)) {
                this.addCharToLexer(n);
                continue;
            }
            if (!bl3 && (s2 & 4) != 0) {
                this.addCharToLexer(n);
                continue;
            }
            this.in.ungetChar(n);
            break;
        }
        String string = Lexer.getString(this.lexbuf, n2, this.lexsize - n2);
        int n4 = EntityTable.getDefaultEntityTable().entityCode(string);
        if (n4 <= 0) {
            this.lines = this.in.curline;
            this.columns = n3;
            if (this.lexsize > n2 + 1) {
                Report.entityError(this, (short)2, string, n4);
                if (bl2) {
                    this.addCharToLexer(59);
                }
            } else {
                Report.entityError(this, (short)3, string, n4);
            }
        } else {
            if (n != 59) {
                this.lines = this.in.curline;
                this.columns = n3;
                Report.entityError(this, (short)1, string, n);
            }
            this.lexsize = n2;
            if (n4 == 160 && (s & 2) != 0) {
                n4 = 32;
            }
            this.addCharToLexer(n4);
            if (n4 == 38 && !this.configuration.QuoteAmpersand) {
                this.addCharToLexer(97);
                this.addCharToLexer(109);
                this.addCharToLexer(112);
                this.addCharToLexer(59);
            }
        }
    }

    public char parseTagName() {
        int n = this.lexbuf[this.txtstart];
        short s = Lexer.MAP((char)n);
        if (!this.configuration.XmlTags && (s & 0x40) != 0) {
            this.lexbuf[this.txtstart] = (byte)(n += 32);
        }
        while ((n = this.in.readChar()) != -1 && ((s = Lexer.MAP((char)n)) & 4) != 0) {
            if (!this.configuration.XmlTags && (s & 0x40) != 0) {
                n += 32;
            }
            this.addCharToLexer(n);
        }
        this.txtend = this.lexsize;
        return (char)n;
    }

    public void addStringLiteral(String string) {
        for (int i = 0; i < string.length(); ++i) {
            this.addCharToLexer(string.charAt(i));
        }
    }

    public short HTMLVersion() {
        short s = this.versions;
        if ((s & 1) != 0) {
            return 1;
        }
        if ((s & 2) != 0) {
            return 2;
        }
        if ((s & 4) != 0) {
            return 4;
        }
        if ((s & 8) != 0) {
            return 8;
        }
        if ((s & 0x10) != 0) {
            return 16;
        }
        return 0;
    }

    public String HTMLVersionName() {
        short s = this.apparentVersion();
        for (int i = 0; i < W3CVersion.length; ++i) {
            if (s != Lexer.W3CVersion[i].code) continue;
            if (this.isvoyager) {
                return Lexer.W3CVersion[i].voyagerName;
            }
            return Lexer.W3CVersion[i].name;
        }
        return null;
    }

    public boolean addGenerator(Node node) {
        Node node2 = node.findHEAD(this.configuration.tt);
        if (node2 != null) {
            Node node3 = node2.content;
            while (node3 != null) {
                AttVal attVal;
                if (node3.tag == this.configuration.tt.tagMeta && (attVal = node3.getAttrByName("name")) != null && attVal.value != null && Lexer.wstrcasecmp(attVal.value, "generator") == 0 && (attVal = node3.getAttrByName("content")) != null && attVal.value != null && attVal.value.length() >= 9 && Lexer.wstrcasecmp(attVal.value.substring(0, 9), "HTML Tidy") == 0) {
                    return false;
                }
                node3 = node3.next;
            }
            node3 = this.inferredTag("meta");
            node3.addAttribute("content", "HTML Tidy, see www.w3.org");
            node3.addAttribute("name", "generator");
            Node.insertNodeAtStart(node2, node3);
            return true;
        }
        return false;
    }

    private static boolean findBadSubString(String string, String string2, int n) {
        int n2 = string.length();
        int n3 = 0;
        while (n2 < n) {
            String string3 = string2.substring(n3, n3 + n2);
            if (Lexer.wstrcasecmp(string, string3) == 0) {
                return !string3.equals(string.substring(0, n2));
            }
            ++n3;
            --n;
        }
        return false;
    }

    public boolean checkDocTypeKeyWords(Node node) {
        int n = node.end - node.start;
        String string = Lexer.getString(this.lexbuf, node.start, n);
        return !Lexer.findBadSubString("SYSTEM", string, n) && !Lexer.findBadSubString("PUBLIC", string, n) && !Lexer.findBadSubString("//DTD", string, n) && !Lexer.findBadSubString("//W3C", string, n) && !Lexer.findBadSubString("//EN", string, n);
    }

    public short findGivenVersion(Node node) {
        String string = Lexer.getString(this.lexbuf, node.start, 5);
        if (Lexer.wstrcasecmp(string, "html ") != 0) {
            return 0;
        }
        if (!this.checkDocTypeKeyWords(node)) {
            Report.warning(this, node, null, (short)32);
        }
        if (Lexer.wstrcasecmp(string = Lexer.getString(this.lexbuf, node.start + 5, 7), "SYSTEM ") == 0) {
            if (!string.substring(0, 6).equals("SYSTEM")) {
                System.arraycopy(Lexer.getBytes("SYSTEM"), 0, this.lexbuf, node.start + 5, 6);
            }
            return 0;
        }
        if (Lexer.wstrcasecmp(string, "PUBLIC ") == 0) {
            if (!string.substring(0, 6).equals("PUBLIC")) {
                System.arraycopy(Lexer.getBytes("PUBLIC "), 0, this.lexbuf, node.start + 5, 6);
            }
        } else {
            this.badDoctype = true;
        }
        for (int i = node.start; i < node.end; ++i) {
            int n;
            if (this.lexbuf[i] != 34) continue;
            string = Lexer.getString(this.lexbuf, i + 1, 12);
            String string2 = Lexer.getString(this.lexbuf, i + 1, 13);
            if (string.equals("-//W3C//DTD ")) {
                int n2;
                for (n2 = i + 13; n2 < node.end && this.lexbuf[n2] != 47; ++n2) {
                }
                int n3 = n2 - i - 13;
                String string3 = Lexer.getString(this.lexbuf, i + 13, n3);
                for (n2 = 1; n2 < W3CVersion.length; ++n2) {
                    String string4 = Lexer.W3CVersion[n2].name;
                    if (n3 != string4.length() || !string4.equals(string3)) continue;
                    return Lexer.W3CVersion[n2].code;
                }
                break;
            }
            if (!string2.equals("-//IETF//DTD ")) break;
            for (n = i + 14; n < node.end && this.lexbuf[n] != 47; ++n) {
            }
            int n4 = n - i - 14;
            String string5 = Lexer.getString(this.lexbuf, i + 14, n4);
            String string6 = Lexer.W3CVersion[0].name;
            if (n4 != string6.length() || !string6.equals(string5)) break;
            return Lexer.W3CVersion[0].code;
        }
        return 0;
    }

    public void fixHTMLNameSpace(Node node, String string) {
        Node node2 = node.content;
        while (node2 != null && node2.tag != this.configuration.tt.tagHtml) {
            node2 = node2.next;
        }
        if (node2 != null) {
            AttVal attVal = null;
            AttVal attVal2 = node2.attributes;
            while (attVal2 != null && !attVal2.attribute.equals("xmlns")) {
                attVal = attVal2;
                attVal2 = attVal2.next;
            }
            if (attVal2 != null) {
                if (!attVal2.value.equals(string)) {
                    Report.warning(this, node2, null, (short)28);
                    attVal2.value = string;
                }
            } else {
                attVal2 = new AttVal(node2.attributes, null, 34, "xmlns", string);
                attVal2.dict = AttributeTable.getDefaultAttributeTable().findAttribute(attVal2);
                node2.attributes = attVal2;
            }
        }
    }

    public boolean setXHTMLDocType(Node node) {
        String string = " ";
        String string2 = "";
        String string3 = "http://www.w3.org/1999/xhtml";
        Node node2 = node.findDocType();
        if (this.configuration.docTypeMode == 0) {
            if (node2 != null) {
                Node.discardElement(node2);
            }
            return true;
        }
        if (this.configuration.docTypeMode == 1) {
            if ((this.versions & 4) != 0) {
                string = "-//W3C//DTD XHTML 1.0 Strict//EN";
                string2 = "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd";
            } else if ((this.versions & 0x1A) != 0) {
                string = "-//W3C//DTD XHTML 1.0 Transitional//EN";
                string2 = "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd";
            } else if ((this.versions & 0x10) != 0) {
                string = "-//W3C//DTD XHTML 1.0 Frameset//EN";
                string2 = "http://www.w3.org/TR/xhtml1/DTD/xhtml1-frameset.dtd";
            } else {
                string = "-//W3C//DTD XHTML 1.0 Transitional//EN";
                string2 = "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd";
            }
        } else if (this.configuration.docTypeMode == 2) {
            string = "-//W3C//DTD XHTML 1.0 Strict//EN";
            string2 = "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd";
        } else if (this.configuration.docTypeMode == 3) {
            string = "-//W3C//DTD XHTML 1.0 Transitional//EN";
            string2 = "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd";
        }
        this.fixHTMLNameSpace(node, string3);
        if (node2 == null) {
            node2 = this.newNode((short)1, this.lexbuf, 0, 0);
            node2.next = node.content;
            node2.parent = node;
            node2.prev = null;
            node.content = node2;
        }
        if (this.configuration.docTypeMode == 4 && this.configuration.docTypeStr != null) {
            string = this.configuration.docTypeStr;
            string2 = "";
        }
        this.txtstart = this.lexsize;
        this.txtend = this.lexsize;
        this.addStringLiteral("html PUBLIC ");
        if (string.charAt(0) == '\"') {
            this.addStringLiteral(string);
        } else {
            this.addStringLiteral("\"");
            this.addStringLiteral(string);
            this.addStringLiteral("\"");
        }
        if (string2.length() + 6 >= this.configuration.wraplen) {
            this.addStringLiteral("\n\"");
        } else {
            this.addStringLiteral("\n    \"");
        }
        this.addStringLiteral(string2);
        this.addStringLiteral("\"");
        this.txtend = this.lexsize;
        node2.start = this.txtstart;
        node2.end = this.txtend;
        return false;
    }

    public short apparentVersion() {
        switch (this.doctype) {
            case 0: {
                return this.HTMLVersion();
            }
            case 1: {
                if ((this.versions & 1) == 0) break;
                return 1;
            }
            case 2: {
                if ((this.versions & 2) == 0) break;
                return 2;
            }
            case 4: {
                if ((this.versions & 4) == 0) break;
                return 4;
            }
            case 8: {
                if ((this.versions & 8) == 0) break;
                return 8;
            }
            case 16: {
                if ((this.versions & 0x10) == 0) break;
                return 16;
            }
        }
        Report.warning(this, null, null, (short)23);
        return this.HTMLVersion();
    }

    public boolean fixDocType(Node node) {
        short s = 4;
        if (this.badDoctype) {
            Report.warning(this, null, null, (short)30);
        }
        if (this.configuration.XmlOut) {
            return true;
        }
        Node node2 = node.findDocType();
        if (this.configuration.docTypeMode == 0) {
            if (node2 != null) {
                Node.discardElement(node2);
            }
            return true;
        }
        if (this.configuration.docTypeMode == 2) {
            Node.discardElement(node2);
            node2 = null;
            s = 4;
        } else if (this.configuration.docTypeMode == 3) {
            Node.discardElement(node2);
            node2 = null;
            s = 8;
        } else if (this.configuration.docTypeMode == 1) {
            if (node2 != null) {
                if (this.doctype == 0) {
                    return false;
                }
                switch (this.doctype) {
                    case 0: {
                        return false;
                    }
                    case 1: {
                        if ((this.versions & 1) == 0) break;
                        return true;
                    }
                    case 2: {
                        if ((this.versions & 2) == 0) break;
                        return true;
                    }
                    case 4: {
                        if ((this.versions & 4) == 0) break;
                        return true;
                    }
                    case 8: {
                        if ((this.versions & 8) == 0) break;
                        return true;
                    }
                    case 16: {
                        if ((this.versions & 0x10) == 0) break;
                        return true;
                    }
                }
            }
            s = this.HTMLVersion();
        }
        if (s == 0) {
            return false;
        }
        if (this.configuration.XmlOut || this.configuration.XmlTags || this.isvoyager) {
            if (node2 != null) {
                Node.discardElement(node2);
            }
            for (int i = 0; i < W3CVersion.length; ++i) {
                if (s != Lexer.W3CVersion[i].code) continue;
                this.fixHTMLNameSpace(node, Lexer.W3CVersion[i].profile);
                break;
            }
            return true;
        }
        if (node2 == null) {
            node2 = this.newNode((short)1, this.lexbuf, 0, 0);
            node2.next = node.content;
            node2.parent = node;
            node2.prev = null;
            node.content = node2;
        }
        this.txtstart = this.lexsize;
        this.txtend = this.lexsize;
        this.addStringLiteral("html PUBLIC ");
        if (this.configuration.docTypeMode == 4 && this.configuration.docTypeStr != null) {
            this.addStringLiteral(this.configuration.docTypeStr);
        } else if (s == 1) {
            this.addStringLiteral("\"-//IETF//DTD HTML 2.0//EN\"");
        } else {
            this.addStringLiteral("\"-//W3C//DTD ");
            for (int i = 0; i < W3CVersion.length; ++i) {
                if (s != Lexer.W3CVersion[i].code) continue;
                this.addStringLiteral(Lexer.W3CVersion[i].name);
                break;
            }
            this.addStringLiteral("//EN\"");
        }
        this.txtend = this.lexsize;
        node2.start = this.txtstart;
        node2.end = this.txtend;
        return true;
    }

    public boolean fixXMLPI(Node node) {
        int n;
        if (node.content != null && node.content.type == 3 && this.lexbuf[n = node.content.start] == 120 && this.lexbuf[n + 1] == 109 && this.lexbuf[n + 2] == 108) {
            return true;
        }
        Node node2 = this.newNode((short)3, this.lexbuf, 0, 0);
        node2.next = node.content;
        if (node.content != null) {
            node.content.prev = node2;
            node2.next = node.content;
        }
        node.content = node2;
        this.txtstart = this.lexsize;
        this.txtend = this.lexsize;
        this.addStringLiteral("xml version=\"1.0\"");
        if (this.configuration.CharEncoding == 2) {
            this.addStringLiteral(" encoding=\"ISO-8859-1\"");
        }
        this.txtend = this.lexsize;
        node2.start = this.txtstart;
        node2.end = this.txtend;
        return false;
    }

    public Node inferredTag(String string) {
        Node node = this.newNode((short)5, this.lexbuf, this.txtstart, this.txtend, string);
        node.implicit = true;
        return node;
    }

    public static boolean expectsContent(Node node) {
        if (node.type != 5) {
            return false;
        }
        if (node.tag == null) {
            return true;
        }
        return (node.tag.model & 1) == 0;
    }

    public Node getCDATA(Node node) {
        int n;
        boolean bl = false;
        this.lines = this.in.curline;
        this.columns = this.in.curcol;
        this.waswhite = false;
        this.txtstart = this.lexsize;
        this.txtend = this.lexsize;
        int n2 = 0;
        int n3 = -1;
        while ((n = this.in.readChar()) != -1) {
            if (n == 47 && n2 == 60) {
                if (bl) {
                    this.lines = this.in.curline;
                    this.columns = this.in.curcol - 3;
                    Report.warning(this, null, null, (short)27);
                }
                n3 = this.lexsize + 1;
                bl = true;
            } else if (n == 62 && n3 >= 0) {
                String string;
                int n4 = this.lexsize - n3;
                if (n4 == node.element.length() && Lexer.wstrcasecmp(string = Lexer.getString(this.lexbuf, n3, n4), node.element) == 0) {
                    this.txtend = n3 - 2;
                    break;
                }
                this.lines = this.in.curline;
                this.columns = this.in.curcol - 3;
                Report.warning(this, null, null, (short)27);
                if (ParserImpl.isJavaScript(node)) {
                    for (int i = this.lexsize; i > n3 - 1; --i) {
                        this.lexbuf[i] = this.lexbuf[i - 1];
                    }
                    this.lexbuf[n3 - 1] = 92;
                }
                n3 = -1;
            } else if (n == 13) {
                n = this.in.readChar();
                if (n != 10) {
                    this.in.ungetChar(n);
                }
                n = 10;
            }
            this.addCharToLexer(n);
            this.txtend = ++this.lexsize;
            n2 = n;
        }
        if (n == -1) {
            Report.warning(this, node, null, (short)1);
        }
        if (this.txtend > this.txtstart) {
            this.token = this.newNode((short)4, this.lexbuf, this.txtstart, this.txtend);
            return this.token;
        }
        return null;
    }

    public void ungetToken() {
        this.pushed = true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public Node getToken(short s) {
        int n;
        block87: {
            block88: {
                n = 0;
                int n2 = 0;
                MutableBoolean mutableBoolean = new MutableBoolean();
                if (this.pushed && (this.token.type != 4 || this.insert == -1 && this.inode == null)) {
                    this.pushed = false;
                    return this.token;
                }
                if (this.insert != -1) return this.insertedToken();
                if (this.inode != null) {
                    return this.insertedToken();
                }
                this.lines = this.in.curline;
                this.columns = this.in.curcol;
                this.waswhite = false;
                this.txtstart = this.lexsize;
                this.txtend = this.lexsize;
                block14: while (true) {
                    block89: {
                        block90: {
                            short s2;
                            if ((n = this.in.readChar()) == -1) {
                                if (this.state != 0) break block87;
                                break block88;
                            }
                            if (this.insertspace && s != 0) {
                                this.addCharToLexer(32);
                                this.waswhite = true;
                                this.insertspace = false;
                            }
                            if (n == 13) {
                                n = this.in.readChar();
                                if (n != 10) {
                                    this.in.ungetChar(n);
                                }
                                n = 10;
                            }
                            this.addCharToLexer(n);
                            switch (this.state) {
                                case 0: {
                                    s2 = Lexer.MAP((char)n);
                                    if ((s2 & 8) != 0 && s == 0 && this.lexsize == this.txtstart + 1) {
                                        --this.lexsize;
                                        this.waswhite = false;
                                        this.lines = this.in.curline;
                                        this.columns = this.in.curcol;
                                        continue block14;
                                    }
                                    if (n == 60) {
                                        this.state = 1;
                                        continue block14;
                                    }
                                    if ((s2 & 8) != 0) {
                                        if (this.waswhite) {
                                            if (s == 2 || s == 3) continue block14;
                                            --this.lexsize;
                                            this.lines = this.in.curline;
                                            this.columns = this.in.curcol;
                                            continue block14;
                                        }
                                        this.waswhite = true;
                                        int n3 = n;
                                        if (s == 2 || s == 3 || n == 32) continue block14;
                                        this.changeChar((byte)32);
                                        continue block14;
                                    }
                                    if (n == 38 && s != 3) {
                                        this.parseEntity(s);
                                    }
                                    if (s == 0) {
                                        s = 1;
                                    }
                                    this.waswhite = false;
                                    continue block14;
                                }
                                case 1: {
                                    if (n == 47) {
                                        n = this.in.readChar();
                                        if (n == -1) {
                                            this.in.ungetChar(n);
                                            continue block14;
                                        }
                                        this.addCharToLexer(n);
                                        s2 = Lexer.MAP((char)n);
                                        if ((s2 & 2) != 0) {
                                            this.lexsize -= 3;
                                            this.txtend = this.lexsize;
                                            this.in.ungetChar(n);
                                            this.state = (short)2;
                                            this.lexbuf[this.lexsize] = 0;
                                            this.in.curcol -= 2;
                                            if (this.txtend <= this.txtstart) continue block14;
                                            if (s == 0 && this.lexbuf[this.lexsize - 1] == 32) {
                                                --this.lexsize;
                                                this.txtend = this.lexsize;
                                            }
                                            this.token = this.newNode((short)4, this.lexbuf, this.txtstart, this.txtend);
                                            return this.token;
                                        }
                                        this.waswhite = false;
                                        this.state = 0;
                                        continue block14;
                                    }
                                    if (s == 3) {
                                        this.waswhite = false;
                                        this.state = 0;
                                        continue block14;
                                    }
                                    if (n == 33) {
                                        n = this.in.readChar();
                                        if (n == 45) {
                                            n = this.in.readChar();
                                            if (n == 45) {
                                                this.state = (short)4;
                                                this.lexsize -= 2;
                                                this.txtend = this.lexsize;
                                                if (this.txtend > this.txtstart) {
                                                    this.token = this.newNode((short)4, this.lexbuf, this.txtstart, this.txtend);
                                                    return this.token;
                                                }
                                                this.txtstart = this.lexsize;
                                                continue block14;
                                            }
                                            Report.warning(this, null, null, (short)24);
                                            break block89;
                                        } else {
                                            if (n == 100 || n == 68) {
                                                this.state = (short)5;
                                                this.lexsize -= 2;
                                                this.txtend = this.lexsize;
                                                s = 0;
                                                break;
                                            }
                                            if (n == 91) {
                                                this.lexsize -= 2;
                                                this.state = (short)9;
                                                this.txtend = this.lexsize;
                                                if (this.txtend > this.txtstart) {
                                                    this.token = this.newNode((short)4, this.lexbuf, this.txtstart, this.txtend);
                                                    return this.token;
                                                }
                                                this.txtstart = this.lexsize;
                                                continue block14;
                                            }
                                        }
                                        break block89;
                                    } else {
                                        if (n == 63) {
                                            this.lexsize -= 2;
                                            this.state = (short)6;
                                            this.txtend = this.lexsize;
                                            if (this.txtend > this.txtstart) {
                                                this.token = this.newNode((short)4, this.lexbuf, this.txtstart, this.txtend);
                                                return this.token;
                                            }
                                            this.txtstart = this.lexsize;
                                            continue block14;
                                        }
                                        if (n == 37) {
                                            this.lexsize -= 2;
                                            this.state = (short)10;
                                            this.txtend = this.lexsize;
                                            if (this.txtend > this.txtstart) {
                                                this.token = this.newNode((short)4, this.lexbuf, this.txtstart, this.txtend);
                                                return this.token;
                                            }
                                            this.txtstart = this.lexsize;
                                            continue block14;
                                        }
                                        if (n == 35) {
                                            this.lexsize -= 2;
                                            this.state = (short)11;
                                            this.txtend = this.lexsize;
                                            if (this.txtend > this.txtstart) {
                                                this.token = this.newNode((short)4, this.lexbuf, this.txtstart, this.txtend);
                                                return this.token;
                                            }
                                            this.txtstart = this.lexsize;
                                            continue block14;
                                        }
                                        s2 = Lexer.MAP((char)n);
                                        if ((s2 & 2) != 0) {
                                            this.in.ungetChar(n);
                                            this.lexsize -= 2;
                                            this.txtend = this.lexsize;
                                            this.state = (short)3;
                                            if (this.txtend <= this.txtstart) continue block14;
                                            this.token = this.newNode((short)4, this.lexbuf, this.txtstart, this.txtend);
                                            return this.token;
                                        }
                                        this.state = 0;
                                        this.waswhite = false;
                                        continue block14;
                                    }
                                }
                                case 2: {
                                    this.txtstart = this.lexsize - 1;
                                    this.in.curcol += 2;
                                    n = this.parseTagName();
                                    this.token = this.newNode((short)6, this.lexbuf, this.txtstart, this.txtend, Lexer.getString(this.lexbuf, this.txtstart, this.txtend - this.txtstart));
                                    this.lexsize = this.txtstart;
                                    this.txtend = this.txtstart;
                                    while (n != 62 && (n = this.in.readChar()) != -1) {
                                    }
                                    if (n != -1) {
                                        this.state = 0;
                                        this.waswhite = false;
                                        return this.token;
                                    }
                                    this.in.ungetChar(n);
                                    continue block14;
                                }
                                case 3: {
                                    this.txtstart = this.lexsize - 1;
                                    n = this.parseTagName();
                                    mutableBoolean.value = false;
                                    AttVal attVal = null;
                                    this.token = this.newNode(mutableBoolean.value ? (short)7 : 5, this.lexbuf, this.txtstart, this.txtend, Lexer.getString(this.lexbuf, this.txtstart, this.txtend - this.txtstart));
                                    if (n != 62) {
                                        if (n == 47) {
                                            this.in.ungetChar(n);
                                        }
                                        attVal = this.parseAttrs(mutableBoolean);
                                    }
                                    if (mutableBoolean.value) {
                                        this.token.type = (short)7;
                                    }
                                    this.token.attributes = attVal;
                                    this.lexsize = this.txtstart;
                                    this.txtend = this.txtstart;
                                    if (Lexer.expectsContent(this.token) || this.token.tag == this.configuration.tt.tagBr) {
                                        n = this.in.readChar();
                                        if (n == 13) {
                                            n = this.in.readChar();
                                            if (n != 10) {
                                                this.in.ungetChar(n);
                                            }
                                        } else if (n != 10 && n != 12) {
                                            this.in.ungetChar(n);
                                        }
                                        this.waswhite = true;
                                    } else {
                                        this.waswhite = false;
                                    }
                                    this.state = 0;
                                    if (this.token.tag == null) {
                                        Report.error(this, null, this.token, (short)17);
                                        return this.token;
                                    }
                                    if (this.configuration.XmlTags) return this.token;
                                    this.versions = (short)(this.versions & this.token.tag.versions);
                                    if (!((this.token.tag.versions & 0x1C0) == 0 || this.configuration.MakeClean || this.token.tag != this.configuration.tt.tagNobr && this.token.tag != this.configuration.tt.tagWbr)) {
                                        Report.warning(this, null, this.token, (short)16);
                                    }
                                    if (this.token.tag.chkattrs != null) {
                                        this.token.checkUniqueAttributes(this);
                                        this.token.tag.chkattrs.check(this, this.token);
                                        return this.token;
                                    }
                                    this.token.checkAttributes(this);
                                    return this.token;
                                }
                                case 4: {
                                    if (n != 45) continue block14;
                                    n = this.in.readChar();
                                    this.addCharToLexer(n);
                                    if (n != 45) continue block14;
                                    do {
                                        if ((n = this.in.readChar()) == 62) {
                                            if (n2 != 0) {
                                                Report.warning(this, null, null, (short)24);
                                            }
                                            this.txtend = this.lexsize - 2;
                                            this.lexbuf[this.lexsize] = 0;
                                            this.state = 0;
                                            this.waswhite = false;
                                            this.token = this.newNode((short)2, this.lexbuf, this.txtstart, this.txtend);
                                            n = this.in.readChar();
                                            if (n == 13 && (n = this.in.readChar()) != 10) {
                                                this.token.linebreak = true;
                                            }
                                            if (n != 10) break block14;
                                            this.token.linebreak = true;
                                            return this.token;
                                        }
                                        if (n2 == 0) {
                                            this.lines = this.in.curline;
                                            this.columns = this.in.curcol - 3;
                                        }
                                        ++n2;
                                        if (this.configuration.FixComments) {
                                            this.lexbuf[this.lexsize - 2] = 61;
                                        }
                                        this.addCharToLexer(n);
                                    } while (n == 45);
                                    this.lexbuf[this.lexsize - 2] = 61;
                                    continue block14;
                                }
                                case 5: {
                                    s2 = Lexer.MAP((char)n);
                                    if ((s2 & 8) != 0) {
                                        if (this.waswhite) {
                                            --this.lexsize;
                                        }
                                        this.waswhite = true;
                                    } else {
                                        this.waswhite = false;
                                    }
                                    if (n != 62) continue block14;
                                    --this.lexsize;
                                    this.txtend = this.lexsize;
                                    this.lexbuf[this.lexsize] = 0;
                                    this.state = 0;
                                    this.waswhite = false;
                                    this.token = this.newNode((short)1, this.lexbuf, this.txtstart, this.txtend);
                                    this.doctype = this.findGivenVersion(this.token);
                                    return this.token;
                                }
                                case 6: {
                                    if (this.lexsize - this.txtstart == 3 && Lexer.getString(this.lexbuf, this.txtstart, 3).equals("php")) {
                                        this.state = (short)12;
                                        continue block14;
                                    }
                                    if (this.configuration.XmlPIs) {
                                        if (n != 63) continue block14;
                                        n = this.in.readChar();
                                        if (n == -1) {
                                            Report.warning(this, null, null, (short)31);
                                            this.in.ungetChar(n);
                                            continue block14;
                                        }
                                        this.addCharToLexer(n);
                                    }
                                    if (n != 62) continue block14;
                                    --this.lexsize;
                                    this.txtend = this.lexsize;
                                    this.lexbuf[this.lexsize] = 0;
                                    this.state = 0;
                                    this.waswhite = false;
                                    this.token = this.newNode((short)3, this.lexbuf, this.txtstart, this.txtend);
                                    return this.token;
                                }
                                case 10: {
                                    if (n != 37) continue block14;
                                    n = this.in.readChar();
                                    if (n == 62) {
                                        --this.lexsize;
                                        this.txtend = this.lexsize;
                                        this.lexbuf[this.lexsize] = 0;
                                        this.state = 0;
                                        this.waswhite = false;
                                        this.token = this.newNode((short)10, this.lexbuf, this.txtstart, this.txtend);
                                        return this.token;
                                    }
                                    this.in.ungetChar(n);
                                    continue block14;
                                }
                                case 11: {
                                    if (n != 35) continue block14;
                                    n = this.in.readChar();
                                    if (n == 62) {
                                        --this.lexsize;
                                        this.txtend = this.lexsize;
                                        this.lexbuf[this.lexsize] = 0;
                                        this.state = 0;
                                        this.waswhite = false;
                                        this.token = this.newNode((short)11, this.lexbuf, this.txtstart, this.txtend);
                                        return this.token;
                                    }
                                    this.in.ungetChar(n);
                                    continue block14;
                                }
                                case 12: {
                                    if (n != 63) continue block14;
                                    n = this.in.readChar();
                                    if (n == 62) {
                                        --this.lexsize;
                                        this.txtend = this.lexsize;
                                        this.lexbuf[this.lexsize] = 0;
                                        this.state = 0;
                                        this.waswhite = false;
                                        this.token = this.newNode((short)12, this.lexbuf, this.txtstart, this.txtend);
                                        return this.token;
                                    }
                                    this.in.ungetChar(n);
                                    continue block14;
                                }
                                case 9: {
                                    if (n == 91 && this.lexsize == this.txtstart + 6 && Lexer.getString(this.lexbuf, this.txtstart, 6).equals("CDATA[")) {
                                        this.state = (short)8;
                                        this.lexsize -= 6;
                                        continue block14;
                                    }
                                    if (n != 93) continue block14;
                                    n = this.in.readChar();
                                    if (n == 62) {
                                        --this.lexsize;
                                        this.txtend = this.lexsize;
                                        this.lexbuf[this.lexsize] = 0;
                                        this.state = 0;
                                        this.waswhite = false;
                                        this.token = this.newNode((short)9, this.lexbuf, this.txtstart, this.txtend);
                                        return this.token;
                                    }
                                    this.in.ungetChar(n);
                                    continue block14;
                                }
                                case 8: {
                                    if (n != 93) continue block14;
                                    n = this.in.readChar();
                                    if (n != 93) {
                                        this.in.ungetChar(n);
                                        continue block14;
                                    }
                                    n = this.in.readChar();
                                    if (n == 62) {
                                        --this.lexsize;
                                        this.txtend = this.lexsize;
                                        this.lexbuf[this.lexsize] = 0;
                                        this.state = 0;
                                        this.waswhite = false;
                                        this.token = this.newNode((short)8, this.lexbuf, this.txtstart, this.txtend);
                                        return this.token;
                                    }
                                    this.in.ungetChar(n);
                                    continue block14;
                                }
                                default: {
                                    continue block14;
                                }
                            }
                            do {
                                if ((n = this.in.readChar()) != -1 && n != 62) continue;
                                this.in.ungetChar(n);
                                break block90;
                            } while (((s2 = Lexer.MAP((char)n)) & 8) == 0);
                            do {
                                if ((n = this.in.readChar()) != -1 && n != 62) continue;
                                this.in.ungetChar(n);
                                break block90;
                            } while (((s2 = Lexer.MAP((char)n)) & 8) != 0);
                            this.in.ungetChar(n);
                        }
                        if (this.txtend > this.txtstart) {
                            this.token = this.newNode((short)4, this.lexbuf, this.txtstart, this.txtend);
                            return this.token;
                        }
                        this.txtstart = this.lexsize;
                        continue;
                    }
                    while ((n = this.in.readChar()) != 62) {
                        if (n != -1) continue;
                        this.in.ungetChar(n);
                        break;
                    }
                    this.lexsize -= 2;
                    this.lexbuf[this.lexsize] = 0;
                    this.state = 0;
                }
                this.in.ungetChar(n);
                return this.token;
            }
            this.txtend = this.lexsize;
            if (this.txtend <= this.txtstart) return null;
            this.in.ungetChar(n);
            if (this.lexbuf[this.lexsize - 1] == 32) {
                --this.lexsize;
                this.txtend = this.lexsize;
            }
            this.token = this.newNode((short)4, this.lexbuf, this.txtstart, this.txtend);
            return this.token;
        }
        if (this.state != 4) return null;
        if (n == -1) {
            Report.warning(this, null, null, (short)24);
        }
        this.txtend = this.lexsize;
        this.lexbuf[this.lexsize] = 0;
        this.state = 0;
        this.waswhite = false;
        this.token = this.newNode((short)2, this.lexbuf, this.txtstart, this.txtend);
        return this.token;
    }

    public Node parseAsp() {
        Node node = null;
        this.txtstart = this.lexsize;
        while (true) {
            int n = this.in.readChar();
            this.addCharToLexer(n);
            if (n != 37) continue;
            n = this.in.readChar();
            this.addCharToLexer(n);
            if (n == 62) break;
        }
        this.lexsize -= 2;
        this.txtend = this.lexsize;
        if (this.txtend > this.txtstart) {
            node = this.newNode((short)10, this.lexbuf, this.txtstart, this.txtend);
        }
        this.txtstart = this.txtend;
        return node;
    }

    public Node parsePhp() {
        Node node = null;
        this.txtstart = this.lexsize;
        while (true) {
            int n = this.in.readChar();
            this.addCharToLexer(n);
            if (n != 63) continue;
            n = this.in.readChar();
            this.addCharToLexer(n);
            if (n == 62) break;
        }
        this.lexsize -= 2;
        this.txtend = this.lexsize;
        if (this.txtend > this.txtstart) {
            node = this.newNode((short)12, this.lexbuf, this.txtstart, this.txtend);
        }
        this.txtstart = this.txtend;
        return node;
    }

    public String parseAttribute(MutableBoolean mutableBoolean, MutableObject mutableObject, MutableObject mutableObject2) {
        short s;
        int n = 0;
        int n2 = 0;
        mutableObject.setObject(null);
        mutableObject2.setObject(null);
        while (true) {
            if ((n2 = this.in.readChar()) == 47) {
                n2 = this.in.readChar();
                if (n2 == 62) {
                    mutableBoolean.value = true;
                    return null;
                }
                this.in.ungetChar(n2);
                n2 = 47;
                break;
            }
            if (n2 == 62) {
                return null;
            }
            if (n2 == 60) {
                n2 = this.in.readChar();
                if (n2 == 37) {
                    mutableObject.setObject(this.parseAsp());
                    return null;
                }
                if (n2 == 63) {
                    mutableObject2.setObject(this.parsePhp());
                    return null;
                }
                this.in.ungetChar(n2);
                Report.attrError(this, this.token, null, (short)5);
                return null;
            }
            if (n2 == 34 || n2 == 39) {
                Report.attrError(this, this.token, null, (short)10);
                continue;
            }
            if (n2 == -1) {
                Report.attrError(this, this.token, null, (short)31);
                this.in.ungetChar(n2);
                return null;
            }
            s = Lexer.MAP((char)n2);
            if ((s & 8) == 0) break;
        }
        n = this.lexsize;
        while (true) {
            if (n2 == 61 || n2 == 62) {
                this.in.ungetChar(n2);
                break;
            }
            if (n2 == 60 || n2 == -1) {
                this.in.ungetChar(n2);
                break;
            }
            s = Lexer.MAP((char)n2);
            if ((s & 8) != 0) break;
            if (!this.configuration.XmlTags && (s & 0x40) != 0) {
                n2 += 32;
            }
            this.addCharToLexer(n2);
            n2 = this.in.readChar();
        }
        int n3 = this.lexsize - n;
        String string = n3 > 0 ? Lexer.getString(this.lexbuf, n, n3) : null;
        this.lexsize = n;
        return string;
    }

    public int parseServerInstruction() {
        int n = 34;
        boolean bl = false;
        int n2 = this.in.readChar();
        this.addCharToLexer(n2);
        if (n2 == 37 || n2 == 63 || n2 == 64) {
            bl = true;
        }
        while ((n2 = this.in.readChar()) != -1) {
            short s;
            if (n2 == 62) {
                if (bl) {
                    this.addCharToLexer(n2);
                    break;
                }
                this.in.ungetChar(n2);
                break;
            }
            if (!bl && ((s = Lexer.MAP((char)n2)) & 8) != 0) break;
            this.addCharToLexer(n2);
            if (n2 == 34) {
                do {
                    n2 = this.in.readChar();
                    this.addCharToLexer(n2);
                } while (n2 != 34);
                n = 39;
                continue;
            }
            if (n2 != 39) continue;
            do {
                n2 = this.in.readChar();
                this.addCharToLexer(n2);
            } while (n2 != 39);
        }
        return n;
    }

    public String parseValue(String string, boolean bl, MutableBoolean mutableBoolean, MutableInteger mutableInteger) {
        short s;
        int n = 0;
        boolean bl2 = false;
        boolean bl3 = true;
        int n2 = 0;
        int n3 = 0;
        mutableInteger.value = 34;
        if (this.configuration.LiteralAttribs) {
            bl3 = false;
        }
        do {
            if ((n2 = this.in.readChar()) != -1) continue;
            this.in.ungetChar(n2);
            break;
        } while (((s = Lexer.MAP((char)n2)) & 8) != 0);
        if (n2 != 61) {
            this.in.ungetChar(n2);
            return null;
        }
        do {
            if ((n2 = this.in.readChar()) != -1) continue;
            this.in.ungetChar(n2);
            break;
        } while (((s = Lexer.MAP((char)n2)) & 8) != 0);
        if (n2 == 34 || n2 == 39) {
            n3 = n2;
        } else {
            if (n2 == 60) {
                int n4 = this.lexsize;
                this.addCharToLexer(n2);
                mutableInteger.value = this.parseServerInstruction();
                n = this.lexsize - n4;
                this.lexsize = n4;
                return n > 0 ? Lexer.getString(this.lexbuf, n4, n) : null;
            }
            this.in.ungetChar(n2);
        }
        int n5 = 0;
        int n6 = this.lexsize;
        n2 = 0;
        while (true) {
            int n7 = n2;
            n2 = this.in.readChar();
            if (n2 == -1) {
                Report.attrError(this, this.token, null, (short)31);
                this.in.ungetChar(n2);
                break;
            }
            if (n3 == 0) {
                if (n2 == 62) {
                    this.in.ungetChar(n2);
                    break;
                }
                if (n2 == 34 || n2 == 39) {
                    Report.attrError(this, this.token, null, (short)10);
                    break;
                }
                if (n2 == 60) {
                    Report.attrError(this, this.token, null, (short)5);
                }
                if (n2 == 47) {
                    n2 = this.in.readChar();
                    if (n2 == 62 && !AttributeTable.getDefaultAttributeTable().isUrl(string)) {
                        mutableBoolean.value = true;
                        this.in.ungetChar(n2);
                        break;
                    }
                    this.in.ungetChar(n2);
                    n2 = 47;
                }
            } else {
                if (n2 == n3) break;
                if (n2 == 13) {
                    n2 = this.in.readChar();
                    if (n2 != 10) {
                        this.in.ungetChar(n2);
                    }
                    n2 = 10;
                }
                if (n2 == 10 || n2 == 60 || n2 == 62) {
                    ++n5;
                }
                if (n2 == 62) {
                    bl2 = true;
                }
            }
            if (n2 == 38) {
                this.addCharToLexer(n2);
                this.parseEntity((short)0);
                continue;
            }
            if (n2 == 92 && (n2 = this.in.readChar()) != 10) {
                this.in.ungetChar(n2);
                n2 = 92;
            }
            if (((s = Lexer.MAP((char)n2)) & 8) != 0) {
                if (n3 == 0) break;
                if (bl3) {
                    n2 = 32;
                    if (n7 == 32) {
                        continue;
                    }
                }
            } else if (bl && (s & 0x40) != 0) {
                n2 += 32;
            }
            this.addCharToLexer(n2);
        }
        if (!(n5 <= 10 || !bl2 || !bl3 || AttributeTable.getDefaultAttributeTable().isScript(string) || AttributeTable.getDefaultAttributeTable().isUrl(string) && Lexer.getString(this.lexbuf, n6, 11).equals("javascript:"))) {
            Report.error(this, null, null, (short)11);
        }
        n = this.lexsize - n6;
        this.lexsize = n6;
        String string2 = n > 0 || n3 != 0 ? Lexer.getString(this.lexbuf, n6, n) : null;
        mutableInteger.value = n3 != 0 ? n3 : 34;
        return string2;
    }

    public static boolean isValidAttrName(String string) {
        char c = string.charAt(0);
        short s = Lexer.MAP(c);
        if ((s & 2) == 0) {
            return false;
        }
        for (int i = 1; i < string.length(); ++i) {
            c = string.charAt(i);
            s = Lexer.MAP(c);
            if ((s & 4) != 0) continue;
            return false;
        }
        return true;
    }

    public AttVal parseAttrs(MutableBoolean mutableBoolean) {
        MutableInteger mutableInteger = new MutableInteger();
        MutableObject mutableObject = new MutableObject();
        MutableObject mutableObject2 = new MutableObject();
        AttVal attVal = null;
        while (!this.endOfInput()) {
            AttVal attVal2;
            String string = this.parseAttribute(mutableBoolean, mutableObject, mutableObject2);
            if (string == null) {
                if (mutableObject.getObject() != null) {
                    attVal = attVal2 = new AttVal(attVal, null, (Node)mutableObject.getObject(), null, 0, null, null);
                    continue;
                }
                if (mutableObject2.getObject() == null) break;
                attVal = attVal2 = new AttVal(attVal, null, null, (Node)mutableObject2.getObject(), 0, null, null);
                continue;
            }
            String string2 = this.parseValue(string, false, mutableBoolean, mutableInteger);
            if (string != null && Lexer.isValidAttrName(string)) {
                attVal2 = new AttVal(attVal, null, null, null, mutableInteger.value, string, string2);
                attVal2.dict = AttributeTable.getDefaultAttributeTable().findAttribute(attVal2);
                attVal = attVal2;
                continue;
            }
            attVal2 = new AttVal(null, null, null, null, 0, string, string2);
            Report.attrError(this, this.token, string2, (short)4);
        }
        return attVal;
    }

    public void pushInline(Node node) {
        if (node.implicit) {
            return;
        }
        if (node.tag == null) {
            return;
        }
        if ((node.tag.model & 0x10) == 0) {
            return;
        }
        if ((node.tag.model & 0x800) != 0) {
            return;
        }
        if (node.tag != this.configuration.tt.tagFont && this.isPushed(node)) {
            return;
        }
        IStack iStack = new IStack();
        iStack.tag = node.tag;
        iStack.element = node.element;
        if (node.attributes != null) {
            iStack.attributes = this.cloneAttributes(node.attributes);
        }
        this.istack.push(iStack);
    }

    public void popInline(Node node) {
        if (node != null) {
            if (node.tag == null) {
                return;
            }
            if ((node.tag.model & 0x10) == 0) {
                return;
            }
            if ((node.tag.model & 0x800) != 0) {
                return;
            }
            if (node.tag == this.configuration.tt.tagA) {
                while (this.istack.size() > 0) {
                    IStack iStack = (IStack)this.istack.pop();
                    if (iStack.tag != this.configuration.tt.tagA) continue;
                }
                if (this.insert >= this.istack.size()) {
                    this.insert = -1;
                }
                return;
            }
        }
        if (this.istack.size() > 0) {
            IStack iStack = (IStack)this.istack.pop();
            if (this.insert >= this.istack.size()) {
                this.insert = -1;
            }
        }
    }

    public boolean isPushed(Node node) {
        for (int i = this.istack.size() - 1; i >= 0; --i) {
            IStack iStack = (IStack)this.istack.elementAt(i);
            if (iStack.tag != node.tag) continue;
            return true;
        }
        return false;
    }

    public int inlineDup(Node node) {
        int n = this.istack.size() - this.istackbase;
        if (n > 0) {
            this.insert = this.istackbase;
            this.inode = node;
        }
        return n;
    }

    public Node insertedToken() {
        if (this.insert == -1) {
            Node node = this.inode;
            this.inode = null;
            return node;
        }
        if (this.inode == null) {
            this.lines = this.in.curline;
            this.columns = this.in.curcol;
        }
        Node node = this.newNode((short)5, this.lexbuf, this.txtstart, this.txtend);
        node.implicit = true;
        IStack iStack = (IStack)this.istack.elementAt(this.insert);
        node.element = iStack.element;
        node.tag = iStack.tag;
        if (iStack.attributes != null) {
            node.attributes = this.cloneAttributes(iStack.attributes);
        }
        int n = this.insert;
        this.insert = ++n < this.istack.size() ? n : -1;
        return node;
    }

    public static int wstrcasecmp(String string, String string2) {
        return string.equalsIgnoreCase(string2) ? 0 : 1;
    }

    public static boolean wsubstr(String string, String string2) {
        int n = string.length();
        int n2 = string2.length();
        for (int i = 0; i <= n - n2; ++i) {
            if (!string2.equalsIgnoreCase(string.substring(i))) continue;
            return true;
        }
        return false;
    }

    public boolean canPrune(Node node) {
        if (node.type == 4) {
            return true;
        }
        if (node.content != null) {
            return false;
        }
        if (node.tag == this.configuration.tt.tagA && node.attributes != null) {
            return false;
        }
        if (node.tag == this.configuration.tt.tagP && !this.configuration.DropEmptyParas) {
            return false;
        }
        if (node.tag == null) {
            return false;
        }
        if ((node.tag.model & 0x200) != 0) {
            return false;
        }
        if (node.tag == this.configuration.tt.tagApplet) {
            return false;
        }
        if (node.tag == this.configuration.tt.tagObject) {
            return false;
        }
        return node.attributes == null || node.getAttrByName("id") == null && node.getAttrByName("name") == null;
    }

    public void fixId(Node node) {
        AttVal attVal = node.getAttrByName("name");
        AttVal attVal2 = node.getAttrByName("id");
        if (attVal != null) {
            if (attVal2 != null) {
                if (!attVal2.value.equals(attVal.value)) {
                    Report.attrError(this, node, "name", (short)11);
                }
            } else if (this.configuration.XmlOut) {
                node.addAttribute("id", attVal.value);
            }
        }
    }

    public void deferDup() {
        this.insert = -1;
        this.inode = null;
    }

    private static void mapStr(String string, short s) {
        for (int i = 0; i < string.length(); ++i) {
            char c;
            char c2 = c = string.charAt(i);
            lexmap[c2] = (short)(lexmap[c2] | s);
        }
    }

    private static short MAP(char c) {
        return c < '\u0080' ? lexmap[c] : (short)0;
    }

    public static char foldCase(char c, boolean bl, boolean bl2) {
        if (!bl2) {
            short s = Lexer.MAP(c);
            if (bl) {
                if ((s & 0x20) != 0) {
                    c = (char)(c + 65 - 97);
                }
            } else if ((s & 0x40) != 0) {
                c = (char)(c + 97 - 65);
            }
        }
        return c;
    }

    static {
        Lexer.mapStr("\r\n\f", (short)24);
        Lexer.mapStr(" \t", (short)8);
        Lexer.mapStr("-.:_", (short)4);
        Lexer.mapStr("0123456789", (short)5);
        Lexer.mapStr("abcdefghijklmnopqrstuvwxyz", (short)38);
        Lexer.mapStr("ABCDEFGHIJKLMNOPQRSTUVWXYZ", (short)70);
        W3CVersion = new W3CVersionInfo[]{new W3CVersionInfo("HTML 4.01", "XHTML 1.0 Strict", "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd", 4), new W3CVersionInfo("HTML 4.01 Transitional", "XHTML 1.0 Transitional", "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd", 8), new W3CVersionInfo("HTML 4.01 Frameset", "XHTML 1.0 Frameset", "http://www.w3.org/TR/xhtml1/DTD/xhtml1-frameset.dtd", 16), new W3CVersionInfo("HTML 4.0", "XHTML 1.0 Strict", "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd", 4), new W3CVersionInfo("HTML 4.0 Transitional", "XHTML 1.0 Transitional", "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd", 8), new W3CVersionInfo("HTML 4.0 Frameset", "XHTML 1.0 Frameset", "http://www.w3.org/TR/xhtml1/DTD/xhtml1-frameset.dtd", 16), new W3CVersionInfo("HTML 3.2", "XHTML 1.0 Transitional", "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd", 2), new W3CVersionInfo("HTML 2.0", "XHTML 1.0 Strict", "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd", 1)};
    }

    private static class W3CVersionInfo {
        String name;
        String voyagerName;
        String profile;
        short code;

        public W3CVersionInfo(String string, String string2, String string3, short s) {
            this.name = string;
            this.voyagerName = string2;
            this.profile = string3;
            this.code = s;
        }
    }
}

