/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.xml;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Hashtable;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.config.PropertySetter;
import org.apache.log4j.helpers.Loader;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.helpers.OptionConverter;
import org.apache.log4j.or.RendererMap;
import org.apache.log4j.spi.AppenderAttachable;
import org.apache.log4j.spi.Configurator;
import org.apache.log4j.spi.ErrorHandler;
import org.apache.log4j.spi.Filter;
import org.apache.log4j.spi.LoggerFactory;
import org.apache.log4j.spi.LoggerRepository;
import org.apache.log4j.spi.RendererSupport;
import org.apache.log4j.xml.Log4jEntityResolver;
import org.apache.log4j.xml.SAXErrorHandler;
import org.apache.log4j.xml.UnrecognizedElementHandler;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DOMConfigurator
implements Configurator {
    static final Class[] ONE_STRING_PARAM = new Class[]{class$java$lang$String == null ? (class$java$lang$String = DOMConfigurator.class$("java.lang.String")) : class$java$lang$String};
    Hashtable appenderBag = new Hashtable();
    Properties props;
    LoggerRepository repository;
    protected LoggerFactory catFactory = null;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$apache$log4j$spi$ErrorHandler;
    static /* synthetic */ Class class$org$apache$log4j$spi$Filter;
    static /* synthetic */ Class class$org$apache$log4j$spi$LoggerFactory;

    protected Appender findAppenderByName(Document doc, String appenderName) {
        Appender appender = (Appender)this.appenderBag.get(appenderName);
        if (appender != null) {
            return appender;
        }
        Element element = null;
        NodeList list = doc.getElementsByTagName("appender");
        for (int t = 0; t < list.getLength(); ++t) {
            Node node = list.item(t);
            NamedNodeMap map = node.getAttributes();
            Node attrNode = map.getNamedItem("name");
            if (!appenderName.equals(attrNode.getNodeValue())) continue;
            element = (Element)node;
            break;
        }
        if (element == null) {
            LogLog.error("No appender named [" + appenderName + "] could be found.");
            return null;
        }
        appender = this.parseAppender(element);
        this.appenderBag.put(appenderName, appender);
        return appender;
    }

    protected Appender findAppenderByReference(Element appenderRef) {
        String appenderName = this.subst(appenderRef.getAttribute("ref"));
        Document doc = appenderRef.getOwnerDocument();
        return this.findAppenderByName(doc, appenderName);
    }

    private static void parseUnrecognizedElement(Object instance, Element element, Properties props) throws Exception {
        boolean recognized = false;
        if (instance instanceof UnrecognizedElementHandler) {
            recognized = ((UnrecognizedElementHandler)instance).parseUnrecognizedElement(element, props);
        }
        if (!recognized) {
            LogLog.warn("Unrecognized element " + element.getNodeName());
        }
    }

    private static void quietParseUnrecognizedElement(Object instance, Element element, Properties props) {
        try {
            DOMConfigurator.parseUnrecognizedElement(instance, element, props);
        }
        catch (Exception ex) {
            LogLog.error("Error in extension content: ", ex);
        }
    }

    protected Appender parseAppender(Element appenderElement) {
        String className = this.subst(appenderElement.getAttribute("class"));
        LogLog.debug("Class name: [" + className + ']');
        try {
            Object instance = Loader.loadClass(className).newInstance();
            Appender appender = (Appender)instance;
            PropertySetter propSetter = new PropertySetter(appender);
            appender.setName(this.subst(appenderElement.getAttribute("name")));
            NodeList children = appenderElement.getChildNodes();
            int length = children.getLength();
            for (int loop = 0; loop < length; ++loop) {
                Node currentNode = children.item(loop);
                if (currentNode.getNodeType() != 1) continue;
                Element currentElement = (Element)currentNode;
                if (currentElement.getTagName().equals("param")) {
                    this.setParameter(currentElement, propSetter);
                    continue;
                }
                if (currentElement.getTagName().equals("layout")) {
                    appender.setLayout(this.parseLayout(currentElement));
                    continue;
                }
                if (currentElement.getTagName().equals("filter")) {
                    this.parseFilters(currentElement, appender);
                    continue;
                }
                if (currentElement.getTagName().equals("errorHandler")) {
                    this.parseErrorHandler(currentElement, appender);
                    continue;
                }
                if (currentElement.getTagName().equals("appender-ref")) {
                    String refName = this.subst(currentElement.getAttribute("ref"));
                    if (appender instanceof AppenderAttachable) {
                        AppenderAttachable aa = (AppenderAttachable)((Object)appender);
                        LogLog.debug("Attaching appender named [" + refName + "] to appender named [" + appender.getName() + "].");
                        aa.addAppender(this.findAppenderByReference(currentElement));
                        continue;
                    }
                    LogLog.error("Requesting attachment of appender named [" + refName + "] to appender named [" + appender.getName() + "] which does not implement org.apache.log4j.spi.AppenderAttachable.");
                    continue;
                }
                DOMConfigurator.parseUnrecognizedElement(instance, currentElement, this.props);
            }
            propSetter.activate();
            return appender;
        }
        catch (Exception oops) {
            LogLog.error("Could not create an Appender. Reported error follows.", oops);
            return null;
        }
    }

    protected void parseErrorHandler(Element element, Appender appender) {
        ErrorHandler eh = (ErrorHandler)OptionConverter.instantiateByClassName(this.subst(element.getAttribute("class")), class$org$apache$log4j$spi$ErrorHandler == null ? (class$org$apache$log4j$spi$ErrorHandler = DOMConfigurator.class$("org.apache.log4j.spi.ErrorHandler")) : class$org$apache$log4j$spi$ErrorHandler, null);
        if (eh != null) {
            eh.setAppender(appender);
            PropertySetter propSetter = new PropertySetter(eh);
            NodeList children = element.getChildNodes();
            int length = children.getLength();
            for (int loop = 0; loop < length; ++loop) {
                Node currentNode = children.item(loop);
                if (currentNode.getNodeType() != 1) continue;
                Element currentElement = (Element)currentNode;
                String tagName = currentElement.getTagName();
                if (tagName.equals("param")) {
                    this.setParameter(currentElement, propSetter);
                    continue;
                }
                if (tagName.equals("appender-ref")) {
                    eh.setBackupAppender(this.findAppenderByReference(currentElement));
                    continue;
                }
                if (tagName.equals("logger-ref")) {
                    String loggerName = currentElement.getAttribute("ref");
                    Logger logger = this.catFactory == null ? this.repository.getLogger(loggerName) : this.repository.getLogger(loggerName, this.catFactory);
                    eh.setLogger(logger);
                    continue;
                }
                if (tagName.equals("root-ref")) {
                    Logger root = this.repository.getRootLogger();
                    eh.setLogger(root);
                    continue;
                }
                DOMConfigurator.quietParseUnrecognizedElement(eh, currentElement, this.props);
            }
            propSetter.activate();
            appender.setErrorHandler(eh);
        }
    }

    protected void parseFilters(Element element, Appender appender) {
        String clazz = this.subst(element.getAttribute("class"));
        Filter filter = (Filter)OptionConverter.instantiateByClassName(clazz, class$org$apache$log4j$spi$Filter == null ? (class$org$apache$log4j$spi$Filter = DOMConfigurator.class$("org.apache.log4j.spi.Filter")) : class$org$apache$log4j$spi$Filter, null);
        if (filter != null) {
            PropertySetter propSetter = new PropertySetter(filter);
            NodeList children = element.getChildNodes();
            int length = children.getLength();
            for (int loop = 0; loop < length; ++loop) {
                Node currentNode = children.item(loop);
                if (currentNode.getNodeType() != 1) continue;
                Element currentElement = (Element)currentNode;
                String tagName = currentElement.getTagName();
                if (tagName.equals("param")) {
                    this.setParameter(currentElement, propSetter);
                    continue;
                }
                DOMConfigurator.quietParseUnrecognizedElement(filter, currentElement, this.props);
            }
            propSetter.activate();
            LogLog.debug("Adding filter of type [" + filter.getClass() + "] to appender named [" + appender.getName() + "].");
            appender.addFilter(filter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parseCategory(Element loggerElement) {
        Logger cat;
        String catName = this.subst(loggerElement.getAttribute("name"));
        String className = this.subst(loggerElement.getAttribute("class"));
        if ("".equals(className)) {
            LogLog.debug("Retreiving an instance of org.apache.log4j.Logger.");
            cat = this.catFactory == null ? this.repository.getLogger(catName) : this.repository.getLogger(catName, this.catFactory);
        } else {
            LogLog.debug("Desired logger sub-class: [" + className + ']');
            try {
                Class clazz = Loader.loadClass(className);
                Method getInstanceMethod = clazz.getMethod("getLogger", ONE_STRING_PARAM);
                cat = (Logger)getInstanceMethod.invoke(null, catName);
            }
            catch (Exception oops) {
                LogLog.error("Could not retrieve category [" + catName + "]. Reported error follows.", oops);
                return;
            }
        }
        Logger logger = cat;
        synchronized (logger) {
            boolean additivity = OptionConverter.toBoolean(this.subst(loggerElement.getAttribute("additivity")), true);
            LogLog.debug("Setting [" + cat.getName() + "] additivity to [" + additivity + "].");
            cat.setAdditivity(additivity);
            this.parseChildrenOfLoggerElement(loggerElement, cat, false);
        }
    }

    protected void parseCategoryFactory(Element factoryElement) {
        String className = this.subst(factoryElement.getAttribute("class"));
        if ("".equals(className)) {
            LogLog.error("Category Factory tag class attribute not found.");
            LogLog.debug("No Category Factory configured.");
        } else {
            LogLog.debug("Desired category factory: [" + className + ']');
            Object factory = OptionConverter.instantiateByClassName(className, class$org$apache$log4j$spi$LoggerFactory == null ? (class$org$apache$log4j$spi$LoggerFactory = DOMConfigurator.class$("org.apache.log4j.spi.LoggerFactory")) : class$org$apache$log4j$spi$LoggerFactory, null);
            if (factory instanceof LoggerFactory) {
                this.catFactory = (LoggerFactory)factory;
            } else {
                LogLog.error("Category Factory class " + className + " does not implement org.apache.log4j.LoggerFactory");
            }
            PropertySetter propSetter = new PropertySetter(factory);
            Element currentElement = null;
            Node currentNode = null;
            NodeList children = factoryElement.getChildNodes();
            int length = children.getLength();
            for (int loop = 0; loop < length; ++loop) {
                currentNode = children.item(loop);
                if (currentNode.getNodeType() != 1) continue;
                currentElement = (Element)currentNode;
                if (currentElement.getTagName().equals("param")) {
                    this.setParameter(currentElement, propSetter);
                    continue;
                }
                DOMConfigurator.quietParseUnrecognizedElement(factory, currentElement, this.props);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parseRoot(Element rootElement) {
        Logger root;
        Logger logger = root = this.repository.getRootLogger();
        synchronized (logger) {
            this.parseChildrenOfLoggerElement(rootElement, root, true);
        }
    }

    protected void parseChildrenOfLoggerElement(Element catElement, Logger cat, boolean isRoot) {
        PropertySetter propSetter = new PropertySetter(cat);
        cat.removeAllAppenders();
        NodeList children = catElement.getChildNodes();
        int length = children.getLength();
        for (int loop = 0; loop < length; ++loop) {
            Node currentNode = children.item(loop);
            if (currentNode.getNodeType() != 1) continue;
            Element currentElement = (Element)currentNode;
            String tagName = currentElement.getTagName();
            if (tagName.equals("appender-ref")) {
                Element appenderRef = (Element)currentNode;
                Appender appender = this.findAppenderByReference(appenderRef);
                String refName = this.subst(appenderRef.getAttribute("ref"));
                if (appender != null) {
                    LogLog.debug("Adding appender named [" + refName + "] to category [" + cat.getName() + "].");
                } else {
                    LogLog.debug("Appender named [" + refName + "] not found.");
                }
                cat.addAppender(appender);
                continue;
            }
            if (tagName.equals("level")) {
                this.parseLevel(currentElement, cat, isRoot);
                continue;
            }
            if (tagName.equals("priority")) {
                this.parseLevel(currentElement, cat, isRoot);
                continue;
            }
            if (tagName.equals("param")) {
                this.setParameter(currentElement, propSetter);
                continue;
            }
            DOMConfigurator.quietParseUnrecognizedElement(cat, currentElement, this.props);
        }
        propSetter.activate();
    }

    protected Layout parseLayout(Element layout_element) {
        String className = this.subst(layout_element.getAttribute("class"));
        LogLog.debug("Parsing layout of class: \"" + className + "\"");
        try {
            Object instance = Loader.loadClass(className).newInstance();
            Layout layout = (Layout)instance;
            PropertySetter propSetter = new PropertySetter(layout);
            NodeList params = layout_element.getChildNodes();
            int length = params.getLength();
            for (int loop = 0; loop < length; ++loop) {
                Node currentNode = params.item(loop);
                if (currentNode.getNodeType() != 1) continue;
                Element currentElement = (Element)currentNode;
                String tagName = currentElement.getTagName();
                if (tagName.equals("param")) {
                    this.setParameter(currentElement, propSetter);
                    continue;
                }
                DOMConfigurator.parseUnrecognizedElement(instance, currentElement, this.props);
            }
            propSetter.activate();
            return layout;
        }
        catch (Exception oops) {
            LogLog.error("Could not create the Layout. Reported error follows.", oops);
            return null;
        }
    }

    protected void parseRenderer(Element element) {
        String renderingClass = this.subst(element.getAttribute("renderingClass"));
        String renderedClass = this.subst(element.getAttribute("renderedClass"));
        if (this.repository instanceof RendererSupport) {
            RendererMap.addRenderer((RendererSupport)((Object)this.repository), renderedClass, renderingClass);
        }
    }

    protected void parseLevel(Element element, Logger logger, boolean isRoot) {
        String catName = logger.getName();
        if (isRoot) {
            catName = "root";
        }
        String priStr = this.subst(element.getAttribute("value"));
        LogLog.debug("Level value for " + catName + " is  [" + priStr + "].");
        if ("inherited".equalsIgnoreCase(priStr) || "null".equalsIgnoreCase(priStr)) {
            if (isRoot) {
                LogLog.error("Root level cannot be inherited. Ignoring directive.");
            } else {
                logger.setLevel(null);
            }
        } else {
            String className = this.subst(element.getAttribute("class"));
            if ("".equals(className)) {
                logger.setLevel(OptionConverter.toLevel(priStr, Level.DEBUG));
            } else {
                LogLog.debug("Desired Level sub-class: [" + className + ']');
                try {
                    Class clazz = Loader.loadClass(className);
                    Method toLevelMethod = clazz.getMethod("toLevel", ONE_STRING_PARAM);
                    Level pri = (Level)toLevelMethod.invoke(null, priStr);
                    logger.setLevel(pri);
                }
                catch (Exception oops) {
                    LogLog.error("Could not create level [" + priStr + "]. Reported error follows.", oops);
                    return;
                }
            }
        }
        LogLog.debug(catName + " level set to " + logger.getLevel());
    }

    protected void setParameter(Element elem, PropertySetter propSetter) {
        DOMConfigurator.setParameter(elem, propSetter, this.props);
    }

    public void doConfigure(final String filename, LoggerRepository repository) {
        ParseAction action = new ParseAction(){

            public Document parse(DocumentBuilder parser) throws SAXException, IOException {
                return parser.parse(new File(filename));
            }

            public String toString() {
                return "file [" + filename + "]";
            }
        };
        this.doConfigure(action, repository);
    }

    public void doConfigure(final URL url, LoggerRepository repository) {
        ParseAction action = new ParseAction(){

            public Document parse(DocumentBuilder parser) throws SAXException, IOException {
                return parser.parse(url.toString());
            }

            public String toString() {
                return "url [" + url.toString() + "]";
            }
        };
        this.doConfigure(action, repository);
    }

    private final void doConfigure(ParseAction action, LoggerRepository repository) throws FactoryConfigurationError {
        DocumentBuilderFactory dbf = null;
        this.repository = repository;
        try {
            LogLog.debug("System property is :" + OptionConverter.getSystemProperty("javax.xml.parsers.DocumentBuilderFactory", null));
            dbf = DocumentBuilderFactory.newInstance();
            LogLog.debug("Standard DocumentBuilderFactory search succeded.");
            LogLog.debug("DocumentBuilderFactory is: " + dbf.getClass().getName());
        }
        catch (FactoryConfigurationError fce) {
            Exception e = fce.getException();
            LogLog.debug("Could not instantiate a DocumentBuilderFactory.", e);
            throw fce;
        }
        try {
            dbf.setValidating(true);
            DocumentBuilder docBuilder = dbf.newDocumentBuilder();
            docBuilder.setErrorHandler(new SAXErrorHandler());
            docBuilder.setEntityResolver(new Log4jEntityResolver());
            Document doc = action.parse(docBuilder);
            this.parse(doc.getDocumentElement());
        }
        catch (Exception e) {
            LogLog.error("Could not parse " + action.toString() + ".", e);
        }
    }

    public static void configure(String filename) throws FactoryConfigurationError {
        new DOMConfigurator().doConfigure(filename, LogManager.getLoggerRepository());
    }

    protected void parse(Element element) {
        int loop;
        String confDebug;
        String rootElementName = element.getTagName();
        if (!rootElementName.equals("log4j:configuration")) {
            if (rootElementName.equals("configuration")) {
                LogLog.warn("The <configuration> element has been deprecated.");
                LogLog.warn("Use the <log4j:configuration> element instead.");
            } else {
                LogLog.error("DOM element is - not a <log4j:configuration> element.");
                return;
            }
        }
        String debugAttrib = this.subst(element.getAttribute("debug"));
        LogLog.debug("debug attribute= \"" + debugAttrib + "\".");
        if (!debugAttrib.equals("") && !debugAttrib.equals("null")) {
            LogLog.setInternalDebugging(OptionConverter.toBoolean(debugAttrib, true));
        } else {
            LogLog.debug("Ignoring debug attribute.");
        }
        String resetAttrib = this.subst(element.getAttribute("reset"));
        LogLog.debug("reset attribute= \"" + resetAttrib + "\".");
        if (!"".equals(resetAttrib) && OptionConverter.toBoolean(resetAttrib, false)) {
            this.repository.resetConfiguration();
        }
        if (!(confDebug = this.subst(element.getAttribute("configDebug"))).equals("") && !confDebug.equals("null")) {
            LogLog.warn("The \"configDebug\" attribute is deprecated.");
            LogLog.warn("Use the \"debug\" attribute instead.");
            LogLog.setInternalDebugging(OptionConverter.toBoolean(confDebug, true));
        }
        String thresholdStr = this.subst(element.getAttribute("threshold"));
        LogLog.debug("Threshold =\"" + thresholdStr + "\".");
        if (!"".equals(thresholdStr) && !"null".equals(thresholdStr)) {
            this.repository.setThreshold(thresholdStr);
        }
        String tagName = null;
        Element currentElement = null;
        Node currentNode = null;
        NodeList children = element.getChildNodes();
        int length = children.getLength();
        for (loop = 0; loop < length; ++loop) {
            currentNode = children.item(loop);
            if (currentNode.getNodeType() != 1 || !(tagName = (currentElement = (Element)currentNode).getTagName()).equals("categoryFactory") && !tagName.equals("loggerFactory")) continue;
            this.parseCategoryFactory(currentElement);
        }
        for (loop = 0; loop < length; ++loop) {
            currentNode = children.item(loop);
            if (currentNode.getNodeType() != 1) continue;
            currentElement = (Element)currentNode;
            tagName = currentElement.getTagName();
            if (tagName.equals("category") || tagName.equals("logger")) {
                this.parseCategory(currentElement);
                continue;
            }
            if (tagName.equals("root")) {
                this.parseRoot(currentElement);
                continue;
            }
            if (tagName.equals("renderer")) {
                this.parseRenderer(currentElement);
                continue;
            }
            if (tagName.equals("appender") || tagName.equals("categoryFactory") || tagName.equals("loggerFactory")) continue;
            DOMConfigurator.quietParseUnrecognizedElement(this.repository, currentElement, this.props);
        }
    }

    protected String subst(String value) {
        return DOMConfigurator.subst(value, this.props);
    }

    public static String subst(String value, Properties props) {
        try {
            return OptionConverter.substVars(value, props);
        }
        catch (IllegalArgumentException e) {
            LogLog.warn("Could not perform variable substitution.", e);
            return value;
        }
    }

    public static void setParameter(Element elem, PropertySetter propSetter, Properties props) {
        String name = DOMConfigurator.subst(elem.getAttribute("name"), props);
        String value = elem.getAttribute("value");
        value = DOMConfigurator.subst(OptionConverter.convertSpecialChars(value), props);
        propSetter.setProperty(name, value);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static interface ParseAction {
        public Document parse(DocumentBuilder var1) throws SAXException, IOException;
    }
}

