/*
 * Decompiled with CFR 0.152.
 */
package mobac.utilities.tar;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import mobac.utilities.tar.TarArchive;
import mobac.utilities.tar.TarHeader;
import mobac.utilities.tar.TarIndex;
import mobac.utilities.tar.TarIndexTable;

public class TarIndexedArchive
extends TarArchive {
    private TarIndexTable tarIndex;

    public TarIndexedArchive(File tarFile, int approxFileCount) throws IOException {
        super(tarFile, null);
        this.tarIndex = new TarIndexTable(approxFileCount);
    }

    protected void writeTarHeader(TarHeader th) throws IOException {
        long streamPos = this.getTarFilePos();
        this.tarIndex.addTarEntry(th.getFileName(), streamPos);
        super.writeTarHeader(th);
    }

    public void delete() {
        boolean b;
        if (this.tarFile != null && !(b = this.tarFile.delete()) && this.tarFile.isFile()) {
            this.tarFile.deleteOnExit();
        }
    }

    public TarIndex getTarIndex() {
        try {
            return new TarIndex(this.tarFile, this.tarIndex);
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }
}

