/*
 * Decompiled with CFR 0.152.
 */
package mobac.utilities.stream;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import mobac.utilities.stream.ThrottleSupport;

public class ThrottledInputStream
extends FilterInputStream {
    private static ThrottleSupport ts = new ThrottleSupport();
    private int unused = 0;

    public ThrottledInputStream(InputStream in) {
        super(in);
    }

    public static void setBandwidth(long newValue) {
        ts.setBandwidth(newValue);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int allowedlen = ts.allocate(len);
        if (allowedlen < len) {
            allowedlen = Math.min(allowedlen + this.unused, len);
        }
        int read = this.in.read(b, off, allowedlen);
        this.unused = len - read;
        return read;
    }
}

