/*
 * Decompiled with CFR 0.152.
 */
package mobac.utilities.stream;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class CountingOutputStream
extends FilterOutputStream {
    private long bytesWritten = 0L;

    public CountingOutputStream(OutputStream out) {
        super(out);
    }

    public void write(int b) throws IOException {
        this.out.write(b);
        ++this.bytesWritten;
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
        this.bytesWritten += (long)len;
    }

    public void write(byte[] b) throws IOException {
        this.out.write(b);
        this.bytesWritten += (long)b.length;
    }

    public long getBytesWritten() {
        return this.bytesWritten;
    }
}

