/*
 * Decompiled with CFR 0.152.
 */
package mobac.utilities.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import javax.swing.JOptionPane;
import mobac.utilities.I18nUtils;
import org.apache.log4j.Logger;

public class SQLiteLoader {
    private static final Logger log = Logger.getLogger(SQLiteLoader.class);
    private static boolean SQLITE_LOADED = false;

    public static boolean loadSQLiteOrShowError() {
        try {
            SQLiteLoader.loadSQLite();
            return true;
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, SQLiteLoader.getMsgSqliteMissing(), I18nUtils.localizedStringForKey("msg_environment_slqite_lib_missing_title", new Object[0]), 0);
            return false;
        }
    }

    public static String getMsgSqliteMissing() {
        return I18nUtils.localizedStringForKey("msg_environment_slqite_lib_missing", new Object[0]);
    }

    public static synchronized void loadSQLite() throws SQLException {
        try {
            SQLiteLoader.loadSQLite("SQLite.JDBCDriver");
        }
        catch (Exception exception) {
            // empty catch block
        }
        SQLiteLoader.loadSQLite("org.sqlite.JDBC");
    }

    protected static synchronized void loadSQLite(String driverClassName) throws SQLException {
        if (SQLITE_LOADED) {
            return;
        }
        try {
            Class.forName(driverClassName);
            SQLITE_LOADED = true;
            log.debug("SQLite library loaded. Driver class name: " + driverClassName);
            return;
        }
        catch (Throwable t) {
            SQLException e = new SQLException("Loading of SQLite library failed (" + driverClassName + "): " + t.getMessage(), t);
            log.error(e.getMessage());
            throw e;
        }
    }

    public static void closeConnection(Connection conn) {
        if (conn == null) {
            return;
        }
        try {
            conn.close();
        }
        catch (Exception e) {
            log.error("Failed to close SQL connection: " + e.getMessage());
        }
    }
}

