/*
 * Decompiled with CFR 0.152.
 */
package mobac.utilities.geo;

import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import org.apache.log4j.Logger;

public class CoordinateDms2Format
extends NumberFormat {
    protected static Logger log = Logger.getLogger(CoordinateDms2Format.class);
    NumberFormat degFmt;
    NumberFormat minFmt;
    NumberFormat secFmt;
    NumberFormat secFmtParser;

    public CoordinateDms2Format(DecimalFormatSymbols dfs) {
        this.degFmt = new DecimalFormat("00\u00b0", dfs);
        this.minFmt = new DecimalFormat("00''", dfs);
        this.minFmt.setRoundingMode(RoundingMode.FLOOR);
        this.secFmt = new DecimalFormat("00.00\"", dfs);
        this.secFmt.setRoundingMode(RoundingMode.FLOOR);
        this.secFmtParser = new DecimalFormat("##.##", dfs);
    }

    public StringBuffer format(double numberOrg, StringBuffer toAppendTo, FieldPosition pos) {
        double number = numberOrg;
        int degrees = number >= 0.0 ? (int)Math.floor(number) : (int)Math.ceil(number);
        number = Math.abs((number - (double)degrees) * 60.0);
        int minutes = (int)Math.floor(number);
        double seconds = (number - (double)minutes) * 60.0;
        if (numberOrg < 0.0 && degrees == 0) {
            toAppendTo.append("-");
        }
        toAppendTo.append(this.degFmt.format(degrees) + " ");
        toAppendTo.append(this.minFmt.format(minutes) + " ");
        toAppendTo.append(this.secFmt.format(seconds));
        return toAppendTo;
    }

    public StringBuffer format(long number, StringBuffer toAppendTo, FieldPosition pos) {
        throw new RuntimeException("Not implemented");
    }

    public Number parse(String source) throws ParseException {
        return this.parse(source, new ParsePosition(0));
    }

    public Number parse(String source, ParsePosition parsePosition) {
        String[] tokens = source.trim().split("[\u00b0\\'\\\"]");
        if (tokens.length != 3) {
            return null;
        }
        try {
            String degStr = tokens[0].trim();
            int deg = Integer.parseInt(degStr);
            int min = Integer.parseInt(tokens[1].trim());
            double sec = this.secFmtParser.parse(tokens[2].trim()).doubleValue();
            double coord = degStr.startsWith("-") ? (double)deg - sec / 3600.0 - (double)min / 60.0 : (double)deg + sec / 3600.0 + (double)min / 60.0;
            return new Double(coord);
        }
        catch (Exception e) {
            parsePosition.setErrorIndex(0);
            log.error("e");
            return null;
        }
    }
}

