/*
 * Decompiled with CFR 0.152.
 */
package mobac.utilities.collections;

import java.lang.ref.SoftReference;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SoftHashMap<K, V>
implements Map<K, V> {
    HashMap<K, SoftReference<V>> map;

    public SoftHashMap(int initialCapacity) {
        this.map = new HashMap(initialCapacity);
    }

    @Override
    public V get(Object key) {
        SoftReference<V> ref = this.map.get(key);
        return ref != null ? (V)ref.get() : null;
    }

    @Override
    public V put(K key, V value) {
        SoftReference<V> ref = this.map.put(key, new SoftReference<V>(value));
        return ref != null ? (V)ref.get() : null;
    }

    @Override
    public V remove(Object key) {
        SoftReference<V> ref = this.map.remove(key);
        return ref != null ? (V)ref.get() : null;
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Set<K> keySet() {
        return this.map.keySet();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public Collection<V> values() {
        throw new RuntimeException("Not implemented");
    }
}

