/*
 * Decompiled with CFR 0.152.
 */
package mobac.utilities;

import java.text.MessageFormat;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class Juli2Log4jHandler
extends Handler {
    public void publish(LogRecord record) {
        Logger log4j = Juli2Log4jHandler.getTargetLogger(record.getSourceClassName());
        Level priority = this.toLog4j(record.getLevel());
        log4j.log(priority, this.toLog4jMessage(record), record.getThrown());
    }

    static Logger getTargetLogger(String loggerName) {
        return Logger.getLogger(loggerName);
    }

    private String toLog4jMessage(LogRecord record) {
        String message = record.getMessage();
        try {
            Object[] parameters = record.getParameters();
            if (parameters != null && parameters.length != 0 && (message.indexOf("{0}") >= 0 || message.indexOf("{1}") >= 0 || message.indexOf("{2}") >= 0 || message.indexOf("{3}") >= 0)) {
                message = MessageFormat.format(message, parameters);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return message;
    }

    private Level toLog4j(java.util.logging.Level level) {
        if (java.util.logging.Level.SEVERE == level) {
            return Level.ERROR;
        }
        if (java.util.logging.Level.WARNING == level) {
            return Level.WARN;
        }
        if (java.util.logging.Level.INFO == level) {
            return Level.INFO;
        }
        if (java.util.logging.Level.OFF == level) {
            return Level.OFF;
        }
        return Level.OFF;
    }

    public void flush() {
    }

    public void close() {
    }
}

