/*
 * Decompiled with CFR 0.152.
 */
package mobac.utilities;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import mobac.Main;
import mobac.program.model.Settings;
import mobac.utilities.Charsets;

public class I18nUtils {
    private static ResourceBundle STRING_RESOURCE = null;

    public static String localizedStringForKey(String key, Object ... args) {
        if (STRING_RESOURCE == null) {
            I18nUtils.updateLocalizedStringFormSettings();
        }
        String str = null;
        try {
            str = STRING_RESOURCE.getString(key);
            if (args.length > 0) {
                str = String.format(str, args);
            }
        }
        catch (Exception e) {
            str = key;
        }
        if (str == null) {
            str = "";
        }
        return str;
    }

    public static synchronized void updateLocalizedStringFormSettings() {
        Settings settings = Settings.getInstance();
        Locale locale = null;
        locale = settings != null ? new Locale(settings.localeLanguage, settings.localeCountry) : Locale.getDefault();
        STRING_RESOURCE = ResourceBundle.getBundle("mobac.resources.text.localize", locale, new UTF8Control());
    }

    public static InputStream getI18nResourceAsStream(String name, String extension) {
        Settings s = Settings.getInstance();
        String country = s.localeCountry;
        String language = s.localeLanguage;
        InputStream in = Main.class.getResourceAsStream(String.format("%s_%s_%s.%s", name, language, country, extension));
        if (in != null) {
            return in;
        }
        in = Main.class.getResourceAsStream(String.format("%s_%s.%s", name, language, extension));
        if (in != null) {
            return in;
        }
        in = Main.class.getResourceAsStream(String.format("%s.%s", name, extension));
        return in;
    }

    public static class UTF8Control
    extends ResourceBundle.Control {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ResourceBundle newBundle(String baseName, Locale locale, String format, ClassLoader loader, boolean reload) throws IllegalAccessException, InstantiationException, IOException {
            String bundleName = this.toBundleName(baseName, locale);
            String resourceName = this.toResourceName(bundleName, "properties");
            PropertyResourceBundle bundle = null;
            InputStream stream = null;
            if (reload) {
                URLConnection connection;
                URL url = loader.getResource(resourceName);
                if (url != null && (connection = url.openConnection()) != null) {
                    connection.setUseCaches(false);
                    stream = connection.getInputStream();
                }
            } else {
                stream = loader.getResourceAsStream(resourceName);
            }
            if (stream != null) {
                try {
                    bundle = new PropertyResourceBundle(new InputStreamReader(stream, Charsets.UTF_8));
                }
                finally {
                    stream.close();
                }
            }
            return bundle;
        }
    }
}

