/*
 * Decompiled with CFR 0.152.
 */
package mobac.program.tilestore.berkeleydb;

import java.util.concurrent.ThreadFactory;

public class DelayedInterruptThread
extends Thread {
    private boolean interruptPaused = false;
    private boolean interruptedWhilePaused = false;

    public DelayedInterruptThread(String name) {
        super(name);
    }

    public DelayedInterruptThread(Runnable target) {
        super(target);
    }

    public DelayedInterruptThread(Runnable target, String name) {
        super(target, name);
    }

    public void interrupt() {
        if (this.interruptPaused) {
            this.interruptedWhilePaused = true;
        } else {
            super.interrupt();
        }
    }

    public void pauseInterrupt() {
        this.interruptPaused = true;
    }

    public void resumeInterrupt() {
        this.interruptPaused = false;
        if (this.interruptedWhilePaused) {
            this.interrupt();
        }
    }

    public boolean interruptedWhilePaused() {
        return this.interruptedWhilePaused;
    }

    public static ThreadFactory createThreadFactory() {
        return new DIThreadFactory();
    }

    private static class DIThreadFactory
    implements ThreadFactory {
        private DIThreadFactory() {
        }

        public Thread newThread(Runnable r) {
            return new DelayedInterruptThread(r);
        }
    }
}

