/*
 * Decompiled with CFR 0.152.
 */
package mobac.program.tilestore.berkeleydb;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.EnvironmentLockedException;
import com.sleepycat.persist.EntityCursor;
import com.sleepycat.persist.EntityStore;
import com.sleepycat.persist.PrimaryIndex;
import com.sleepycat.persist.StoreConfig;
import com.sleepycat.persist.evolve.Mutations;
import com.sleepycat.persist.evolve.Renamer;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import mobac.exceptions.TileStoreException;
import mobac.program.interfaces.MapSource;
import mobac.program.model.Settings;
import mobac.program.tilestore.TileStore;
import mobac.program.tilestore.TileStoreEntry;
import mobac.program.tilestore.TileStoreInfo;
import mobac.program.tilestore.berkeleydb.DelayedInterruptThread;
import mobac.program.tilestore.berkeleydb.TileDbEntry;
import mobac.utilities.GUIExceptionHandler;
import mobac.utilities.Utilities;
import mobac.utilities.file.DeleteFileFilter;
import mobac.utilities.file.DirInfoFileFilter;
import mobac.utilities.file.DirectoryFileFilter;

public class BerkeleyDbTileStore
extends TileStore {
    private static final int MAX_CONCURRENT_ENVIRONMENTS = 5;
    private EnvironmentConfig envConfig;
    private Map<String, TileDatabase> tileDbMap;
    private FileLock tileStoreLock = null;
    private Mutations mutations;

    public BerkeleyDbTileStore() throws TileStoreException {
        this.acquireTileStoreLock();
        this.tileDbMap = new TreeMap<String, TileDatabase>();
        this.envConfig = new EnvironmentConfig();
        this.envConfig.setTransactional(false);
        this.envConfig.setLocking(true);
        this.envConfig.setExceptionListener(GUIExceptionHandler.getInstance());
        this.envConfig.setAllowCreate(true);
        this.envConfig.setSharedCache(true);
        this.envConfig.setCachePercent(50);
        this.mutations = new Mutations();
        String oldPackage1 = "tac.tilestore.berkeleydb";
        String oldPackage2 = "tac.program.tilestore.berkeleydb";
        String entry = ".TileDbEntry";
        String key = ".TileDbEntry$TileDbKey";
        this.mutations.addRenamer(new Renamer(oldPackage1 + entry, 0, TileDbEntry.class.getName()));
        this.mutations.addRenamer(new Renamer(oldPackage1 + key, 0, TileDbEntry.TileDbKey.class.getName()));
        this.mutations.addRenamer(new Renamer(oldPackage1 + entry, 1, TileDbEntry.class.getName()));
        this.mutations.addRenamer(new Renamer(oldPackage1 + key, 1, TileDbEntry.TileDbKey.class.getName()));
        this.mutations.addRenamer(new Renamer(oldPackage2 + entry, 2, TileDbEntry.class.getName()));
        this.mutations.addRenamer(new Renamer(oldPackage2 + key, 2, TileDbEntry.TileDbKey.class.getName()));
        Runtime.getRuntime().addShutdownHook(new ShutdownThread(true));
    }

    protected void acquireTileStoreLock() throws TileStoreException {
        try {
            File file = new File(this.tileStoreDir, "lock");
            if (!this.tileStoreDir.isDirectory()) {
                try {
                    Utilities.mkDirs(this.tileStoreDir);
                }
                catch (IOException e) {
                    throw new TileStoreException("Unable to create tile store directory: \"" + this.tileStoreDir.getPath() + "\"");
                }
            }
            FileChannel channel = new RandomAccessFile(file, "rw").getChannel();
            this.tileStoreLock = channel.tryLock();
            if (this.tileStoreLock == null) {
                throw new TileStoreException("Unable to obtain tile store lock - another instance of Mobile Atlas Creator is running!");
            }
        }
        catch (Exception e) {
            this.log.error("", e);
            throw new TileStoreException(e.getMessage(), e.getCause());
        }
    }

    public TileStoreEntry createNewEntry(int x, int y, int zoom, byte[] data, long timeLastModified, long timeExpires, String eTag) {
        return new TileDbEntry(x, y, zoom, data, timeLastModified, timeExpires, eTag);
    }

    public TileStoreEntry createNewEmptyEntry(int x, int y, int zoom) {
        long time = System.currentTimeMillis();
        long timeExpires = time + Settings.getInstance().tileDefaultExpirationTime;
        return new TileDbEntry(x, y, zoom, new byte[0], time, timeExpires, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TileDatabase getTileDatabase(MapSource mapSource) throws DatabaseException {
        TileDatabase db;
        if (this.tileDbMap == null) {
            return null;
        }
        String storeName = mapSource.getName();
        if (storeName == null) {
            return null;
        }
        Map<String, TileDatabase> map = this.tileDbMap;
        synchronized (map) {
            db = this.tileDbMap.get(storeName);
        }
        if (db != null) {
            return db;
        }
        try {
            map = this.tileDbMap;
            synchronized (map) {
                this.cleanupDatabases();
                db = this.tileDbMap.get(storeName);
                if (db == null) {
                    db = new TileDatabase(storeName);
                    db.lastAccess = System.currentTimeMillis();
                    this.tileDbMap.put(mapSource.getName(), db);
                }
                return db;
            }
        }
        catch (Exception e) {
            this.log.error("Error creating tile store db \"" + mapSource.getName() + "\"", e);
            throw new TileStoreException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TileDatabase getTileDatabase(String storeName) throws DatabaseException {
        TileDatabase db;
        if (this.tileDbMap == null) {
            return null;
        }
        if (storeName == null) {
            return null;
        }
        Map<String, TileDatabase> map = this.tileDbMap;
        synchronized (map) {
            db = this.tileDbMap.get(storeName);
        }
        if (db != null) {
            return db;
        }
        try {
            map = this.tileDbMap;
            synchronized (map) {
                this.cleanupDatabases();
                db = this.tileDbMap.get(storeName);
                if (db == null) {
                    db = new TileDatabase(storeName);
                    db.lastAccess = System.currentTimeMillis();
                    this.tileDbMap.put(storeName, db);
                }
                return db;
            }
        }
        catch (Exception e) {
            this.log.error("Error creating tile store db \"" + storeName + "\"", e);
            throw new TileStoreException(e);
        }
    }

    public TileStoreInfo getStoreInfo(String storeName) throws InterruptedException {
        int tileCount = this.getNrOfTiles(storeName);
        long storeSize = this.getStoreSize(storeName);
        return new TileStoreInfo(storeSize, tileCount);
    }

    public void putTileData(byte[] tileData, int x, int y, int zoom, MapSource mapSource) throws IOException {
        this.putTileData(tileData, x, y, zoom, mapSource, -1L, -1L, null);
    }

    public void putTileData(byte[] tileData, int x, int y, int zoom, MapSource mapSource, long timeLastModified, long timeExpires, String eTag) throws IOException {
        TileDbEntry tile = new TileDbEntry(x, y, zoom, tileData, timeLastModified, timeExpires, eTag);
        TileDatabase db = null;
        try {
            if (this.log.isTraceEnabled()) {
                this.log.trace("Saved " + mapSource.getName() + " " + tile);
            }
            if ((db = this.getTileDatabase(mapSource)) != null) {
                db.put(tile);
            }
        }
        catch (Exception e) {
            if (db != null) {
                db.close();
            }
            this.log.error("Faild to write tile to tile store \"" + mapSource.getName() + "\"", e);
        }
    }

    public void putTile(TileStoreEntry tile, MapSource mapSource) {
        TileDatabase db = null;
        try {
            if (this.log.isTraceEnabled()) {
                this.log.trace("Saved " + mapSource.getName() + " " + tile);
            }
            db = this.getTileDatabase(mapSource);
            db.put((TileDbEntry)tile);
        }
        catch (Exception e) {
            if (db != null) {
                db.close();
            }
            this.log.error("Faild to write tile to tile store \"" + mapSource.getName() + "\"", e);
        }
    }

    public TileStoreEntry getTile(int x, int y, int zoom, MapSource mapSource) {
        TileDatabase db = null;
        try {
            db = this.getTileDatabase(mapSource);
            if (db == null) {
                return null;
            }
            TileDbEntry tile = db.get(new TileDbEntry.TileDbKey(x, y, zoom));
            if (this.log.isTraceEnabled()) {
                if (tile == null) {
                    this.log.trace("Tile store cache miss: (x,y,z)" + x + "/" + y + "/" + zoom + " " + mapSource.getName());
                } else {
                    this.log.trace("Loaded " + mapSource.getName() + " " + tile);
                }
            }
            return tile;
        }
        catch (Exception e) {
            if (db != null) {
                db.close();
            }
            this.log.error("failed to retrieve tile from tile store \"" + mapSource.getName() + "\"", e);
            return null;
        }
    }

    public boolean contains(int x, int y, int zoom, MapSource mapSource) {
        try {
            return this.getTileDatabase(mapSource).contains(new TileDbEntry.TileDbKey(x, y, zoom));
        }
        catch (DatabaseException e) {
            this.log.error("", e);
            return false;
        }
    }

    public void prepareTileStore(MapSource mapSource) {
        try {
            this.getTileDatabase(mapSource);
        }
        catch (DatabaseException databaseException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearStore(String storeName) {
        File databaseDir = this.getStoreDir(storeName);
        Map<String, TileDatabase> map = this.tileDbMap;
        synchronized (map) {
            TileDatabase db = this.tileDbMap.get(storeName);
            if (db != null) {
                db.close(false);
            }
            if (databaseDir.exists()) {
                DeleteFileFilter dff = new DeleteFileFilter();
                databaseDir.listFiles(dff);
                databaseDir.delete();
                this.log.debug("Tilestore " + storeName + " cleared: " + dff);
            }
            this.tileDbMap.remove(storeName);
        }
    }

    public int getNrOfTiles(String mapSourceName) throws InterruptedException {
        try {
            File storeDir = this.getStoreDir(mapSourceName);
            if (!storeDir.isDirectory()) {
                return 0;
            }
            TileDatabase db = this.getTileDatabase(mapSourceName);
            int tileCount = (int)db.entryCount();
            db.close();
            return tileCount;
        }
        catch (DatabaseException e) {
            this.log.error("", e);
            return -1;
        }
    }

    public long getStoreSize(String storeName) throws InterruptedException {
        File tileStore = this.getStoreDir(storeName);
        if (tileStore.exists()) {
            DirInfoFileFilter diff = new DirInfoFileFilter();
            try {
                tileStore.listFiles(diff);
            }
            catch (RuntimeException e) {
                throw new InterruptedException();
            }
            return diff.getDirSize();
        }
        return 0L;
    }

    public BufferedImage getCacheCoverage(MapSource mapSource, int zoom, Point tileNumMin, Point tileNumMax) throws InterruptedException {
        try {
            TileDatabase db = this.getTileDatabase(mapSource);
            return db.getCacheCoverage(zoom, tileNumMin, tileNumMax);
        }
        catch (DatabaseException e) {
            this.log.error("", e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanupDatabases() {
        if (this.tileDbMap.size() < 5) {
            return;
        }
        Map<String, TileDatabase> map = this.tileDbMap;
        synchronized (map) {
            ArrayList<TileDatabase> list = new ArrayList<TileDatabase>(this.tileDbMap.values());
            Collections.sort(list, new Comparator<TileDatabase>(){

                @Override
                public int compare(TileDatabase o1, TileDatabase o2) {
                    if (o1.lastAccess == o2.lastAccess) {
                        return 0;
                    }
                    return o1.lastAccess < o2.lastAccess ? -1 : 1;
                }
            });
            for (int i = 0; i < list.size() - 2; ++i) {
                ((TileDatabase)list.get(i)).close();
            }
        }
    }

    public void closeAll() {
        ShutdownThread t = new ShutdownThread(false);
        t.start();
        try {
            t.join();
        }
        catch (InterruptedException e) {
            this.log.error("", e);
        }
    }

    public boolean storeExists(MapSource mapSource) {
        File tileStore = this.getStoreDir(mapSource);
        return tileStore.isDirectory() && tileStore.exists();
    }

    protected File getStoreDir(MapSource mapSource) {
        return this.getStoreDir(mapSource.getName());
    }

    protected File getStoreDir(String mapSourceName) {
        return new File(this.tileStoreDir, "db-" + mapSourceName);
    }

    public String[] getAllStoreNames() {
        File[] dirs = this.tileStoreDir.listFiles(new DirectoryFileFilter());
        ArrayList<String> storeNames = new ArrayList<String>(dirs.length);
        for (File d : dirs) {
            String name = d.getName();
            if (!name.startsWith("db-")) continue;
            name = name.substring(3);
            storeNames.add(name);
        }
        String[] result = new String[storeNames.size()];
        storeNames.toArray(result);
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class TileDatabase {
        final String mapSourceName;
        final Environment env;
        final EntityStore store;
        final PrimaryIndex<TileDbEntry.TileDbKey, TileDbEntry> tileIndex;
        boolean dbClosed = false;
        long lastAccess;

        public TileDatabase(String mapSourceName) throws IOException, EnvironmentLockedException, DatabaseException {
            this(mapSourceName, berkeleyDbTileStore.getStoreDir(mapSourceName));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public TileDatabase(String mapSourceName, File databaseDirectory) throws IOException, EnvironmentLockedException, DatabaseException {
            BerkeleyDbTileStore.this.log.debug("Opening tile store db: \"" + databaseDirectory + "\"");
            File storeDir = databaseDirectory;
            DelayedInterruptThread t = (DelayedInterruptThread)Thread.currentThread();
            try {
                t.pauseInterrupt();
                this.mapSourceName = mapSourceName;
                this.lastAccess = System.currentTimeMillis();
                Utilities.mkDirs(storeDir);
                this.env = new Environment(storeDir, BerkeleyDbTileStore.this.envConfig);
                StoreConfig storeConfig = new StoreConfig();
                storeConfig.setAllowCreate(true);
                storeConfig.setTransactional(false);
                storeConfig.setMutations(BerkeleyDbTileStore.this.mutations);
                this.store = new EntityStore(this.env, "TilesEntityStore", storeConfig);
                this.tileIndex = this.store.getPrimaryIndex(TileDbEntry.TileDbKey.class, TileDbEntry.class);
            }
            finally {
                if (t.interruptedWhilePaused()) {
                    this.close();
                }
                t.resumeInterrupt();
            }
        }

        public boolean isClosed() {
            return this.dbClosed;
        }

        public long entryCount() throws DatabaseException {
            return this.tileIndex.count();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void put(TileDbEntry tile) throws DatabaseException {
            DelayedInterruptThread t = (DelayedInterruptThread)Thread.currentThread();
            try {
                t.pauseInterrupt();
                this.tileIndex.put(tile);
            }
            finally {
                if (t.interruptedWhilePaused()) {
                    this.close();
                }
                t.resumeInterrupt();
            }
        }

        public boolean contains(TileDbEntry.TileDbKey key) throws DatabaseException {
            return this.tileIndex.contains(key);
        }

        public TileDbEntry get(TileDbEntry.TileDbKey key) throws DatabaseException {
            return this.tileIndex.get(key);
        }

        public PrimaryIndex<TileDbEntry.TileDbKey, TileDbEntry> getTileIndex() {
            return this.tileIndex;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public BufferedImage getCacheCoverage(int zoom, Point tileNumMin, Point tileNumMax) throws DatabaseException, InterruptedException {
            BerkeleyDbTileStore.this.log.debug("Loading cache coverage for region " + tileNumMin + " " + tileNumMax + " of zoom level " + zoom);
            DelayedInterruptThread t = (DelayedInterruptThread)Thread.currentThread();
            int width = tileNumMax.x - tileNumMin.x + 1;
            int height = tileNumMax.y - tileNumMin.y + 1;
            byte ff = -1;
            byte[] colors = new byte[]{120, 120, 120, 120, 10, ff, 0, 120};
            IndexColorModel colorModel = new IndexColorModel(2, 2, colors, 0, true);
            BufferedImage image = null;
            try {
                image = new BufferedImage(width, height, 13, colorModel);
            }
            catch (Throwable e) {
                BerkeleyDbTileStore.this.log.error("Failed to create coverage image: " + e.toString());
                image = null;
                System.gc();
                return null;
            }
            WritableRaster raster = image.getRaster();
            for (int x = tileNumMin.x; x <= tileNumMax.x; ++x) {
                TileDbEntry.TileDbKey fromKey = new TileDbEntry.TileDbKey(x, tileNumMin.y, zoom);
                TileDbEntry.TileDbKey toKey = new TileDbEntry.TileDbKey(x, tileNumMax.y, zoom);
                EntityCursor<TileDbEntry.TileDbKey> cursor = this.tileIndex.keys(fromKey, true, toKey, true);
                try {
                    TileDbEntry.TileDbKey key = cursor.next();
                    while (key != null) {
                        int pixelx = key.x - tileNumMin.x;
                        int pixely = key.y - tileNumMin.y;
                        raster.setSample(pixelx, pixely, 0, 1);
                        key = cursor.next();
                        if (!t.isInterrupted()) continue;
                        BerkeleyDbTileStore.this.log.debug("Cache coverage loading aborted");
                        throw new InterruptedException();
                    }
                    continue;
                }
                finally {
                    cursor.close();
                }
            }
            return image;
        }

        protected void purge() {
            try {
                this.store.sync();
                this.env.cleanLog();
            }
            catch (DatabaseException e) {
                BerkeleyDbTileStore.this.log.error("database compression failed: ", e);
            }
        }

        public void close() {
            this.close(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close(boolean removeFromMap) {
            if (this.dbClosed) {
                return;
            }
            if (removeFromMap) {
                Map map = BerkeleyDbTileStore.this.tileDbMap;
                synchronized (map) {
                    TileDatabase db2 = (TileDatabase)BerkeleyDbTileStore.this.tileDbMap.get(this.mapSourceName);
                    if (db2 == this) {
                        BerkeleyDbTileStore.this.tileDbMap.remove(this.mapSourceName);
                    }
                }
            }
            DelayedInterruptThread t = (DelayedInterruptThread)Thread.currentThread();
            try {
                t.pauseInterrupt();
                try {
                    BerkeleyDbTileStore.this.log.debug("Closing tile store db \"" + this.mapSourceName + "\"");
                    if (this.store != null) {
                        this.store.close();
                    }
                }
                catch (Exception e) {
                    BerkeleyDbTileStore.this.log.error("", e);
                }
                try {
                    this.env.close();
                }
                catch (Exception e) {
                    BerkeleyDbTileStore.this.log.error("", e);
                }
                finally {
                    this.dbClosed = true;
                }
            }
            finally {
                if (t.interruptedWhilePaused()) {
                    this.close();
                }
                t.resumeInterrupt();
            }
        }

        protected void finalize() throws Throwable {
            this.close();
            super.finalize();
        }
    }

    private class ShutdownThread
    extends DelayedInterruptThread {
        private final boolean shutdown;

        public ShutdownThread(boolean shutdown) {
            super("DBShutdown");
            this.shutdown = shutdown;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            BerkeleyDbTileStore.this.log.debug("Closing all tile databases...");
            Map map = BerkeleyDbTileStore.this.tileDbMap;
            synchronized (map) {
                for (TileDatabase db : BerkeleyDbTileStore.this.tileDbMap.values()) {
                    db.close(false);
                }
                BerkeleyDbTileStore.this.tileDbMap.clear();
                if (this.shutdown) {
                    BerkeleyDbTileStore.this.tileDbMap = null;
                    try {
                        BerkeleyDbTileStore.this.tileStoreLock.release();
                    }
                    catch (IOException e) {
                        BerkeleyDbTileStore.this.log.error("", e);
                    }
                }
            }
            BerkeleyDbTileStore.this.log.debug("All tile databases has been closed");
        }
    }
}

