/*
 * Decompiled with CFR 0.152.
 */
package mobac.program.tilestore;

import java.awt.Point;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.swing.JOptionPane;
import mobac.exceptions.TileStoreException;
import mobac.program.DirectoryManager;
import mobac.program.interfaces.MapSource;
import mobac.program.model.Settings;
import mobac.program.tilestore.TileStoreEntry;
import mobac.program.tilestore.TileStoreInfo;
import mobac.program.tilestore.berkeleydb.BerkeleyDbTileStore;
import mobac.utilities.I18nUtils;
import org.apache.log4j.Logger;

public abstract class TileStore {
    protected static TileStore INSTANCE = null;
    protected Logger log = Logger.getLogger(this.getClass());
    protected File tileStoreDir;

    public static synchronized void initialize() {
        if (INSTANCE != null) {
            return;
        }
        try {
            INSTANCE = new BerkeleyDbTileStore();
        }
        catch (TileStoreException e) {
            String errMsg = I18nUtils.localizedStringForKey("msg_tile_store_access_conflict", new Object[0]);
            JOptionPane.showMessageDialog(null, errMsg, I18nUtils.localizedStringForKey("msg_tile_store_access_conflict_title", new Object[0]), 0);
            System.exit(1);
        }
    }

    public static TileStore getInstance() {
        return INSTANCE;
    }

    protected TileStore() {
        String tileStorePath = Settings.getInstance().directories.tileStoreDirectory;
        this.tileStoreDir = tileStorePath != null ? new File(tileStorePath) : DirectoryManager.tileStoreDir;
        this.log.debug("Tile store path: " + this.tileStoreDir);
    }

    public abstract void putTileData(byte[] var1, int var2, int var3, int var4, MapSource var5) throws IOException;

    public abstract void putTileData(byte[] var1, int var2, int var3, int var4, MapSource var5, long var6, long var8, String var10) throws IOException;

    public abstract TileStoreEntry getTile(int var1, int var2, int var3, MapSource var4);

    public abstract boolean contains(int var1, int var2, int var3, MapSource var4);

    public abstract void prepareTileStore(MapSource var1);

    public abstract void clearStore(String var1);

    public abstract String[] getAllStoreNames();

    public abstract boolean storeExists(MapSource var1);

    public abstract TileStoreInfo getStoreInfo(String var1) throws InterruptedException;

    public abstract BufferedImage getCacheCoverage(MapSource var1, int var2, Point var3, Point var4) throws InterruptedException;

    public abstract void closeAll();

    public abstract void putTile(TileStoreEntry var1, MapSource var2);

    public abstract TileStoreEntry createNewEntry(int var1, int var2, int var3, byte[] var4, long var5, long var7, String var9);

    public abstract TileStoreEntry createNewEmptyEntry(int var1, int var2, int var3);
}

