/*
 * Decompiled with CFR 0.152.
 */
package mobac.program.model;

import mobac.utilities.I18nUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum UnitSystem {
    Metric(6367.5, 1000, 2.54, "km", "m", "cm"),
    Imperial(3963.192, 5280, 1.0, "mi", "ft", "in");

    public static final double PPI = 72.0;
    public final double earthRadius;
    public final String unitLarge;
    public final String unitSmall;
    public final String unitTiny;
    public final int unitFactor;
    public final double inchFactor;
    public final double maxAngularDistSmall;

    public static double pointsToPixels(double points, int dpi) {
        return points / 72.0 * (double)dpi;
    }

    public static double pixelsToPoints(double pixels, int dpi) {
        return pixels / (double)dpi * 72.0;
    }

    private UnitSystem(double earthRadius, int unitFactor, double inchFactor, String unitLarge, String unitSmall, String unitTiny) {
        this.earthRadius = earthRadius;
        this.unitFactor = unitFactor;
        this.inchFactor = inchFactor;
        this.unitLarge = unitLarge;
        this.unitSmall = unitSmall;
        this.unitTiny = unitTiny;
        this.maxAngularDistSmall = 1.0 / (earthRadius * (double)unitFactor);
    }

    private double unitsToInches(double units) {
        return units / this.inchFactor;
    }

    private double inchesToUnits(double inches) {
        return inches * this.inchFactor;
    }

    public double unitsToPoints(double units) {
        return this.unitsToInches(units) * 72.0;
    }

    public double pointsToUnits(double points) {
        return this.inchesToUnits(points / 72.0);
    }

    public double unitsToPixels(double units, int dpi) {
        return this.unitsToInches(units) * (double)dpi;
    }

    public double pixelsToUnits(double pixels, int dpi) {
        return this.inchesToUnits(pixels / (double)dpi);
    }

    public String toString() {
        if (Metric.equals((Object)this)) {
            return I18nUtils.localizedStringForKey("set_display_unit_system_metric", new Object[0]);
        }
        return I18nUtils.localizedStringForKey("set_display_unit_system_imperial", new Object[0]);
    }
}

