/*
 * Decompiled with CFR 0.152.
 */
package mobac.program.model;

import com.itextpdf.text.PageSize;
import com.itextpdf.text.Rectangle;

public class PaperSize {
    public final double width;
    public final double height;
    public final boolean landscape;
    public final Format format;

    public PaperSize(Format format, boolean landscape) {
        if (landscape) {
            this.width = format.height;
            this.height = format.width;
        } else {
            this.width = format.width;
            this.height = format.height;
        }
        this.landscape = landscape;
        this.format = format;
    }

    public PaperSize(double width, double height) {
        this.width = width;
        this.height = height;
        this.format = null;
        this.landscape = width > height;
    }

    public Rectangle createRectangle() {
        return new Rectangle((float)this.width, (float)this.height);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Format {
        A0(PageSize.A0),
        A1(PageSize.A1),
        A2(PageSize.A2),
        A3(PageSize.A3),
        A4(PageSize.A4),
        A5(PageSize.A5),
        A6(PageSize.A6),
        A7(PageSize.A7),
        A8(PageSize.A8),
        A9(PageSize.A9),
        A10(PageSize.A10),
        ARCH_A(PageSize.ARCH_A),
        ARCH_B(PageSize.ARCH_B),
        ARCH_C(PageSize.ARCH_C),
        ARCH_D(PageSize.ARCH_D),
        ARCH_E(PageSize.ARCH_E),
        B0(PageSize.B0),
        B1(PageSize.B1),
        B2(PageSize.B2),
        B3(PageSize.B3),
        B4(PageSize.B4),
        B5(PageSize.B5),
        B6(PageSize.B6),
        B7(PageSize.B7),
        B8(PageSize.B8),
        B9(PageSize.B9),
        B10(PageSize.B10);

        public final float width;
        public final float height;

        private Format(Rectangle rectangle) {
            this.width = rectangle.getWidth();
            this.height = rectangle.getHeight();
        }
    }
}

