/*
 * Decompiled with CFR 0.152.
 */
package mobac.program.model;

import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.Area;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import mobac.program.Logging;
import mobac.program.interfaces.LayerInterface;
import mobac.program.interfaces.MapInterface;
import mobac.program.interfaces.MapSource;
import mobac.program.interfaces.MapSpace;
import mobac.program.interfaces.TileFilter;
import mobac.program.model.EastNorthCoordinate;
import mobac.program.model.Layer;
import mobac.program.model.Map;
import mobac.program.model.TileImageParameters;
import mobac.program.tilefilter.PolygonTileFilter;
import mobac.utilities.I18nUtils;
import mobac.utilities.MyMath;

@XmlRootElement
public class MapPolygon
extends Map {
    @XmlElement
    protected Polygon polygon;
    protected long calculatedTileCount = -1L;

    protected MapPolygon() {
    }

    public static MapPolygon createTrackEnclosure(Layer layer, String name, MapSource mapSource, int zoom, EastNorthCoordinate[] trackPoints, int pixelDistance, TileImageParameters parameters) {
        MapSpace mapSpace = mapSource.getMapSpace();
        Area area = new Area();
        for (int i = 1; i < trackPoints.length; ++i) {
            EastNorthCoordinate point1 = trackPoints[i - 1];
            EastNorthCoordinate point2 = trackPoints[i];
            int y1 = mapSpace.cLatToY(point1.lat, zoom);
            int y2 = mapSpace.cLatToY(point2.lat, zoom);
            int x1 = mapSpace.cLonToX(point1.lon, zoom);
            int x2 = mapSpace.cLonToX(point2.lon, zoom);
            Line2D.Double ln = new Line2D.Double(x1, y1, x2, y2);
            double indent = pixelDistance;
            double length = ln.getP1().distance(ln.getP2());
            double dx_li = (ln.getX2() - ln.getX1()) / length * indent;
            double dy_li = (ln.getY2() - ln.getY1()) / length * indent;
            double p1X = ln.getX1() - dx_li;
            double p1Y = ln.getY1() - dy_li;
            double lX1 = ln.getX1() - dy_li;
            double lY1 = ln.getY1() + dx_li;
            double lX2 = ln.getX2() - dy_li;
            double lY2 = ln.getY2() + dx_li;
            double p2X = ln.getX2() + dx_li;
            double p2Y = ln.getY2() + dy_li;
            double rX1_ = ln.getX1() + dy_li;
            double rY1 = ln.getY1() - dx_li;
            double rX2 = ln.getX2() + dy_li;
            double rY2 = ln.getY2() - dx_li;
            Path2D.Double p = new Path2D.Double();
            ((Path2D)p).moveTo(lX1, lY1);
            ((Path2D)p).lineTo(lX2, lY2);
            ((Path2D)p).lineTo(p2X, p2Y);
            ((Path2D)p).lineTo(rX2, rY2);
            ((Path2D)p).lineTo(rX1_, rY1);
            ((Path2D)p).lineTo(p1X, p1Y);
            ((Path2D)p).lineTo(lX1, lY1);
            area.add(new Area(p));
        }
        PathIterator pi = area.getPathIterator(null);
        ArrayList<Integer> xPoints = new ArrayList<Integer>(100);
        ArrayList<Integer> yPoints = new ArrayList<Integer>(100);
        double[] coords = new double[6];
        while (!pi.isDone()) {
            int type = pi.currentSegment(coords);
            switch (type) {
                case 0: 
                case 1: 
                case 4: {
                    xPoints.add((int)coords[0]);
                    yPoints.add((int)coords[1]);
                    break;
                }
                default: {
                    Logging.LOG.warn("Area to polygon conversion: unexpected segment type found: " + type + " " + Arrays.toString(coords));
                }
            }
            pi.next();
        }
        int[] xp = new int[xPoints.size()];
        int[] yp = new int[yPoints.size()];
        for (int i = 0; i < xp.length; ++i) {
            xp[i] = (Integer)xPoints.get(i);
            yp[i] = (Integer)yPoints.get(i);
        }
        Polygon polygon = new Polygon(xp, yp, xp.length);
        return new MapPolygon(layer, name, mapSource, zoom, polygon, parameters);
    }

    public static MapPolygon createFromMapPolygon(Layer layer, String name, int newZoom, MapPolygon map) {
        Polygon oldPolygon = map.getPolygon();
        int oldZoom = map.getZoom();
        MapSpace mapSpace = map.getMapSource().getMapSpace();
        int[] xPoints = new int[oldPolygon.npoints];
        int[] yPoints = new int[oldPolygon.npoints];
        Point p = new Point();
        for (int i = 0; i < xPoints.length; ++i) {
            p.x = oldPolygon.xpoints[i];
            p.y = oldPolygon.ypoints[i];
            Point nP = mapSpace.changeZoom(p, oldZoom, newZoom);
            xPoints[i] = nP.x;
            yPoints[i] = nP.y;
        }
        Polygon newPolygon = new Polygon(xPoints, yPoints, xPoints.length);
        return new MapPolygon(layer, name, map.getMapSource(), newZoom, newPolygon, map.getParameters());
    }

    public MapPolygon(Layer layer, String name, MapSource mapSource, int zoom, Polygon polygon, TileImageParameters parameters) {
        super(layer, name, mapSource, zoom, null, null, parameters);
        this.polygon = polygon;
        Rectangle bounds = polygon.getBounds();
        int mapSourceTileSize = mapSource.getMapSpace().getTileSize();
        int minx = MyMath.roundDownToNearest(bounds.x, mapSourceTileSize);
        int miny = MyMath.roundDownToNearest(bounds.y, mapSourceTileSize);
        int maxx = MyMath.roundUpToNearest(bounds.x + bounds.width, mapSourceTileSize) - 1;
        int maxy = MyMath.roundUpToNearest(bounds.y + bounds.height, mapSourceTileSize) - 1;
        this.minTileCoordinate = new Point(minx, miny);
        this.maxTileCoordinate = new Point(maxx, maxy);
        this.internalCalculateTilesToDownload();
    }

    public long calculateTilesToDownload() {
        if (this.calculatedTileCount < 0L) {
            this.internalCalculateTilesToDownload();
        }
        return this.calculatedTileCount;
    }

    protected void internalCalculateTilesToDownload() {
        int tileSize = this.mapSource.getMapSpace().getTileSize();
        double tileSizeD = tileSize;
        int xMin = this.minTileCoordinate.x;
        int xMax = this.maxTileCoordinate.x;
        int yMin = this.minTileCoordinate.y;
        int yMax = this.maxTileCoordinate.y;
        int count = 0;
        for (int x = xMin; x <= xMax; x += tileSize) {
            for (int y = yMin; y <= yMax; y += tileSize) {
                if (!this.polygon.intersects(x, y, tileSizeD, tileSizeD)) continue;
                ++count;
            }
        }
        this.calculatedTileCount = count;
    }

    public String getToolTip() {
        MapSpace mapSpace = this.mapSource.getMapSpace();
        EastNorthCoordinate tl = new EastNorthCoordinate(mapSpace, this.zoom, this.minTileCoordinate.x, this.minTileCoordinate.y);
        EastNorthCoordinate br = new EastNorthCoordinate(mapSpace, this.zoom, this.maxTileCoordinate.x, this.maxTileCoordinate.y);
        StringWriter sw = new StringWriter(1024);
        sw.write("<html>");
        sw.write(I18nUtils.localizedStringForKey("lp_atlas_info_polygon_map_title", new Object[0]));
        sw.write(String.format(I18nUtils.localizedStringForKey("lp_atlas_info_map_source_short", new Object[0]), this.mapSource.getName()));
        sw.write(String.format(I18nUtils.localizedStringForKey("lp_atlas_info_map_zoom_lv", new Object[0]), this.zoom));
        sw.write(String.format(I18nUtils.localizedStringForKey("lp_atlas_info_polygon_map_point", new Object[0]), this.polygon.npoints));
        sw.write(String.format(I18nUtils.localizedStringForKey("lp_atlas_info_map_area_start", new Object[0]), tl, this.minTileCoordinate.x, this.minTileCoordinate.y));
        sw.write(String.format(I18nUtils.localizedStringForKey("lp_atlas_info_map_area_end", new Object[0]), br, this.maxTileCoordinate.x, this.maxTileCoordinate.y));
        sw.write(String.format(I18nUtils.localizedStringForKey("lp_atlas_info_map_size", new Object[0]), this.maxTileCoordinate.x - this.minTileCoordinate.x + 1, this.maxTileCoordinate.y - this.minTileCoordinate.y + 1));
        if (this.parameters != null) {
            sw.write(String.format(I18nUtils.localizedStringForKey("lp_atlas_info_tile_size", new Object[0]), this.parameters.getWidth(), this.parameters.getHeight()));
            sw.write(String.format(I18nUtils.localizedStringForKey("lp_atlas_info_tile_format", new Object[0]), new Object[]{this.parameters.getFormat()}));
        } else {
            sw.write(I18nUtils.localizedStringForKey("lp_atlas_info_tile_format_origin", new Object[0]));
        }
        sw.write(String.format(I18nUtils.localizedStringForKey("lp_atlas_info_max_tile", new Object[0]), this.calculateTilesToDownload()));
        sw.write("</html>");
        return sw.toString();
    }

    public Polygon getPolygon() {
        return this.polygon;
    }

    public TileFilter getTileFilter() {
        return new PolygonTileFilter(this);
    }

    public MapInterface deepClone(LayerInterface newLayer) {
        MapPolygon map = (MapPolygon)super.deepClone(newLayer);
        map.polygon = new Polygon(this.polygon.xpoints, this.polygon.ypoints, this.polygon.npoints);
        return map;
    }
}

