/*
 * Decompiled with CFR 0.152.
 */
package mobac.program.model;

import java.awt.Dimension;
import java.awt.Point;
import java.io.StringWriter;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.tree.TreeNode;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import mobac.exceptions.InvalidNameException;
import mobac.program.interfaces.AtlasInterface;
import mobac.program.interfaces.CapabilityDeletable;
import mobac.program.interfaces.LayerInterface;
import mobac.program.interfaces.MapInterface;
import mobac.program.interfaces.MapSource;
import mobac.program.interfaces.MapSpace;
import mobac.program.interfaces.ToolTipProvider;
import mobac.program.model.Atlas;
import mobac.program.model.EastNorthCoordinate;
import mobac.program.model.Map;
import mobac.program.model.MapPolygon;
import mobac.program.model.TileImageParameters;
import mobac.utilities.I18nUtils;
import mobac.utilities.MyMath;
import mobac.utilities.Utilities;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlRootElement
public class Layer
implements TreeNode,
CapabilityDeletable,
LayerInterface,
ToolTipProvider {
    private static Logger log = Logger.getLogger(Layer.class);
    @XmlTransient
    private AtlasInterface atlasInterface;
    private String name;
    @XmlElements(value={@XmlElement(name="PolygonMap", type=MapPolygon.class), @XmlElement(name="Map", type=Map.class)})
    private LinkedList<MapInterface> maps = new LinkedList();

    protected Layer() {
    }

    public Layer(AtlasInterface atlasInterface, String name) throws InvalidNameException {
        this.atlasInterface = atlasInterface;
        this.setName(name);
    }

    public void addMapsAutocut(String mapNameBase, MapSource mapSource, EastNorthCoordinate minCoordinate, EastNorthCoordinate maxCoordinate, int zoom, TileImageParameters parameters, int maxMapSize) throws InvalidNameException {
        MapSpace mapSpace = mapSource.getMapSpace();
        this.addMapsAutocut(mapNameBase, mapSource, minCoordinate.toTileCoordinate(mapSpace, zoom), maxCoordinate.toTileCoordinate(mapSpace, zoom), zoom, parameters, maxMapSize, 0);
    }

    public void addMapsAutocut(String mapNameBase, MapSource mapSource, Point minTileCoordinate, Point maxTileCoordinate, int zoom, TileImageParameters parameters, int maxMapSize, int overlapTiles) throws InvalidNameException {
        log.trace("Adding new map(s): \"" + mapNameBase + "\" " + mapSource + " zoom=" + zoom + " min=" + minTileCoordinate.x + "/" + minTileCoordinate.y + " max=" + maxTileCoordinate.x + "/" + maxTileCoordinate.y);
        int tileSize = mapSource.getMapSpace().getTileSize();
        minTileCoordinate.x -= minTileCoordinate.x % tileSize;
        minTileCoordinate.y -= minTileCoordinate.y % tileSize;
        maxTileCoordinate.x += tileSize - 1 - maxTileCoordinate.x % tileSize;
        maxTileCoordinate.y += tileSize - 1 - maxTileCoordinate.y % tileSize;
        Dimension tileDimension = parameters == null ? new Dimension(tileSize, tileSize) : parameters.getDimension();
        Dimension maxMapDimension = new Dimension(maxMapSize, maxMapSize);
        maxMapDimension.width -= maxMapSize % tileDimension.width;
        maxMapDimension.height -= maxMapSize % tileDimension.height;
        int mapWidth = maxTileCoordinate.x - minTileCoordinate.x;
        int mapHeight = maxTileCoordinate.y - minTileCoordinate.y;
        if (mapWidth < maxMapDimension.width && mapHeight < maxMapDimension.height) {
            Map s = new Map(this, mapNameBase, mapSource, zoom, minTileCoordinate, maxTileCoordinate, parameters);
            this.maps.add(s);
            return;
        }
        Dimension nextMapStep = new Dimension(maxMapDimension.width - tileDimension.width * overlapTiles, maxMapDimension.height - tileDimension.height * overlapTiles);
        int maxXCounter = MyMath.divCeil(mapWidth, nextMapStep.width);
        int maxYCounter = MyMath.divCeil(mapHeight, nextMapStep.height);
        int maxMapCounter = maxXCounter * maxYCounter;
        int maxMapCountDigits = (int)Math.ceil(Math.log10(maxMapCounter));
        String mapNameFormat = "%s (%0" + maxMapCountDigits + "d)";
        int mapCounter = 0;
        for (int mapX = minTileCoordinate.x; mapX < maxTileCoordinate.x; mapX += nextMapStep.width) {
            for (int mapY = minTileCoordinate.y; mapY < maxTileCoordinate.y; mapY += nextMapStep.height) {
                int maxX = Math.min(mapX + maxMapDimension.width, maxTileCoordinate.x);
                int maxY = Math.min(mapY + maxMapDimension.height, maxTileCoordinate.y);
                Point min = new Point(mapX, mapY);
                Point max = new Point(maxX - 1, maxY - 1);
                String mapName = String.format(mapNameFormat, mapNameBase, mapCounter++);
                Map s = new Map(this, mapName, mapSource, zoom, min, max, parameters);
                this.maps.add(s);
            }
        }
    }

    @Override
    public void delete() {
        this.maps.clear();
        this.atlasInterface.deleteLayer(this);
    }

    @Override
    public AtlasInterface getAtlas() {
        return this.atlasInterface;
    }

    @Override
    public void addMap(MapInterface map) {
        this.maps.add(map);
        map.setLayer(this);
    }

    @Override
    public MapInterface getMap(int index) {
        return this.maps.get(index);
    }

    @Override
    public int getMapCount() {
        return this.maps.size();
    }

    @Override
    @XmlAttribute
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String newName) throws InvalidNameException {
        if (this.atlasInterface != null) {
            for (LayerInterface layer : this.atlasInterface) {
                if (layer == this || !newName.equals(layer.getName())) continue;
                throw new InvalidNameException("There is already a layer named \"" + newName + "\" in this atlas.\nLayer names have to unique within an atlas.");
            }
        }
        this.name = newName;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public long calculateTilesToDownload() {
        long result = 0L;
        for (MapInterface map : this.maps) {
            result += map.calculateTilesToDownload();
        }
        return result;
    }

    @Override
    public double getMinLat() {
        double lat = 90.0;
        for (MapInterface m : this.maps) {
            lat = Math.min(lat, m.getMinLat());
        }
        return lat;
    }

    @Override
    public double getMaxLat() {
        double lat = -90.0;
        for (MapInterface m : this.maps) {
            lat = Math.max(lat, m.getMaxLat());
        }
        return lat;
    }

    @Override
    public double getMinLon() {
        double lon = 180.0;
        for (MapInterface m : this.maps) {
            lon = Math.min(lon, m.getMinLon());
        }
        return lon;
    }

    @Override
    public double getMaxLon() {
        double lon = -180.0;
        for (MapInterface m : this.maps) {
            lon = Math.max(lon, m.getMaxLon());
        }
        return lon;
    }

    @Override
    public String getToolTip() {
        StringWriter sw = new StringWriter(1024);
        sw.write("<html>");
        sw.write(I18nUtils.localizedStringForKey("lp_atlas_info_layer_title", new Object[0]));
        sw.write(I18nUtils.localizedStringForKey("lp_atlas_info_layer_map_count", this.maps.size()));
        sw.write(I18nUtils.localizedStringForKey("lp_atlas_info_max_tile", this.calculateTilesToDownload()));
        sw.write(I18nUtils.localizedStringForKey("lp_atlas_info_area_start", Utilities.prettyPrintLatLon(this.getMaxLat(), true), Utilities.prettyPrintLatLon(this.getMinLon(), false)));
        sw.write(I18nUtils.localizedStringForKey("lp_atlas_info_area_end", Utilities.prettyPrintLatLon(this.getMinLat(), true), Utilities.prettyPrintLatLon(this.getMaxLon(), false)));
        sw.write("</html>");
        return sw.toString();
    }

    @Override
    public Iterator<MapInterface> iterator() {
        return this.maps.iterator();
    }

    public Enumeration<?> children() {
        return Collections.enumeration(this.maps);
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public TreeNode getChildAt(int childIndex) {
        return (TreeNode)((Object)this.maps.get(childIndex));
    }

    @Override
    public int getChildCount() {
        return this.maps.size();
    }

    @Override
    public int getIndex(TreeNode node) {
        return this.maps.indexOf(node);
    }

    @Override
    public TreeNode getParent() {
        return (TreeNode)((Object)this.atlasInterface);
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    public void afterUnmarshal(Unmarshaller u, Object parent) {
        this.atlasInterface = (Atlas)parent;
    }

    @Override
    public boolean checkData() {
        if (this.atlasInterface == null) {
            return true;
        }
        if (this.name == null) {
            return true;
        }
        HashSet<String> names = new HashSet<String>(this.maps.size());
        for (MapInterface map : this.maps) {
            names.add(map.getName());
        }
        return names.size() < this.maps.size();
    }

    public void deleteMap(Map map) {
        this.maps.remove(map);
    }

    @Override
    public LayerInterface deepClone(AtlasInterface atlas) {
        Layer layer = new Layer();
        layer.atlasInterface = atlas;
        layer.name = this.name;
        for (MapInterface map : this.maps) {
            layer.maps.add(map.deepClone(layer));
        }
        return layer;
    }
}

