/*
 * Decompiled with CFR 0.152.
 */
package mobac.program.model;

import java.awt.Toolkit;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import javax.swing.JOptionPane;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import mobac.exceptions.InvalidNameException;
import mobac.program.interfaces.AtlasInterface;
import mobac.program.interfaces.AtlasObject;
import mobac.program.interfaces.LayerInterface;
import mobac.program.interfaces.MapInterface;
import mobac.program.model.Atlas;
import mobac.program.model.Profile;
import org.apache.log4j.Logger;

public class AtlasTreeModel
implements TreeModel {
    private static Logger log = Logger.getLogger(AtlasTreeModel.class);
    protected AtlasInterface atlasInterface;
    protected Set<TreeModelListener> listeners = new HashSet<TreeModelListener>();

    public AtlasTreeModel() {
        this.atlasInterface = Atlas.newInstance();
    }

    public void addTreeModelListener(TreeModelListener l) {
        this.listeners.add(l);
    }

    public void removeTreeModelListener(TreeModelListener l) {
        this.listeners.remove(l);
    }

    public void notifyStructureChanged() {
        this.notifyStructureChanged((TreeNode)((Object)this.atlasInterface));
    }

    public void notifyStructureChanged(TreeNode root) {
        this.notifyStructureChanged(new TreeModelEvent((Object)this, new Object[]{root}));
    }

    public void notifyNodeDelete(TreeNode node) {
        TreeNode parent = node.getParent();
        Object[] children = new Object[]{node};
        int childrenIdx = parent.getIndex(node);
        if (childrenIdx == -1) {
            this.notifyStructureChanged();
            return;
        }
        TreePath path = this.getNodePath(parent);
        TreeModelEvent event = new TreeModelEvent((Object)this, path, new int[]{childrenIdx}, children);
        for (TreeModelListener l : this.listeners) {
            l.treeNodesRemoved(event);
        }
    }

    protected void notifyStructureChanged(TreeModelEvent event) {
        for (TreeModelListener l : this.listeners) {
            l.treeStructureChanged(event);
        }
    }

    public void notifyNodeInsert(TreeNode insertedNode) {
        TreeNode parent = insertedNode.getParent();
        TreePath path = this.getNodePath(parent);
        Object[] childs = new TreeNode[]{insertedNode};
        int childId = parent.getIndex(insertedNode);
        assert (childId <= 0);
        TreeModelEvent event = new TreeModelEvent((Object)this, path, new int[]{childId}, childs);
        for (TreeModelListener l : this.listeners) {
            l.treeNodesInserted(event);
        }
    }

    public TreePath getNodePath(TreeNode node) {
        LinkedList<TreeNode> path = new LinkedList<TreeNode>();
        for (TreeNode n = node; n != null; n = n.getParent()) {
            path.addFirst(n);
        }
        return new TreePath(path.toArray());
    }

    public Object getChild(Object parent, int index) {
        return ((TreeNode)parent).getChildAt(index);
    }

    public int getChildCount(Object parent) {
        return ((TreeNode)parent).getChildCount();
    }

    public int getIndexOfChild(Object parent, Object child) {
        return ((TreeNode)parent).getIndex((TreeNode)child);
    }

    public Object getRoot() {
        return this.atlasInterface;
    }

    public boolean isLeaf(Object node) {
        return ((TreeNode)node).isLeaf();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void valueForPathChanged(TreePath path, Object newValue) {
        Object o = path.getLastPathComponent();
        boolean success = false;
        try {
            AtlasObject sel = (AtlasObject)o;
            String newName = (String)newValue;
            if (newName.length() == 0) {
                return;
            }
            sel.setName(newName);
            success = true;
        }
        catch (ClassCastException e) {
            log.error("", e);
        }
        catch (InvalidNameException e) {
            log.error(e.getLocalizedMessage());
            JOptionPane.showMessageDialog(null, e.getLocalizedMessage(), "Renaming failed", 0);
        }
        finally {
            if (!success) {
                Toolkit.getDefaultToolkit().beep();
            }
        }
    }

    public void mergeLayers(LayerInterface source, LayerInterface target) throws InvalidNameException {
        boolean sourceFound = false;
        boolean targetFound = false;
        for (LayerInterface l : this.atlasInterface) {
            if (l.equals(source)) {
                sourceFound = true;
            }
            if (!l.equals(target)) continue;
            targetFound = true;
        }
        if (!targetFound) {
            return;
        }
        HashSet<String> names = new HashSet<String>();
        for (MapInterface map : source) {
            names.add(map.getName());
        }
        for (MapInterface map : target) {
            names.add(map.getName());
        }
        if (names.size() < source.getMapCount() + target.getMapCount()) {
            throw new InvalidNameException("Map naming conflict:\nThe layers to be merged contain map(s) of the same name.");
        }
        if (sourceFound) {
            this.atlasInterface.deleteLayer(source);
        }
        for (MapInterface map : source) {
            target.addMap(map);
        }
        this.notifyNodeDelete((TreeNode)((Object)source));
        this.notifyStructureChanged((TreeNode)((Object)target));
    }

    public void moveMap(MapInterface map, LayerInterface targetLayer) {
        this.notifyNodeDelete((TreeNode)((Object)map));
        map.delete();
        targetLayer.addMap(map);
        this.notifyNodeInsert((TreeNode)((Object)map));
    }

    public AtlasInterface getAtlas() {
        return this.atlasInterface;
    }

    public void setAtlas(Atlas atlas) {
        this.atlasInterface = atlas;
        this.notifyStructureChanged();
    }

    public void save(Profile profile) throws Exception {
        profile.save(this.atlasInterface);
    }

    public void load(Profile profile) throws Exception {
        this.atlasInterface = profile.load();
        this.notifyStructureChanged();
    }
}

