/*
 * Decompiled with CFR 0.152.
 */
package mobac.program.atlascreators.tileprovider;

import java.awt.image.BufferedImage;
import java.io.IOException;
import mobac.exceptions.TileException;
import mobac.program.atlascreators.tileprovider.TileProvider;
import mobac.program.interfaces.MapSource;

public class MapSourceProvider
implements TileProvider {
    protected final MapSource mapSource;
    protected final int zoom;
    protected final MapSource.LoadMethod loadMethod;

    public MapSourceProvider(MapSource mapSource, int zoom, MapSource.LoadMethod loadMethod) {
        this.mapSource = mapSource;
        this.zoom = zoom;
        this.loadMethod = loadMethod;
    }

    public byte[] getTileData(int x, int y) throws IOException {
        try {
            return this.mapSource.getTileData(this.zoom, x, y, this.loadMethod);
        }
        catch (TileException e) {
            throw new IOException(e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public BufferedImage getTileImage(int x, int y) throws IOException {
        try {
            return this.mapSource.getTileImage(this.zoom, x, y, this.loadMethod);
        }
        catch (TileException e) {
            throw new IOException(e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean preferTileImageUsage() {
        return false;
    }
}

