/*
 * Decompiled with CFR 0.152.
 */
package mobac.program.atlascreators.tileprovider;

import java.awt.image.BufferedImage;
import java.io.IOException;
import mobac.program.atlascreators.tileprovider.MapSourceProvider;
import mobac.program.interfaces.MapInterface;
import mobac.program.interfaces.MapSource;
import mobac.program.interfaces.TileFilter;

public class FilteredMapSourceProvider
extends MapSourceProvider {
    protected final TileFilter tileFilter;

    public FilteredMapSourceProvider(MapInterface map, MapSource.LoadMethod loadMethod) {
        this(map.getMapSource(), map.getZoom(), loadMethod, map.getTileFilter());
    }

    public FilteredMapSourceProvider(MapSource mapSource, int zoom, MapSource.LoadMethod loadMethod, TileFilter tileFilter) {
        super(mapSource, zoom, loadMethod);
        this.tileFilter = tileFilter;
    }

    public byte[] getTileData(int x, int y) throws IOException {
        if (!this.tileFilter.testTile(x, y, this.zoom, this.mapSource)) {
            return null;
        }
        return super.getTileData(x, y);
    }

    public BufferedImage getTileImage(int x, int y) throws IOException {
        if (!this.tileFilter.testTile(x, y, this.zoom, this.mapSource)) {
            return null;
        }
        return super.getTileImage(x, y);
    }
}

