/*
 * Decompiled with CFR 0.152.
 */
package mobac.program.atlascreators.impl.rmp.rmpfile;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import mobac.program.atlascreators.impl.rmp.RmpTools;
import mobac.program.atlascreators.impl.rmp.rmpfile.GeneralRmpFileEntry;
import org.apache.log4j.Logger;

public class RmpIni
extends GeneralRmpFileEntry {
    private static final Logger log = Logger.getLogger(RmpIni.class);

    public RmpIni(String layername, int count) {
        super(RmpIni.generateContent(layername, count), "rmp", "ini");
    }

    private static byte[] generateContent(String layername, int count) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(bos);
        ps.print("[T_Layers]\r\n");
        for (int i = 0; i < count; ++i) {
            String layerName = RmpTools.buildTileName(layername, i);
            log.trace("layer name: " + layerName);
            ps.print(i + "=" + layerName + "\r\n");
        }
        ps.flush();
        return bos.toByteArray();
    }

    public String toString() {
        return this.getClass().getSimpleName() + " size=" + this.content.length;
    }
}

