/*
 * Decompiled with CFR 0.152.
 */
package mobac.program.atlascreators.impl.rmp;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.IOException;
import mobac.program.atlascreators.impl.rmp.BoundingRect;
import mobac.program.atlascreators.tileprovider.TileProvider;
import mobac.program.interfaces.MapSpace;
import org.apache.log4j.Logger;

public class MobacTile {
    private static final Logger log = Logger.getLogger(MobacTile.class);
    private final TileProvider tileProvider;
    private final int tilex;
    private final int tiley;
    private BufferedImage image;
    private BoundingRect boundingRect;

    public MobacTile(TileProvider tileProvider, MapSpace mapSpace, int tilex, int tiley, int zoom) {
        this.tileProvider = tileProvider;
        this.tilex = tilex;
        this.tiley = tiley;
        this.image = null;
        int tileSize = mapSpace.getTileSize();
        int x = tilex * tileSize;
        int y = tiley * tileSize;
        double north = mapSpace.cYToLat(y, zoom);
        double south = mapSpace.cYToLat(y + tileSize - 1, zoom);
        double west = mapSpace.cXToLon(x, zoom);
        double east = mapSpace.cXToLon(x + tileSize - 1, zoom);
        this.boundingRect = new BoundingRect(-north, -south, west, east);
    }

    public BufferedImage getImage() {
        if (this.image == null) {
            this.image = this.loadImage();
        }
        return this.image;
    }

    private BufferedImage loadImage() {
        try {
            this.image = this.tileProvider.getTileImage(this.tilex, this.tiley);
        }
        catch (IOException e) {
            log.error("", e);
            this.image = this.createBlack(256, 256);
        }
        return this.image;
    }

    private BufferedImage createBlack(int width, int height) {
        BufferedImage img = new BufferedImage(width, height, 1);
        Graphics graph = img.getGraphics();
        graph.setColor(Color.BLACK);
        graph.fillRect(0, 0, width, height);
        return img;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawSubImage(BoundingRect dest_area, BufferedImage dest_image) {
        int[] pixel = new int[3];
        BoundingRect src_area = this.boundingRect;
        BufferedImage src_image = this.getImage();
        if (src_image == null) {
            return;
        }
        BufferedImage imageBuffer = new BufferedImage(src_image.getWidth(), src_image.getHeight(), 1);
        Graphics2D graphics = imageBuffer.createGraphics();
        try {
            graphics.drawImage((Image)src_image, 0, 0, null);
        }
        finally {
            graphics.dispose();
        }
        WritableRaster src_graph = imageBuffer.getRaster();
        WritableRaster dst_graph = dest_image.getRaster();
        int maxx = dest_image.getWidth();
        int maxy = dest_image.getHeight();
        for (int y = 0; y < maxy; ++y) {
            double src_c_y = dest_area.getNorth() + (dest_area.getSouth() - dest_area.getNorth()) * (double)y / (double)maxy;
            int pix_y = (int)((src_c_y - src_area.getNorth()) * 256.0 / (src_area.getSouth() - src_area.getNorth()) + 0.5);
            if (pix_y < 0 || pix_y > 255) continue;
            for (int x = 0; x < maxx; ++x) {
                double src_c_x = dest_area.getWest() + (dest_area.getEast() - dest_area.getWest()) * (double)x / (double)maxx;
                int pix_x = (int)((src_c_x - src_area.getWest()) * 256.0 / (src_area.getEast() - src_area.getWest()) + 0.5);
                if (pix_x < 0 || pix_x > 255) continue;
                src_graph.getPixel(pix_x, pix_y, pixel);
                dst_graph.setPixel(x, y, pixel);
            }
        }
    }

    public String toString() {
        return String.format("MobacTile x/y [%d/%d] = %s", this.tilex, this.tiley, this.boundingRect);
    }
}

