/*
 * Decompiled with CFR 0.152.
 */
package mobac.program.atlascreators;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import mobac.program.annotations.AtlasCreatorName;
import mobac.program.atlascreators.TrekBuddy;
import mobac.program.atlascreators.impl.MapTileWriter;
import mobac.utilities.Utilities;
import mobac.utilities.tar.TarArchive;
import mobac.utilities.tar.TarTmiArchive;

@AtlasCreatorName(value="TrekBuddy tared atlas", type="TaredAtlas")
public class TrekBuddyTared
extends TrekBuddy {
    public void finishAtlasCreation() {
        this.createAtlasTarArchive("cr");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createAtlasTarArchive(String name) {
        this.log.trace("Creating cr.tar for atlas in dir \"" + this.atlasDir.getPath() + "\"");
        File[] atlasLayerDirs = Utilities.listSubDirectories(this.atlasDir);
        LinkedList<File> atlasMapDirs = new LinkedList<File>();
        for (File dir : atlasLayerDirs) {
            Utilities.addSubDirectories(atlasMapDirs, dir, 0);
        }
        TarArchive ta = null;
        File crFile = new File(this.atlasDir, name + ".tar");
        try {
            ta = new TarArchive(crFile, this.atlasDir);
            ta.writeFileFromData(name + ".tba", "Atlas 1.0\r\n".getBytes());
            for (File mapDir : atlasMapDirs) {
                ta.writeFile(mapDir);
                File mapFile = new File(mapDir, mapDir.getName() + ".map");
                ta.writeFile(mapFile);
                try {
                    mapFile.delete();
                }
                catch (Exception e) {}
            }
            ta.writeEndofArchive();
        }
        catch (IOException e) {
            this.log.error("Failed writing tar file \"" + crFile.getPath() + "\"", e);
        }
        finally {
            if (ta != null) {
                ta.close();
            }
        }
    }

    protected MapTileWriter createMapTileWriter() throws IOException {
        return new TarTileWriter();
    }

    private class TarTileWriter
    implements MapTileWriter {
        TarArchive ta = null;
        int tileHeight = 256;
        int tileWidth = 256;

        public TarTileWriter() {
            if (TrekBuddyTared.this.parameters != null) {
                this.tileHeight = TrekBuddyTared.this.parameters.getHeight();
                this.tileWidth = TrekBuddyTared.this.parameters.getWidth();
            }
            File mapTarFile = new File(TrekBuddyTared.this.mapDir, TrekBuddyTared.this.map.getName() + ".tar");
            TrekBuddyTared.this.log.debug("Writing tiles to tared map: " + mapTarFile);
            try {
                this.ta = new TarTmiArchive(mapTarFile, null);
                ByteArrayOutputStream buf = new ByteArrayOutputStream(8192);
                TrekBuddyTared.this.writeMapFile(buf);
                this.ta.writeFileFromData(TrekBuddyTared.this.map.getName() + ".map", buf.toByteArray());
            }
            catch (IOException e) {
                TrekBuddyTared.this.log.error("", e);
            }
        }

        public void writeTile(int tilex, int tiley, String imageFormat, byte[] tileData) throws IOException {
            String tileFileName = String.format("t_%d_%d.%s", tilex * this.tileWidth, tiley * this.tileHeight, imageFormat);
            this.ta.writeFileFromData("set/" + tileFileName, tileData);
        }

        public void finalizeMap() {
            try {
                this.ta.writeEndofArchive();
            }
            catch (IOException e) {
                TrekBuddyTared.this.log.error("", e);
            }
            this.ta.close();
        }
    }
}

