/*
 * Decompiled with CFR 0.152.
 */
package mobac.program.atlascreators;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Locale;
import javax.imageio.ImageIO;
import mobac.exceptions.AtlasTestException;
import mobac.exceptions.MapCreationException;
import mobac.mapsources.mapspace.MercatorPower2MapSpace;
import mobac.program.annotations.AtlasCreatorName;
import mobac.program.annotations.SupportedParameters;
import mobac.program.atlascreators.AtlasCreator;
import mobac.program.atlascreators.impl.MapTileBuilder;
import mobac.program.atlascreators.impl.MapTileWriter;
import mobac.program.atlascreators.tileprovider.CacheTileProvider;
import mobac.program.atlascreators.tileprovider.TileProvider;
import mobac.program.interfaces.AtlasInterface;
import mobac.program.interfaces.LayerInterface;
import mobac.program.interfaces.MapInterface;
import mobac.program.interfaces.MapSource;
import mobac.program.interfaces.MapSpace;
import mobac.program.model.TileImageParameters;
import mobac.utilities.Utilities;
import mobac.utilities.geo.GeoUtils;

@AtlasCreatorName(value="TrekBuddy untared atlas", type="UntaredAtlas")
@SupportedParameters(names={TileImageParameters.Name.format, TileImageParameters.Name.height, TileImageParameters.Name.width})
public class TrekBuddy
extends AtlasCreator {
    protected File layerDir = null;
    protected File mapDir = null;
    protected MapTileWriter mapTileWriter;

    public boolean testMapSource(MapSource mapSource) {
        MapSpace mapSpace = mapSource.getMapSpace();
        return mapSpace instanceof MercatorPower2MapSpace && MapSpace.ProjectionCategory.SPHERE.equals((Object)mapSpace.getProjectionCategory());
    }

    public void startAtlasCreation(AtlasInterface atlas, File customAtlasDir) throws IOException, InterruptedException, AtlasTestException {
        super.startAtlasCreation(atlas, customAtlasDir);
    }

    public void finishAtlasCreation() {
        this.createAtlasTbaFile("cr");
    }

    public void initializeMap(MapInterface map, TileProvider mapTileProvider) {
        super.initializeMap(map, mapTileProvider);
        LayerInterface layer = map.getLayer();
        this.layerDir = new File(this.atlasDir, layer.getName());
        this.mapDir = new File(this.layerDir, map.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeMapFile() throws IOException {
        File mapFile = new File(this.mapDir, this.map.getName() + ".map");
        FileOutputStream mapFileStream = null;
        try {
            mapFileStream = new FileOutputStream(mapFile);
            this.writeMapFile(mapFileStream);
        }
        catch (Throwable throwable) {
            Utilities.closeStream(mapFileStream);
            throw throwable;
        }
        Utilities.closeStream(mapFileStream);
    }

    protected void writeMapFile(OutputStream stream) throws IOException {
        this.writeMapFile("t_." + this.mapSource.getTileImageType().getFileExt(), stream);
    }

    protected void writeMapFile(String imageFileName, OutputStream stream) throws IOException {
        this.log.trace("Writing map file");
        OutputStreamWriter mapWriter = new OutputStreamWriter(stream, TEXT_FILE_CHARSET);
        MapSpace mapSpace = this.mapSource.getMapSpace();
        double longitudeMin = mapSpace.cXToLon(this.xMin * this.tileSize, this.zoom);
        double longitudeMax = mapSpace.cXToLon((this.xMax + 1) * this.tileSize - 1, this.zoom);
        double latitudeMin = mapSpace.cYToLat((this.yMax + 1) * this.tileSize - 1, this.zoom);
        double latitudeMax = mapSpace.cYToLat(this.yMin * this.tileSize, this.zoom);
        int width = (this.xMax - this.xMin + 1) * this.tileSize;
        int height = (this.yMax - this.yMin + 1) * this.tileSize;
        mapWriter.write(this.prepareMapString(imageFileName, longitudeMin, longitudeMax, latitudeMin, latitudeMax, width, height));
        mapWriter.flush();
    }

    public void createMap() throws MapCreationException, InterruptedException {
        try {
            Utilities.mkDirs(this.mapDir);
            this.writeMapFile();
            this.mapTileWriter = this.createMapTileWriter();
            if (this.parameters != null) {
                this.createCustomTiles();
            } else {
                this.createTiles();
            }
            this.mapTileWriter.finalizeMap();
        }
        catch (MapCreationException e) {
            throw e;
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MapCreationException(this.map, (Throwable)e);
        }
    }

    protected MapTileWriter createMapTileWriter() throws IOException {
        return new FileTileWriter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createCustomTiles() throws InterruptedException, MapCreationException {
        this.log.debug("Starting map creation using custom parameters: " + this.parameters);
        CacheTileProvider ctp = new CacheTileProvider(this.mapDlTileProvider);
        try {
            this.mapDlTileProvider = ctp;
            MapTileBuilder mapTileBuilder = new MapTileBuilder(this, this.mapTileWriter, true);
            this.atlasProgress.initMapCreation(mapTileBuilder.getCustomTileCount());
            mapTileBuilder.createTiles();
        }
        finally {
            ctp.cleanup();
        }
    }

    protected void createTiles() throws InterruptedException, MapCreationException {
        int tilex = 0;
        int tiley = 0;
        this.atlasProgress.initMapCreation((this.xMax - this.xMin + 1) * (this.yMax - this.yMin + 1));
        ImageIO.setUseCache(false);
        byte[] emptyTileData = Utilities.createEmptyTileData(this.mapSource);
        String tileType = this.mapSource.getTileImageType().getFileExt();
        for (int x = this.xMin; x <= this.xMax; ++x) {
            tiley = 0;
            for (int y = this.yMin; y <= this.yMax; ++y) {
                this.checkUserAbort();
                this.atlasProgress.incMapCreationProgress();
                try {
                    byte[] sourceTileData = this.mapDlTileProvider.getTileData(x, y);
                    if (sourceTileData != null) {
                        this.mapTileWriter.writeTile(tilex, tiley, tileType, sourceTileData);
                    } else {
                        this.log.trace(String.format("Tile x=%d y=%d not found in tile archive - creating default", tilex, tiley));
                        this.mapTileWriter.writeTile(tilex, tiley, tileType, emptyTileData);
                    }
                }
                catch (IOException e) {
                    throw new MapCreationException("Error writing tile image: " + e.getMessage(), this.map, e);
                }
                ++tiley;
            }
            ++tilex;
        }
    }

    protected String prepareMapString(String fileName, double longitudeMin, double longitudeMax, double latitudeMin, double latitudeMax, int width, int height) {
        StringBuffer sbMap = new StringBuffer();
        sbMap.append("OziExplorer Map Data File Version 2.2\r\n");
        sbMap.append(fileName + "\r\n");
        sbMap.append(fileName + "\r\n");
        sbMap.append("1 ,Map Code,\r\n");
        sbMap.append("WGS 84,WGS 84,   0.0000,   0.0000,WGS 84\r\n");
        sbMap.append("Reserved 1\r\n");
        sbMap.append("Reserved 2\r\n");
        sbMap.append("Magnetic Variation,,,E\r\n");
        sbMap.append("Map Projection,Mercator,PolyCal,No,AutoCalOnly,No,BSBUseWPX,No\r\n");
        String latMax = GeoUtils.getDegMinFormat(latitudeMax, true);
        String latMin = GeoUtils.getDegMinFormat(latitudeMin, true);
        String lonMax = GeoUtils.getDegMinFormat(longitudeMax, false);
        String lonMin = GeoUtils.getDegMinFormat(longitudeMin, false);
        String pointLine = "Point%02d,xy, %4s, %4s,in, deg, %1s, %1s, grid, , , ,N\r\n";
        sbMap.append(String.format(pointLine, 1, 0, 0, latMax, lonMin));
        sbMap.append(String.format(pointLine, 2, width - 1, 0, latMax, lonMax));
        sbMap.append(String.format(pointLine, 3, width - 1, height - 1, latMin, lonMax));
        sbMap.append(String.format(pointLine, 4, 0, height - 1, latMin, lonMin));
        for (int i = 5; i <= 30; ++i) {
            String s = String.format(pointLine, i, "", "", "", "");
            sbMap.append(s);
        }
        sbMap.append("Projection Setup,,,,,,,,,,\r\n");
        sbMap.append("Map Feature = MF ; Map Comment = MC     These follow if they exist\r\n");
        sbMap.append("Track File = TF      These follow if they exist\r\n");
        sbMap.append("Moving Map Parameters = MM?    These follow if they exist\r\n");
        sbMap.append("MM0,Yes\r\n");
        sbMap.append("MMPNUM,4\r\n");
        String mmpxLine = "MMPXY, %d, %5d, %5d\r\n";
        sbMap.append(String.format(mmpxLine, 1, 0, 0));
        sbMap.append(String.format(mmpxLine, 2, width - 1, 0));
        sbMap.append(String.format(mmpxLine, 3, width - 1, height - 1));
        sbMap.append(String.format(mmpxLine, 4, 0, height - 1));
        String mpllLine = "MMPLL, %d, %2.6f, %2.6f\r\n";
        sbMap.append(String.format(Locale.ENGLISH, mpllLine, 1, longitudeMin, latitudeMax));
        sbMap.append(String.format(Locale.ENGLISH, mpllLine, 2, longitudeMax, latitudeMax));
        sbMap.append(String.format(Locale.ENGLISH, mpllLine, 3, longitudeMax, latitudeMin));
        sbMap.append(String.format(Locale.ENGLISH, mpllLine, 4, longitudeMin, latitudeMin));
        sbMap.append("MOP,Map Open Position,0,0\r\n");
        double mm1b = (longitudeMax - longitudeMin) * 111319.0;
        sbMap.append(String.format(Locale.ENGLISH, "MM1B, %2.6f\r\n", mm1b *= Math.cos(Math.toRadians((latitudeMax + latitudeMin) / 2.0)) / (double)width));
        sbMap.append("IWH,Map Image Width/Height, " + width + ", " + height + "\r\n");
        return sbMap.toString();
    }

    public void createAtlasTbaFile(String name) {
        File crtba = new File(this.atlasDir.getAbsolutePath(), name + ".tba");
        try {
            FileWriter fw = new FileWriter(crtba);
            fw.write("Atlas 1.0\r\n");
            fw.close();
        }
        catch (IOException e) {
            this.log.error("", e);
        }
    }

    private class FileTileWriter
    implements MapTileWriter {
        File setFolder;
        Writer setFileWriter;
        int tileHeight = 256;
        int tileWidth = 256;

        public FileTileWriter() throws IOException {
            this.setFolder = new File(TrekBuddy.this.mapDir, "set");
            Utilities.mkDir(this.setFolder);
            TrekBuddy.this.log.debug("Writing tiles to set folder: " + this.setFolder);
            File setFile = new File(TrekBuddy.this.mapDir, TrekBuddy.this.map.getName() + ".set");
            if (TrekBuddy.this.parameters != null) {
                this.tileHeight = TrekBuddy.this.parameters.getHeight();
                this.tileWidth = TrekBuddy.this.parameters.getWidth();
            }
            try {
                this.setFileWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(setFile), AtlasCreator.TEXT_FILE_CHARSET));
            }
            catch (IOException e) {
                TrekBuddy.this.log.error("", e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void writeTile(int tilex, int tiley, String imageFormat, byte[] tileData) throws IOException {
            String tileFileName = String.format("t_%d_%d.%s", tilex * this.tileWidth, tiley * this.tileHeight, imageFormat);
            File f = new File(this.setFolder, tileFileName);
            FileOutputStream out = new FileOutputStream(f);
            this.setFileWriter.write(tileFileName + "\r\n");
            try {
                out.write(tileData);
            }
            finally {
                Utilities.closeStream(out);
            }
        }

        public void finalizeMap() {
            try {
                this.setFileWriter.flush();
            }
            catch (IOException e) {
                TrekBuddy.this.log.error("", e);
            }
            Utilities.closeWriter(this.setFileWriter);
        }
    }
}

