/*
 * Decompiled with CFR 0.152.
 */
package mobac.program.atlascreators;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Locale;
import mobac.exceptions.AtlasTestException;
import mobac.exceptions.MapCreationException;
import mobac.program.annotations.AtlasCreatorName;
import mobac.program.annotations.SupportedParameters;
import mobac.program.atlascreators.AtlasCreator;
import mobac.program.atlascreators.tileprovider.ConvertedRawTileProvider;
import mobac.program.interfaces.AtlasInterface;
import mobac.program.interfaces.MapSource;
import mobac.program.interfaces.MapSpace;
import mobac.program.interfaces.RequiresSQLite;
import mobac.program.model.Settings;
import mobac.program.model.TileImageParameters;
import mobac.utilities.Utilities;
import mobac.utilities.jdbc.SQLiteLoader;

@AtlasCreatorName(value="RMaps SQLite", type="RMaps")
@SupportedParameters(names={TileImageParameters.Name.format})
public class RMapsSQLite
extends AtlasCreator
implements RequiresSQLite {
    protected File databaseFile;
    protected Connection conn = null;
    protected PreparedStatement prepStmt;

    public RMapsSQLite() {
        SQLiteLoader.loadSQLiteOrShowError();
    }

    public boolean testMapSource(MapSource mapSource) {
        MapSpace mapSpace = mapSource.getMapSpace();
        boolean correctTileSize = 256 == mapSpace.getTileSize();
        MapSpace.ProjectionCategory pc = mapSpace.getProjectionCategory();
        boolean correctProjection = MapSpace.ProjectionCategory.SPHERE.equals((Object)pc) || MapSpace.ProjectionCategory.ELLIPSOID.equals((Object)pc);
        return correctTileSize && correctProjection;
    }

    public void startAtlasCreation(AtlasInterface atlas, File customAtlasDir) throws IOException, AtlasTestException, InterruptedException {
        if (customAtlasDir == null) {
            customAtlasDir = Settings.getInstance().getAtlasOutputDirectory();
        }
        super.startAtlasCreation(atlas, customAtlasDir);
        this.databaseFile = new File(this.atlasDir, this.getDatabaseFileName());
        this.log.debug("SQLite Database file: " + this.databaseFile);
    }

    public void createMap() throws MapCreationException, InterruptedException {
        try {
            Utilities.mkDir(this.atlasDir);
        }
        catch (IOException e) {
            throw new MapCreationException(this.map, (Throwable)e);
        }
        try {
            SQLiteLoader.loadSQLite();
        }
        catch (SQLException e) {
            throw new MapCreationException(SQLiteLoader.getMsgSqliteMissing(), this.map, e);
        }
        try {
            this.openConnection();
            this.initializeDB();
            this.createTiles();
        }
        catch (SQLException e) {
            throw new MapCreationException("Error creating SQL database \"" + this.databaseFile + "\": " + e.getMessage(), this.map, e);
        }
    }

    protected void openConnection() throws SQLException {
        if (this.conn == null || this.conn.isClosed()) {
            String url = "jdbc:sqlite:/" + this.databaseFile.getAbsolutePath();
            this.conn = DriverManager.getConnection(url);
        }
    }

    public void abortAtlasCreation() throws IOException {
        SQLiteLoader.closeConnection(this.conn);
        this.conn = null;
        super.abortAtlasCreation();
    }

    public void finishAtlasCreation() throws IOException, InterruptedException {
        SQLiteLoader.closeConnection(this.conn);
        this.conn = null;
        super.finishAtlasCreation();
    }

    protected void initializeDB() throws SQLException {
        Statement stat = this.conn.createStatement();
        stat.executeUpdate("CREATE TABLE IF NOT EXISTS tiles (x int, y int, z int, s int, image blob, PRIMARY KEY (x,y,z,s))");
        stat.executeUpdate("CREATE INDEX IF NOT EXISTS IND on tiles (x,y,z,s)");
        this.createInfoTable(stat);
        stat.executeUpdate("CREATE TABLE IF NOT EXISTS android_metadata (locale TEXT)");
        if (!stat.executeQuery("SELECT * FROM android_metadata").next()) {
            String locale = Locale.getDefault().toString();
            stat.executeUpdate("INSERT INTO android_metadata VALUES ('" + locale + "')");
        }
        stat.close();
    }

    protected void createInfoTable(Statement stat) throws SQLException {
        stat.executeUpdate("CREATE TABLE IF NOT EXISTS info AS SELECT 99 AS minzoom, 0 AS maxzoom");
    }

    protected void createTiles() throws InterruptedException, MapCreationException {
        int maxMapProgress = 2 * (this.xMax - this.xMin + 1) * (this.yMax - this.yMin + 1);
        this.atlasProgress.initMapCreation(maxMapProgress);
        TileImageParameters param = this.map.getParameters();
        if (param != null) {
            this.mapDlTileProvider = new ConvertedRawTileProvider(this.mapDlTileProvider, param.getFormat());
        }
        try {
            this.conn.setAutoCommit(false);
            int batchTileCount = 0;
            int tilesWritten = 0;
            Runtime r = Runtime.getRuntime();
            long heapMaxSize = r.maxMemory();
            this.prepStmt = this.conn.prepareStatement(this.getTileInsertSQL());
            for (int x = this.xMin; x <= this.xMax; ++x) {
                for (int y = this.yMin; y <= this.yMax; ++y) {
                    this.checkUserAbort();
                    this.atlasProgress.incMapCreationProgress();
                    try {
                        byte[] sourceTileData = this.mapDlTileProvider.getTileData(x, y);
                        if (sourceTileData == null) continue;
                        this.writeTile(x, y, this.zoom, sourceTileData);
                        ++tilesWritten;
                        long heapAvailable = heapMaxSize - r.totalMemory() + r.freeMemory();
                        if (heapAvailable >= 0x1400000L && ++batchTileCount < 1000) continue;
                        this.log.trace("Executing batch containing " + batchTileCount + " tiles");
                        this.prepStmt.executeBatch();
                        this.prepStmt.clearBatch();
                        System.gc();
                        this.conn.commit();
                        this.atlasProgress.incMapCreationProgress(batchTileCount);
                        batchTileCount = 0;
                        continue;
                    }
                    catch (IOException e) {
                        throw new MapCreationException(this.map, (Throwable)e);
                    }
                }
            }
            this.prepStmt.executeBatch();
            this.prepStmt.clearBatch();
            System.gc();
            if (tilesWritten > 0) {
                this.updateTileMetaInfo();
            }
            this.log.trace("Final commit containing " + batchTileCount + " tiles");
            this.conn.commit();
            this.atlasProgress.setMapCreationProgress(maxMapProgress);
        }
        catch (SQLException e) {
            throw new MapCreationException(this.map, (Throwable)e);
        }
    }

    protected void updateTileMetaInfo() throws SQLException {
        Statement stat = this.conn.createStatement();
        ResultSet rs = stat.executeQuery("SELECT DISTINCT z FROM tiles ORDER BY z DESC LIMIT 1;");
        if (!rs.next()) {
            throw new SQLException("failed to retrieve max tile zoom info");
        }
        int max = rs.getInt(1);
        rs.close();
        rs = stat.executeQuery("SELECT DISTINCT z FROM tiles ORDER BY z ASC LIMIT 1;");
        if (!rs.next()) {
            throw new SQLException("failed to retrieve min tile zoom info");
        }
        int min = rs.getInt(1);
        rs.close();
        PreparedStatement ps = this.conn.prepareStatement("INSERT INTO info (minzoom,maxzoom) VALUES (?,?);");
        ps.setInt(1, min);
        ps.setInt(2, max);
        stat.execute("DELETE FROM info;");
        ps.execute();
        stat.close();
        ps.close();
    }

    protected void writeTile(int x, int y, int z, byte[] tileData) throws SQLException, IOException {
        this.prepStmt.setInt(1, x);
        this.prepStmt.setInt(2, y);
        this.prepStmt.setInt(3, 17 - z);
        this.prepStmt.setBytes(4, tileData);
        this.prepStmt.addBatch();
    }

    protected String getDatabaseFileName() {
        return this.atlas.getName() + ".sqlitedb";
    }

    protected String getTileInsertSQL() {
        return "INSERT or REPLACE INTO tiles (x,y,z,s,image) VALUES (?,?,?,0,?)";
    }
}

