/*
 * Decompiled with CFR 0.152.
 */
package mobac.program.atlascreators;

import com.itextpdf.text.BadElementException;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Image;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.PdfWriter;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import mobac.exceptions.MapCreationException;
import mobac.program.ProgramInfo;
import mobac.program.annotations.AtlasCreatorName;
import mobac.program.atlascreators.PaperAtlas;
import mobac.program.model.UnitSystem;

@AtlasCreatorName(value="Paper Atlas (PDF)")
public class PaperAtlasPdf
extends PaperAtlas {
    private Document document;

    public PaperAtlasPdf() {
        super(false);
    }

    private Document createDocument(Rectangle r) throws MapCreationException {
        PdfWriter pdfWriter;
        File pdfFile = new File(this.getLayerFolder(), this.map.getName() + ".pdf");
        float left = (float)this.s.marginLeft;
        float right = (float)this.s.marginRight;
        float top = (float)this.s.marginTop;
        float bottom = (float)this.s.marginBottom;
        Document document = new Document(r, left, right, top, bottom);
        try {
            pdfFile.createNewFile();
            pdfWriter = PdfWriter.getInstance(document, new FileOutputStream(pdfFile));
        }
        catch (IOException e) {
            throw new MapCreationException(this.map, (Throwable)e);
        }
        catch (DocumentException e) {
            throw new MapCreationException(this.map, (Throwable)e);
        }
        pdfWriter.setCompressionLevel(this.s.compression);
        document.open();
        document.addAuthor(ProgramInfo.PROG_NAME);
        document.addCreationDate();
        document.addCreator(ProgramInfo.PROG_NAME);
        document.addProducer();
        return document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createMap() throws MapCreationException, InterruptedException {
        if (this.s.paperSize != null) {
            this.document = this.createDocument(this.s.paperSize.createRectangle());
        }
        try {
            super.createMap();
        }
        finally {
            try {
                this.document.close();
            }
            catch (Exception e) {
                new MapCreationException(this.map, (Throwable)e);
            }
            this.document = null;
        }
    }

    protected void processPage(BufferedImage image, int pageNumber) throws MapCreationException {
        Image iTextImage;
        int imageWidth = image.getWidth();
        int imageHeight = image.getHeight();
        if (this.document == null) {
            double width = UnitSystem.pixelsToPoints(imageWidth, this.s.dpi);
            double height = UnitSystem.pixelsToPoints(imageHeight, this.s.dpi);
            Rectangle r = new Rectangle((float)(width += this.s.marginLeft + this.s.marginRight), (float)(height += this.s.marginTop + this.s.marginBottom));
            this.document = this.createDocument(r);
        }
        try {
            iTextImage = Image.getInstance(image, Color.WHITE);
        }
        catch (BadElementException e) {
            throw new MapCreationException(this.map, (Throwable)e);
        }
        catch (IOException e) {
            throw new MapCreationException(this.map, (Throwable)e);
        }
        iTextImage.setCompressionLevel(this.s.compression);
        iTextImage.setDpi(this.s.dpi, this.s.dpi);
        float width = (float)UnitSystem.pixelsToPoints(imageWidth, this.s.dpi);
        float height = (float)UnitSystem.pixelsToPoints(imageHeight, this.s.dpi);
        iTextImage.scaleAbsolute(width, height);
        try {
            this.document.add(iTextImage);
        }
        catch (DocumentException e) {
            throw new MapCreationException(this.map, (Throwable)e);
        }
        this.document.newPage();
    }
}

