/*
 * Decompiled with CFR 0.152.
 */
package mobac.program.atlascreators;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import mobac.exceptions.MapCreationException;
import mobac.program.annotations.AtlasCreatorName;
import mobac.program.atlascreators.Ozi;
import mobac.program.atlascreators.tileprovider.TileProvider;
import mobac.program.interfaces.MapInterface;
import mobac.program.interfaces.MapSpace;
import mobac.utilities.Utilities;

@AtlasCreatorName(value="Glopus (PNG & KAL)")
public class Glopus
extends Ozi {
    public void initializeMap(MapInterface map, TileProvider mapTileProvider) {
        super.initializeMap(map, mapTileProvider);
        String layerName = map.getLayer().getName().replaceAll(" ", "_");
        this.mapName = map.getName().replaceAll(" ", "_");
        this.layerDir = new File(this.atlasDir, layerName);
    }

    public void createMap() throws MapCreationException, InterruptedException {
        try {
            Utilities.mkDir(this.layerDir);
        }
        catch (IOException e) {
            throw new MapCreationException(this.map, (Throwable)e);
        }
        this.createTiles();
        this.writeKalFile();
    }

    private void writeKalFile() throws MapCreationException {
        FileOutputStream fout = null;
        try {
            fout = new FileOutputStream(new File(this.layerDir, this.mapName + ".kal"));
            OutputStreamWriter mapWriter = new OutputStreamWriter((OutputStream)fout, TEXT_FILE_CHARSET);
            MapSpace mapSpace = this.mapSource.getMapSpace();
            String longitudeMin = Double.toString(mapSpace.cXToLon(this.xMin * this.tileSize, this.zoom));
            String longitudeMax = Double.toString(mapSpace.cXToLon((this.xMax + 1) * this.tileSize, this.zoom));
            String latitudeMin = Double.toString(mapSpace.cYToLat((this.yMax + 1) * this.tileSize, this.zoom));
            String latitudeMax = Double.toString(mapSpace.cYToLat(this.yMin * this.tileSize, this.zoom));
            int width = (this.xMax - this.xMin + 1) * this.tileSize;
            int height = (this.yMax - this.yMin + 1) * this.tileSize;
            mapWriter.write("[Calibration Point 1]\n");
            mapWriter.write(String.format("Longitude = %s\n", longitudeMin));
            mapWriter.write(String.format("Latitude =  %s\n", latitudeMax));
            mapWriter.write("Pixel = POINT(0,0)\n");
            mapWriter.write("[Calibration Point 2]\n");
            mapWriter.write(String.format("Longitude = %s\n", longitudeMax));
            mapWriter.write(String.format("Latitude =  %s\n", latitudeMin));
            mapWriter.write(String.format("Pixel = POINT(%d,%d)\n", width, height));
            mapWriter.write("[Calibration Point 3]\n");
            mapWriter.write(String.format("Longitude = %s\n", longitudeMax));
            mapWriter.write(String.format("Latitude =  %s\n", latitudeMax));
            mapWriter.write(String.format("Pixel = POINT(%d,%d)\n", width, 0));
            mapWriter.write("[Calibration Point 4]\n");
            mapWriter.write(String.format("Longitude = %s\n", longitudeMin));
            mapWriter.write(String.format("Latitude =  %s\n", latitudeMin));
            mapWriter.write(String.format("Pixel = POINT(%d,%d)\n", 0, height));
            mapWriter.write("[Map]\n");
            mapWriter.write(String.format("Bitmap = %s.png\n", this.mapName));
            mapWriter.write(String.format("Size = SIZE(%d,%d)\n", width, height));
            mapWriter.flush();
            mapWriter.close();
        }
        catch (IOException e) {
            try {
                throw new MapCreationException(this.map, (Throwable)e);
            }
            catch (Throwable throwable) {
                Utilities.closeStream(fout);
                throw throwable;
            }
        }
        Utilities.closeStream(fout);
    }
}

