/*
 * Decompiled with CFR 0.152.
 */
package mobac.program.atlascreators;

import java.awt.image.BufferedImage;
import java.io.IOException;
import mobac.exceptions.AtlasTestException;
import mobac.exceptions.MapCreationException;
import mobac.program.annotations.AtlasCreatorName;
import mobac.program.annotations.SupportedParameters;
import mobac.program.atlascreators.GoogleEarthOverlay;
import mobac.program.interfaces.LayerInterface;
import mobac.program.model.Settings;
import mobac.program.model.TileImageParameters;
import mobac.program.tiledatawriter.TileImageJpegDataWriter;
import mobac.utilities.stream.ArrayOutputStream;

@AtlasCreatorName(value="Garmin Custom Map (KMZ)")
@SupportedParameters(names={TileImageParameters.Name.format_jpg})
public class GarminCustom
extends GoogleEarthOverlay {
    protected void testAtlas() throws AtlasTestException {
        int maxMap = Settings.getInstance().atlasFormatSpecificSettings.garminCustomMaxMapCount;
        for (LayerInterface layer : this.atlas) {
            if (layer.getMapCount() <= maxMap) continue;
            throw new AtlasTestException("Layer exceeeds the maximum map count of " + maxMap, layer);
        }
    }

    protected void writeTileImage(BufferedImage tileImage) throws MapCreationException {
        try {
            TileImageJpegDataWriter writer;
            if (this.parameters != null) {
                writer = (TileImageJpegDataWriter)this.parameters.getFormat().getDataWriter();
                writer = new TileImageJpegDataWriter(writer);
            } else {
                writer = new TileImageJpegDataWriter(0.9);
            }
            writer.initialize();
            ArrayOutputStream buf = new ArrayOutputStream(0x300000);
            byte[] data = null;
            for (int c = 99; c > 50; c -= 5) {
                buf.reset();
                try {
                    writer.processImage(tileImage, buf);
                    data = buf.toByteArray();
                    break;
                }
                catch (IOException e) {
                    this.log.trace("Image size too large, increasing compression to " + c);
                    writer.setJpegCompressionLevel((float)c / 100.0f);
                    continue;
                }
            }
            if (data == null) {
                throw new MapCreationException("Unable to create an image with less than 3 MB!", this.map);
            }
            String imageFileName = "files/" + this.cleanedMapName + "." + (Object)((Object)writer.getType());
            this.kmzOutputStream.writeStoredEntry(imageFileName, data);
            this.addMapToKmz(imageFileName);
        }
        catch (Exception e) {
            throw new MapCreationException(this.map, (Throwable)e);
        }
    }

    protected int getMaxImageSize() {
        return 1024;
    }
}

