/*
 * Decompiled with CFR 0.152.
 */
package mobac.program.atlascreators;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Collections;
import javax.imageio.ImageIO;
import mobac.exceptions.AtlasTestException;
import mobac.exceptions.MapCreationException;
import mobac.mapsources.mapspace.MercatorPower2MapSpace;
import mobac.program.annotations.AtlasCreatorName;
import mobac.program.annotations.SupportedParameters;
import mobac.program.atlascreators.AtlasCreator;
import mobac.program.atlascreators.impl.MapTileWriter;
import mobac.program.atlascreators.tileprovider.ConvertedRawTileProvider;
import mobac.program.atlascreators.tileprovider.TileProvider;
import mobac.program.interfaces.LayerInterface;
import mobac.program.interfaces.MapInterface;
import mobac.program.interfaces.MapSource;
import mobac.program.model.TileImageParameters;
import mobac.utilities.Utilities;

@AtlasCreatorName(value="Geocaching Live offline map")
@SupportedParameters(names={TileImageParameters.Name.format})
public class GCLive
extends AtlasCreator {
    private MapTileWriter mapTileWriter = null;

    public boolean testMapSource(MapSource mapSource) {
        return MercatorPower2MapSpace.INSTANCE_256.equals(mapSource.getMapSpace());
    }

    protected void testAtlas() throws AtlasTestException {
        long tileCount = 0L;
        for (LayerInterface layer : this.atlas) {
            for (MapInterface map : layer) {
                int tileSize_t = 256;
                int xMin_t = map.getMinTileCoordinate().x / tileSize_t;
                int xMax_t = map.getMaxTileCoordinate().x / tileSize_t;
                int yMin_t = map.getMinTileCoordinate().y / tileSize_t;
                int yMax_t = map.getMaxTileCoordinate().y / tileSize_t;
                tileCount += (long)((xMax_t - xMin_t + 1) * (yMax_t - yMin_t + 1));
            }
            if (tileCount <= 65535L) continue;
            throw new AtlasTestException("Tile count too high in layer " + layer.getName() + "\n - please select smaller/fewer areas");
        }
    }

    public void initLayerCreation(LayerInterface layer) throws IOException {
        super.initLayerCreation(layer);
        this.mapTileWriter = new GCLiveWriter(new File(this.atlasDir, layer.getName()));
    }

    public void finishLayerCreation() throws IOException {
        this.mapTileWriter.finalizeMap();
        this.mapTileWriter = null;
        super.finishLayerCreation();
    }

    public void abortAtlasCreation() throws IOException {
        this.mapTileWriter.finalizeMap();
        this.mapTileWriter = null;
        super.abortAtlasCreation();
    }

    public void initializeMap(MapInterface map, TileProvider mapTileProvider) {
        super.initializeMap(map, mapTileProvider);
        if (this.parameters != null) {
            this.mapDlTileProvider = new ConvertedRawTileProvider(this.mapDlTileProvider, this.parameters.getFormat());
        }
    }

    public void createMap() throws MapCreationException, InterruptedException {
        this.createTiles();
    }

    protected void createTiles() throws InterruptedException, MapCreationException {
        this.atlasProgress.initMapCreation((this.xMax - this.xMin + 1) * (this.yMax - this.yMin + 1));
        ImageIO.setUseCache(false);
        for (int x = this.xMin; x <= this.xMax; ++x) {
            for (int y = this.yMin; y <= this.yMax; ++y) {
                this.checkUserAbort();
                this.atlasProgress.incMapCreationProgress();
                try {
                    byte[] sourceTileData = this.mapDlTileProvider.getTileData(x, y);
                    if (sourceTileData == null) continue;
                    this.mapTileWriter.writeTile(x, y, null, sourceTileData);
                    continue;
                }
                catch (IOException e) {
                    throw new MapCreationException("Error writing tile image: " + e.getMessage(), this.map, e);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class GCHeaderEntry
    implements Comparable<GCHeaderEntry> {
        public final int zoom;
        public final int tilex;
        public final int tiley;
        public final int dataFileIndex;
        public final int offset;
        public final int len;

        public GCHeaderEntry(int zoom, int tilex, int tiley, int dataFileIndex, int offset, int len) {
            this.zoom = zoom;
            this.tilex = tilex;
            this.tiley = tiley;
            this.dataFileIndex = dataFileIndex;
            this.offset = offset;
            this.len = len;
        }

        public void writeHeader(RandomAccessFile file) throws IOException {
            file.writeShort((short)(17 - this.zoom));
            file.write(this.tilex >> 16 & 0xFF);
            file.write(this.tilex >> 8 & 0xFF);
            file.write(this.tilex & 0xFF);
            file.write(this.tiley >> 16 & 0xFF);
            file.write(this.tiley >> 8 & 0xFF);
            file.write(this.tiley & 0xFF);
            file.writeInt(this.offset);
            int tmp = this.len << 4;
            file.write((tmp |= this.dataFileIndex >> 8 & 0xF) >> 16 & 0xFF);
            file.write(tmp >> 8 & 0xFF);
            file.write(tmp & 0xFF);
            file.write(this.dataFileIndex & 0xFF);
        }

        @Override
        public int compareTo(GCHeaderEntry o) {
            if (this.zoom > o.zoom) {
                return -1;
            }
            if (this.zoom < o.zoom) {
                return 1;
            }
            if (this.tilex > o.tilex) {
                return 1;
            }
            if (this.tilex < o.tilex) {
                return -1;
            }
            if (this.tiley > o.tiley) {
                return 1;
            }
            if (this.tiley < o.tiley) {
                return -1;
            }
            return 0;
        }

        public String toString() {
            return "GCHeaderEntry [zoom=" + this.zoom + ", tilex=" + this.tilex + ", tiley=" + this.tiley + ", dataFileIndex=" + this.dataFileIndex + ", offset=" + this.offset + ", len=" + this.len + "]";
        }
    }

    protected class GCLiveWriter
    implements MapTileWriter {
        private File mapDir;
        private int dataDirCounter = 0;
        private int dataFileCounter = 0;
        private int imageCounter = 0;
        private RandomAccessFile currentDataFile;
        private ArrayList<GCHeaderEntry> headerEntries;

        public GCLiveWriter(File mapDir) throws IOException {
            this.mapDir = mapDir;
            Utilities.mkDir(mapDir);
            this.headerEntries = new ArrayList(65535);
            this.prepareDataFile();
        }

        private void prepareDataFile() throws IOException {
            if (this.currentDataFile != null) {
                Utilities.closeFile(this.currentDataFile);
            }
            this.currentDataFile = null;
            File dataDir = new File(this.mapDir, Integer.toString(this.dataDirCounter));
            Utilities.mkDir(dataDir);
            File dataFile = new File(dataDir, "data" + Integer.toString(this.dataFileCounter));
            this.currentDataFile = new RandomAccessFile(dataFile, "rw");
            this.imageCounter = 0;
        }

        public void writeTile(int tilex, int tiley, String tileType, byte[] tileData) throws IOException {
            ++this.imageCounter;
            if (this.imageCounter >= 32) {
                ++this.dataFileCounter;
                if (this.dataFileCounter % 32 == 0) {
                    ++this.dataDirCounter;
                    if (this.dataDirCounter >= 32) {
                        throw new RuntimeException("Maximum number of tiles exceeded");
                    }
                }
                this.prepareDataFile();
            }
            long offset = this.currentDataFile.getFilePointer();
            this.currentDataFile.write(tileData);
            int len = tileData.length;
            GCHeaderEntry header = new GCHeaderEntry(GCLive.this.zoom, tilex, tiley, this.dataFileCounter, (int)offset, len);
            this.headerEntries.add(header);
        }

        public void finalizeMap() throws IOException {
            int dataPos = (int)this.currentDataFile.getFilePointer();
            Utilities.closeFile(this.currentDataFile);
            Collections.sort(this.headerEntries);
            RandomAccessFile indexFile = new RandomAccessFile(new File(this.mapDir, "index"), "rw");
            indexFile.seek(0L);
            int dataFileIndex = this.dataDirCounter * 32 + this.dataFileCounter;
            indexFile.writeInt(dataFileIndex);
            indexFile.writeInt(this.headerEntries.size());
            indexFile.writeInt(this.headerEntries.size());
            indexFile.writeInt(dataPos);
            for (GCHeaderEntry entry : this.headerEntries) {
                entry.writeHeader(indexFile);
                System.out.println(entry);
            }
            this.headerEntries = null;
            Utilities.closeFile(indexFile);
        }
    }
}

