/*
 * Decompiled with CFR 0.152.
 */
package mobac.program.atlascreators;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Date;
import mobac.exceptions.AtlasTestException;
import mobac.exceptions.MapCreationException;
import mobac.gui.AtlasProgress;
import mobac.program.AtlasThread;
import mobac.program.PauseResumeHandler;
import mobac.program.atlascreators.tileprovider.TileProvider;
import mobac.program.interfaces.AtlasInterface;
import mobac.program.interfaces.LayerInterface;
import mobac.program.interfaces.MapInterface;
import mobac.program.interfaces.MapSource;
import mobac.program.model.AtlasOutputFormat;
import mobac.program.model.Settings;
import mobac.program.model.TileImageParameters;
import mobac.utilities.Charsets;
import mobac.utilities.Utilities;
import org.apache.log4j.Logger;

public abstract class AtlasCreator {
    public static final Charset TEXT_FILE_CHARSET = Charsets.ISO_8859_1;
    protected final Logger log = Logger.getLogger(this.getClass());
    protected AtlasInterface atlas;
    protected File atlasDir;
    protected AtlasProgress atlasProgress = null;
    protected PauseResumeHandler pauseResumeHandler = null;
    protected MapInterface map;
    protected int xMin;
    protected int xMax;
    protected int yMin;
    protected int yMax;
    protected int zoom;
    protected MapSource mapSource;
    protected int tileSize;
    protected TileImageParameters parameters;
    protected AtlasOutputFormat atlasOutputFormat;
    protected TileProvider mapDlTileProvider;
    private boolean aborted = false;

    protected AtlasCreator() {
    }

    public void startAtlasCreation(AtlasInterface atlas, File customAtlasDir) throws AtlasTestException, IOException, InterruptedException {
        this.atlas = atlas;
        this.testAtlas();
        if (customAtlasDir == null) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd_HHmmss");
            String atlasDirName = atlas.getName() + "_" + sdf.format(new Date());
            File atlasOutputDir = Settings.getInstance().getAtlasOutputDirectory();
            this.atlasDir = new File(atlasOutputDir, atlasDirName);
        } else {
            this.atlasDir = customAtlasDir;
        }
        Utilities.mkDirs(this.atlasDir);
    }

    protected void testAtlas() throws AtlasTestException {
    }

    public void initLayerCreation(LayerInterface layer) throws IOException {
    }

    public void finishLayerCreation() throws IOException {
    }

    public void finishAtlasCreation() throws IOException, InterruptedException {
    }

    public void abortAtlasCreation() throws IOException {
        this.aborted = true;
    }

    public boolean isAborted() {
        return this.aborted;
    }

    public abstract boolean testMapSource(MapSource var1);

    public void initializeMap(MapInterface map, TileProvider mapTileProvider) {
        LayerInterface layer = map.getLayer();
        if (mapTileProvider == null) {
            throw new NullPointerException();
        }
        this.mapDlTileProvider = mapTileProvider;
        this.map = map;
        this.mapSource = map.getMapSource();
        this.tileSize = this.mapSource.getMapSpace().getTileSize();
        this.parameters = map.getParameters();
        this.xMin = map.getMinTileCoordinate().x / this.tileSize;
        this.xMax = map.getMaxTileCoordinate().x / this.tileSize;
        this.yMin = map.getMinTileCoordinate().y / this.tileSize;
        this.yMax = map.getMaxTileCoordinate().y / this.tileSize;
        this.zoom = map.getZoom();
        this.atlasOutputFormat = layer.getAtlas().getOutputFormat();
        Thread t = Thread.currentThread();
        if (!(t instanceof AtlasThread)) {
            throw new RuntimeException("Calling thread must be AtlasThread!");
        }
        AtlasThread at = (AtlasThread)t;
        this.atlasProgress = at.getAtlasProgress();
        this.pauseResumeHandler = at.getPauseResumeHandler();
    }

    public abstract void createMap() throws MapCreationException, InterruptedException;

    public void checkUserAbort() throws InterruptedException {
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedException();
        }
        this.pauseResumeHandler.pauseWait();
    }

    public AtlasProgress getAtlasProgress() {
        return this.atlasProgress;
    }

    public int getXMin() {
        return this.xMin;
    }

    public int getXMax() {
        return this.xMax;
    }

    public int getYMin() {
        return this.yMin;
    }

    public int getYMax() {
        return this.yMax;
    }

    public MapInterface getMap() {
        return this.map;
    }

    public TileImageParameters getParameters() {
        return this.parameters;
    }

    public TileProvider getMapDlTileProvider() {
        return this.mapDlTileProvider;
    }

    protected void performTest_MaxMapZoom(int maxZoom) throws AtlasTestException {
        for (LayerInterface layer : this.atlas) {
            for (MapInterface map : layer) {
                if (map.getZoom() <= maxZoom) continue;
                throw new AtlasTestException("Maximum zoom is " + maxZoom + " for this atlas format", map);
            }
        }
    }
}

