/*
 * Decompiled with CFR 0.152.
 */
package mobac.program.atlascreators;

import java.awt.Point;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collections;
import mobac.program.annotations.AtlasCreatorName;
import mobac.program.atlascreators.OSMTracker;
import mobac.program.atlascreators.tileprovider.TileProvider;
import mobac.program.interfaces.LayerInterface;
import mobac.program.interfaces.MapInterface;
import mobac.utilities.Utilities;
import mobac.utilities.stream.ZipStoreOutputStream;

@AtlasCreatorName(value="AFTrack (OSZ)")
public class AFTrack
extends OSMTracker {
    private ArrayList<Integer> zoomLevel = new ArrayList();
    private int maxZoom;
    private Point min;
    private Point max;

    public void initLayerCreation(LayerInterface layer) throws IOException {
        super.initLayerCreation(layer);
        File oszFile = new File(this.atlasDir, layer.getName() + ".osz");
        this.mapTileWriter = new OszTileWriter(oszFile);
        this.zoomLevel.clear();
        this.min = new Point();
        this.max = new Point();
        this.maxZoom = -1;
    }

    public void finishLayerCreation() throws IOException {
        this.mapTileWriter.finalizeMap();
        this.mapTileWriter = null;
        super.finishLayerCreation();
    }

    public void initializeMap(MapInterface map, TileProvider mapTileProvider) {
        super.initializeMap(map, mapTileProvider);
        this.zoomLevel.add(new Integer(map.getZoom()));
        if (map.getZoom() > this.maxZoom) {
            this.maxZoom = map.getZoom();
            this.min.x = map.getMinTileCoordinate().x / 256;
            this.min.y = map.getMinTileCoordinate().y / 256;
            this.max.x = map.getMaxTileCoordinate().x / 256;
            this.max.y = map.getMaxTileCoordinate().y / 256;
        }
    }

    private class OszTileWriter
    extends OSMTracker.OSMTileWriter {
        ZipStoreOutputStream zipStream;
        FileOutputStream out;

        public OszTileWriter(File oszFile) throws FileNotFoundException {
            super(AFTrack.this);
            this.out = new FileOutputStream(oszFile);
            this.zipStream = new ZipStoreOutputStream(this.out);
        }

        public void writeTile(int tilex, int tiley, String tileType, byte[] tileData) throws IOException {
            String entryName = String.format(AFTrack.this.tileFileNamePattern, AFTrack.this.zoom, tilex, tiley, tileType);
            this.zipStream.writeStoredEntry(entryName, tileData);
        }

        public void finalizeMap() throws IOException {
            ByteArrayOutputStream bout = new ByteArrayOutputStream(100);
            OutputStreamWriter writer = new OutputStreamWriter(bout);
            Collections.sort(AFTrack.this.zoomLevel);
            for (Integer zoom : AFTrack.this.zoomLevel) {
                writer.append(String.format("zoom=%d\r\n", (int)zoom));
            }
            writer.append(String.format("minx=%d\r\n", ((AFTrack)AFTrack.this).min.x));
            writer.append(String.format("maxx=%d\r\n", ((AFTrack)AFTrack.this).max.x));
            writer.append(String.format("miny=%d\r\n", ((AFTrack)AFTrack.this).min.y));
            writer.append(String.format("maxy=%d\r\n", ((AFTrack)AFTrack.this).max.y));
            writer.close();
            this.zipStream.writeStoredEntry("Manifest.txt", bout.toByteArray());
            Utilities.closeStream(this.zipStream);
        }
    }
}

