/*
 * Decompiled with CFR 0.152.
 */
package mobac.mapsources.mapspace;

import mobac.mapsources.mapspace.MercatorPower2MapSpace;
import mobac.program.interfaces.MapSpace;

public class MercatorPower2MapSpaceEllipsoidal
extends MercatorPower2MapSpace {
    protected final double excentricitySquared = 0.00669438;
    protected final double excentricity = Math.sqrt(0.00669438);
    public static final MapSpace INSTANCE_256 = new MercatorPower2MapSpaceEllipsoidal(256);

    protected MercatorPower2MapSpaceEllipsoidal(int tileSize) {
        super(tileSize);
    }

    public MapSpace.ProjectionCategory getProjectionCategory() {
        return MapSpace.ProjectionCategory.ELLIPSOID;
    }

    public int cLatToY(double lat, int zoom) {
        lat = Math.max(-85.05112877980659, Math.min(85.05112877980659, lat));
        lat = Math.toRadians(lat);
        lat = -Math.log(this.tsfn(lat, Math.sin(lat)));
        int mp = this.getMaxPixels(zoom);
        int y = -1 * (int)((double)mp * lat / (Math.PI * 2));
        y = y - this.falseNorthing(zoom) - (y > 0 ? -1 : 1);
        y = Math.min(y, mp - 1);
        return y;
    }

    public double cYToLat(int y, int zoom) {
        int y2 = y + this.falseNorthing(zoom);
        double latitude = Math.exp((double)(-y2) / this.radius(zoom));
        try {
            latitude = this.cphi2(latitude);
        }
        catch (Exception e) {
            return super.cYToLat(y, zoom);
        }
        return -1.0 * Math.toDegrees(latitude);
    }

    private double cphi2(double ts) throws Exception {
        double eccnth = 0.5 * this.excentricity;
        double phi = 1.5707963267948966 - 2.0 * Math.atan(ts);
        for (int i = 0; i < 15; ++i) {
            double con = this.excentricity * Math.sin(phi);
            double dphi = 1.5707963267948966 - 2.0 * Math.atan(ts * Math.pow((1.0 - con) / (1.0 + con), eccnth)) - phi;
            phi += dphi;
            if (!(Math.abs(dphi) <= 1.0E-10)) continue;
            return phi;
        }
        throw new Exception();
    }

    private double tsfn(double phi, double sinphi) {
        return Math.tan(0.5 * (1.5707963267948966 - phi)) / Math.pow((1.0 - (sinphi *= this.excentricity)) / (1.0 + sinphi), 0.5 * this.excentricity);
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        long temp = Double.doubleToLongBits(this.excentricity);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(0.00669438);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MercatorPower2MapSpaceEllipsoidal other = (MercatorPower2MapSpaceEllipsoidal)obj;
        if (Double.doubleToLongBits(this.excentricity) != Double.doubleToLongBits(other.excentricity)) {
            return false;
        }
        return Double.doubleToLongBits(0.00669438) == Double.doubleToLongBits(other.excentricitySquared);
    }
}

