/*
 * Decompiled with CFR 0.152.
 */
package mobac.mapsources.loader;

import java.io.File;
import javax.swing.JOptionPane;
import mobac.mapsources.MapSourcesManager;
import mobac.mapsources.custom.BeanShellHttpMapSource;
import mobac.program.model.MapSourceLoaderInfo;
import mobac.utilities.file.FileExtFilter;
import org.apache.log4j.Logger;

public class BeanShellMapSourceLoader {
    private final Logger log = Logger.getLogger(BeanShellMapSourceLoader.class);
    private final MapSourcesManager mapSourcesManager;
    private final File mapSourcesDir;

    public BeanShellMapSourceLoader(MapSourcesManager mapSourceManager, File mapSourcesDir) {
        this.mapSourcesManager = mapSourceManager;
        this.mapSourcesDir = mapSourcesDir;
    }

    public void loadBeanShellMapSources() {
        File[] customMapSourceFiles;
        for (File f : customMapSourceFiles = this.mapSourcesDir.listFiles(new FileExtFilter(".bsh"))) {
            try {
                BeanShellHttpMapSource mapSource = BeanShellHttpMapSource.load(f);
                this.log.trace("BeanShell map source loaded: " + mapSource + " from file \"" + f.getName() + "\"");
                mapSource.setLoaderInfo(new MapSourceLoaderInfo(MapSourceLoaderInfo.LoaderType.BSH, f));
                this.mapSourcesManager.addMapSource(mapSource);
            }
            catch (Exception e) {
                String errorMsg = "Failed to load custom BeanShell map source \"" + f.getName() + "\": " + e.getMessage();
                this.log.error(errorMsg, e);
                JOptionPane.showMessageDialog(null, errorMsg, "Failed to load custom BeanShell map source", 0);
            }
        }
    }
}

