/*
 * Decompiled with CFR 0.152.
 */
package mobac.mapsources.custom;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlList;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import mobac.exceptions.UnrecoverableDownloadException;
import mobac.mapsources.MapSourceTools;
import mobac.mapsources.mapspace.MercatorPower2MapSpace;
import mobac.program.download.TileDownLoader;
import mobac.program.interfaces.HttpMapSource;
import mobac.program.interfaces.MapSource;
import mobac.program.interfaces.MapSourceListener;
import mobac.program.interfaces.MapSpace;
import mobac.program.jaxb.ColorAdapter;
import mobac.program.model.MapSourceLoaderInfo;
import mobac.program.model.TileImageType;
import mobac.program.tilestore.TileStore;
import mobac.program.tilestore.TileStoreEntry;

@XmlRootElement
public class CustomMapSource
implements HttpMapSource {
    @XmlElement(nillable=false, defaultValue="Custom")
    private String name = "Custom";
    @XmlElement(defaultValue="0")
    private int minZoom = 0;
    @XmlElement(required=true)
    private int maxZoom = 0;
    @XmlElement(defaultValue="PNG")
    protected TileImageType tileType = TileImageType.PNG;
    @XmlElement(defaultValue="NONE")
    private HttpMapSource.TileUpdate tileUpdate;
    @XmlElement(required=true, nillable=false)
    protected String url = "http://127.0.0.1/{$x}_{$y}_{$z}";
    @XmlElement(defaultValue="false")
    private boolean invertYCoordinate = false;
    @XmlElement(defaultValue="#000000")
    @XmlJavaTypeAdapter(value=ColorAdapter.class)
    private Color backgroundColor = Color.BLACK;
    @XmlElement(required=false, defaultValue="false")
    private boolean ignoreErrors = false;
    @XmlElement(required=false, defaultValue="")
    @XmlList
    private String[] serverParts = null;
    private int currentServerPart = 0;
    private MapSourceLoaderInfo loaderInfo = null;

    protected CustomMapSource() {
    }

    public CustomMapSource(String name, String url) {
        this.name = name;
        this.url = url;
    }

    public HttpMapSource.TileUpdate getTileUpdate() {
        return this.tileUpdate;
    }

    public int getMaxZoom() {
        return this.maxZoom;
    }

    public int getMinZoom() {
        return this.minZoom;
    }

    public String getName() {
        return this.name;
    }

    public String getStoreName() {
        return this.name;
    }

    public TileImageType getTileImageType() {
        return this.tileType;
    }

    public HttpURLConnection getTileUrlConnection(int zoom, int tilex, int tiley) throws IOException {
        String url = this.getTileUrl(zoom, tilex, tiley);
        if (url == null) {
            return null;
        }
        return (HttpURLConnection)new URL(url).openConnection();
    }

    public String getTileUrl(int zoom, int tilex, int tiley) {
        if (this.serverParts == null || this.serverParts.length == 0) {
            return MapSourceTools.formatMapUrl(this.url, zoom, tilex, tiley);
        }
        this.currentServerPart = (this.currentServerPart + 1) % this.serverParts.length;
        String serverPart = this.serverParts[this.currentServerPart];
        return MapSourceTools.formatMapUrl(this.url, serverPart, zoom, tilex, tiley);
    }

    public byte[] getTileData(int zoom, int x, int y, MapSource.LoadMethod loadMethod) throws IOException, UnrecoverableDownloadException, InterruptedException {
        if (this.invertYCoordinate) {
            y = (1 << zoom) - y - 1;
        }
        if (loadMethod == MapSource.LoadMethod.CACHE) {
            TileStoreEntry entry = TileStore.getInstance().getTile(x, y, zoom, this);
            if (entry == null) {
                return null;
            }
            byte[] data = entry.getData();
            if (Thread.currentThread() instanceof MapSourceListener) {
                ((MapSourceListener)((Object)Thread.currentThread())).tileDownloaded(data.length);
            }
            return data;
        }
        if (this.ignoreErrors) {
            try {
                return TileDownLoader.getImage(x, y, zoom, this);
            }
            catch (Exception e) {
                return null;
            }
        }
        return TileDownLoader.getImage(x, y, zoom, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage getTileImage(int zoom, int x, int y, MapSource.LoadMethod loadMethod) throws IOException, UnrecoverableDownloadException, InterruptedException {
        byte[] data = this.getTileData(zoom, x, y, loadMethod);
        if (data == null) {
            if (!this.ignoreErrors) {
                return null;
            }
            int tileSize = this.getMapSpace().getTileSize();
            BufferedImage image = new BufferedImage(tileSize, tileSize, 6);
            Graphics g = image.getGraphics();
            try {
                g.setColor(this.backgroundColor);
                g.fillRect(0, 0, tileSize, tileSize);
            }
            finally {
                g.dispose();
            }
            return image;
        }
        return ImageIO.read(new ByteArrayInputStream(data));
    }

    public String toString() {
        return this.name;
    }

    public MapSpace getMapSpace() {
        return MercatorPower2MapSpace.INSTANCE_256;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    @XmlTransient
    public MapSourceLoaderInfo getLoaderInfo() {
        return this.loaderInfo;
    }

    public void setLoaderInfo(MapSourceLoaderInfo loaderInfo) {
        if (this.loaderInfo != null) {
            throw new RuntimeException("LoaderInfo already set");
        }
        this.loaderInfo = loaderInfo;
    }
}

