/*
 * Decompiled with CFR 0.152.
 */
package mobac.mapsources.custom;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.imageio.ImageIO;
import javax.swing.JOptionPane;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import mobac.exceptions.TileException;
import mobac.mapsources.mapspace.MapSpaceFactory;
import mobac.program.interfaces.FileBasedMapSource;
import mobac.program.interfaces.MapSource;
import mobac.program.interfaces.MapSpace;
import mobac.program.jaxb.ColorAdapter;
import mobac.program.model.MapSourceLoaderInfo;
import mobac.program.model.TileImageType;
import mobac.utilities.I18nUtils;
import mobac.utilities.Utilities;
import mobac.utilities.jdbc.SQLiteLoader;
import org.apache.log4j.Logger;

@XmlRootElement(name="localTileSQLite")
public class CustomLocalTileSQliteMapSource
implements FileBasedMapSource {
    private static Logger log = Logger.getLogger(CustomLocalTileSQliteMapSource.class);
    private MapSourceLoaderInfo loaderInfo = null;
    private boolean initialized = false;
    @XmlElement(required=false)
    private TileImageType tileImageType = null;
    @XmlElement(nillable=false, defaultValue="CustomLocalSQLite")
    private String name = "CustomLocalSQLite";
    private int minZoom = 0;
    private int maxZoom = 22;
    @XmlElement(required=true)
    private File sourceFile = null;
    @XmlElement(required=true)
    private SQLiteAtlasType atlasType = null;
    @XmlElement(defaultValue="#000000")
    @XmlJavaTypeAdapter(value=ColorAdapter.class)
    private Color backgroundColor = Color.BLACK;
    private String sqlMaxZoomStatement;
    private String sqlMinZoomStatement;
    private String sqlTileStatement;
    private String sqlTileImageTypeStatement;
    private Connection conn = null;
    private final MapSpace mapSpace = MapSpaceFactory.getInstance(256, true);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateZoomLevelInfo() {
        Statement statement = null;
        try {
            ResultSet rs;
            statement = this.conn.createStatement();
            if (statement.execute(this.sqlMaxZoomStatement)) {
                rs = statement.getResultSet();
                if (rs.next()) {
                    this.maxZoom = rs.getInt(1);
                }
                rs.close();
            }
            if (statement.execute(this.sqlMinZoomStatement)) {
                rs = statement.getResultSet();
                if (rs.next()) {
                    this.minZoom = rs.getInt(1);
                }
                rs.close();
            }
            statement.close();
        }
        catch (SQLException e) {
            log.error("", e);
        }
        finally {
            Utilities.closeStatement(statement);
        }
    }

    public synchronized void initialize() {
        if (this.initialized) {
            return;
        }
        this.reinitialize();
    }

    public void reinitialize() {
        if (this.atlasType == null) {
            JOptionPane.showMessageDialog(null, String.format(I18nUtils.localizedStringForKey("msg_custom_map_invalid_source_file", new Object[0]), this.name, this.sourceFile), I18nUtils.localizedStringForKey("msg_custom_map_invalid_source_file_title", new Object[0]), 0);
            this.initialized = true;
            return;
        }
        if (!this.sourceFile.isFile()) {
            JOptionPane.showMessageDialog(null, String.format(I18nUtils.localizedStringForKey("msg_custom_map_invalid_source_sqlitedb", new Object[0]), this.name, this.sourceFile), I18nUtils.localizedStringForKey("msg_custom_map_invalid_source_file_title", new Object[0]), 0);
            this.initialized = true;
            return;
        }
        if (!SQLiteLoader.loadSQLiteOrShowError()) {
            this.initialized = true;
            return;
        }
        log.debug("Loading SQLite database " + this.sourceFile);
        String url = "jdbc:sqlite:" + this.sourceFile;
        try {
            this.conn = DriverManager.getConnection(url);
        }
        catch (SQLException e) {
            JOptionPane.showMessageDialog(null, String.format(I18nUtils.localizedStringForKey("msg_custom_map_source_failed_load_sqlitedb", new Object[0]), this.name, this.sourceFile, e.getMessage()), I18nUtils.localizedStringForKey("msg_custom_map_source_failed_load_sqlitedb_title", new Object[0]), 0);
            this.initialized = true;
            return;
        }
        switch (this.atlasType) {
            case MBTiles: {
                this.sqlMaxZoomStatement = "SELECT DISTINCT zoom_level FROM tiles ORDER BY zoom_level DESC LIMIT 1;";
                this.sqlMinZoomStatement = "SELECT DISTINCT zoom_level FROM tiles ORDER BY zoom_level ASC LIMIT 1;";
                this.sqlTileStatement = "SELECT tile_data from tiles WHERE zoom_level=? AND tile_column=? AND tile_row=?;";
                this.sqlTileImageTypeStatement = "SELECT tile_data from tiles LIMIT 1;";
                break;
            }
            case RMaps: 
            case BigPlanetTracks: 
            case Galileo: 
            case OSMAND: {
                this.sqlMaxZoomStatement = "SELECT DISTINCT (17 - z) as zoom FROM tiles ORDER BY zoom DESC LIMIT 1;";
                this.sqlMinZoomStatement = "SELECT DISTINCT (17 - z) as zoom FROM tiles ORDER BY zoom ASC LIMIT 1;";
                this.sqlTileStatement = "SELECT image from tiles WHERE z=(17 - ?) AND x=? AND y=?;";
                this.sqlTileImageTypeStatement = "SELECT image from tiles LIMIT 1;";
                break;
            }
            case NaviComputer: {
                this.sqlMaxZoomStatement = "SELECT DISTINCT zoom FROM Tiles ORDER BY zoom DESC LIMIT 1;";
                this.sqlMinZoomStatement = "SELECT DISTINCT zoom FROM Tiles ORDER BY zoom ASC LIMIT 1;";
                this.sqlTileStatement = "SELECT Tile FROM Tiles LEFT JOIN Tilesdata ON Tiles.id=Tilesdata.id WHERE Zoom=? AND X=? AND Y=?;";
                this.sqlTileImageTypeStatement = "SELECT Tile from Tilesdata LIMIT 1;";
            }
        }
        this.updateZoomLevelInfo();
        this.detectTileImageType();
        this.initialized = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void detectTileImageType() {
        if (this.tileImageType != null) {
            return;
        }
        Statement statement = null;
        try {
            statement = this.conn.createStatement();
            if (statement.execute(this.sqlTileImageTypeStatement)) {
                ResultSet rs = statement.getResultSet();
                if (rs.next()) {
                    this.tileImageType = Utilities.getImageType(rs.getBytes(1));
                }
                rs.close();
            }
            statement.close();
        }
        catch (SQLException e) {
            log.error("", e);
        }
        finally {
            Utilities.closeStatement(statement);
        }
        if (this.tileImageType == null) {
            throw new RuntimeException("Unable to detect image type of " + this.sourceFile + ".\n" + "Please specify it manually using <tileImageType> entry in map source definition.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] getTileData(int zoom, int x, int y, MapSource.LoadMethod loadMethod) throws IOException, TileException, InterruptedException {
        if (!this.initialized) {
            this.initialize();
        }
        PreparedStatement statement = null;
        try {
            switch (this.atlasType) {
                case MBTiles: {
                    y = (1 << zoom) - y - 1;
                    break;
                }
            }
            statement = this.conn.prepareStatement(this.sqlTileStatement);
            statement.setInt(1, zoom);
            statement.setInt(2, x);
            statement.setInt(3, y);
            if (log.isTraceEnabled()) {
                log.trace(String.format("Loading tile z=%d x=%d y=%d", zoom, x, y));
            }
            if (statement.execute()) {
                ResultSet rs = statement.getResultSet();
                if (!rs.next()) {
                    if (log.isDebugEnabled()) {
                        log.debug(String.format("Tile in database not found: z=%d x=%d y=%d", zoom, x, y));
                    }
                    byte[] byArray = null;
                    Utilities.closeStatement(statement);
                    return byArray;
                }
                byte[] data = rs.getBytes(1);
                rs.close();
                byte[] byArray = data;
                Utilities.closeStatement(statement);
                return byArray;
            }
            Utilities.closeStatement(statement);
            return null;
        }
        catch (SQLException e) {
            log.error("", e);
            return null;
        }
        finally {
            Utilities.closeStatement(statement);
        }
    }

    public BufferedImage getTileImage(int zoom, int x, int y, MapSource.LoadMethod loadMethod) throws IOException, TileException, InterruptedException {
        byte[] data = this.getTileData(zoom, x, y, loadMethod);
        if (data == null) {
            return null;
        }
        return ImageIO.read(new ByteArrayInputStream(data));
    }

    public TileImageType getTileImageType() {
        return this.tileImageType;
    }

    public int getMaxZoom() {
        return this.maxZoom;
    }

    public int getMinZoom() {
        return this.minZoom;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public MapSpace getMapSpace() {
        return this.mapSpace;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    @XmlTransient
    public MapSourceLoaderInfo getLoaderInfo() {
        return this.loaderInfo;
    }

    public void setLoaderInfo(MapSourceLoaderInfo loaderInfo) {
        this.loaderInfo = loaderInfo;
    }

    protected void closeConnection() {
        try {
            if (this.conn != null) {
                this.conn.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.conn = null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum SQLiteAtlasType {
        RMaps,
        MBTiles,
        BigPlanetTracks,
        Galileo,
        NaviComputer,
        OSMAND;

    }
}

