/*
 * Decompiled with CFR 0.152.
 */
package mobac.mapsources.custom;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import javax.swing.JOptionPane;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import mobac.exceptions.TileException;
import mobac.mapsources.MapSourceTools;
import mobac.mapsources.custom.CustomMapSourceType;
import mobac.mapsources.mapspace.MapSpaceFactory;
import mobac.program.interfaces.FileBasedMapSource;
import mobac.program.interfaces.MapSource;
import mobac.program.interfaces.MapSpace;
import mobac.program.jaxb.ColorAdapter;
import mobac.program.model.MapSourceLoaderInfo;
import mobac.program.model.TileImageType;
import mobac.utilities.I18nUtils;
import mobac.utilities.Utilities;
import org.apache.log4j.Logger;

@XmlRootElement(name="localTileFiles")
public class CustomLocalTileFilesMapSource
implements FileBasedMapSource {
    private static final Logger log = Logger.getLogger(CustomLocalTileFilesMapSource.class);
    private MapSourceLoaderInfo loaderInfo = null;
    private MapSpace mapSpace = MapSpaceFactory.getInstance(256, true);
    private boolean initialized = false;
    private String fileSyntax = null;
    private TileImageType tileImageType = null;
    @XmlElement(nillable=false, defaultValue="CustomLocal")
    private String name = "Custom";
    private int minZoom = 0;
    private int maxZoom = 22;
    @XmlElement(required=true)
    private File sourceFolder = null;
    @XmlElement
    private CustomMapSourceType sourceType = CustomMapSourceType.DIR_ZOOM_X_Y;
    @XmlElement(defaultValue="false")
    private boolean invertYCoordinate = false;
    @XmlElement(defaultValue="#000000")
    @XmlJavaTypeAdapter(value=ColorAdapter.class)
    private Color backgroundColor = Color.BLACK;

    public synchronized void initialize() {
        if (this.initialized) {
            return;
        }
        this.reinitialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void reinitialize() {
        try {
            if (!this.sourceFolder.isDirectory()) {
                JOptionPane.showMessageDialog(null, String.format(I18nUtils.localizedStringForKey("msg_environment_invalid_source_folder", new Object[0]), this.name, this.sourceFolder.toString()), I18nUtils.localizedStringForKey("msg_environment_invalid_source_folder_title", new Object[0]), 0);
                this.initialized = true;
                return;
            }
            switch (this.sourceType) {
                case DIR_ZOOM_X_Y: 
                case DIR_ZOOM_Y_X: {
                    this.initializeDirType();
                    return;
                }
                case QUADKEY: {
                    this.initializeQuadKeyType();
                    return;
                }
                default: {
                    throw new RuntimeException("Invalid source type");
                }
            }
        }
        finally {
            this.initialized = true;
        }
    }

    private void initializeDirType() {
        NumericDirFileFilter ff = new NumericDirFileFilter();
        File[] zoomDirs = this.sourceFolder.listFiles(ff);
        if (zoomDirs.length < 1) {
            JOptionPane.showMessageDialog(null, String.format(I18nUtils.localizedStringForKey("msg_environment_invalid_source_folder_zoom", new Object[0]), this.name, this.sourceFolder), I18nUtils.localizedStringForKey("msg_environment_invalid_source_folder_title", new Object[0]), 0);
            this.initialized = true;
            return;
        }
        int min = 22;
        int max = 0;
        for (File file : zoomDirs) {
            int z = Integer.parseInt(file.getName());
            min = Math.min(min, z);
            max = Math.max(max, z);
        }
        this.minZoom = min;
        this.maxZoom = max;
        File[] arr$ = zoomDirs;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            int i$2 = 0;
            File zDir = arr$[i$];
            File[] arr$2 = zDir.listFiles(ff);
            int len$2 = arr$2.length;
            if (i$2 >= len$2) continue;
            File xDir = arr$2[i$2];
            try {
                xDir.listFiles(new FilenameFilter(){
                    String syntax = "%d/%d/%d";

                    public boolean accept(File dir, String name) {
                        String[] parts = name.split("\\.");
                        if (parts.length < 2 || parts.length > 3) {
                            return false;
                        }
                        this.syntax = this.syntax + "." + parts[1];
                        if (parts.length == 3) {
                            this.syntax = this.syntax + "." + parts[2];
                        }
                        CustomLocalTileFilesMapSource.this.tileImageType = TileImageType.getTileImageType(parts[1]);
                        CustomLocalTileFilesMapSource.this.fileSyntax = this.syntax;
                        log.debug("Detected file syntax: " + CustomLocalTileFilesMapSource.this.fileSyntax + " tileImageType=" + (Object)((Object)CustomLocalTileFilesMapSource.this.tileImageType));
                        throw new RuntimeException("break");
                    }
                });
            }
            catch (RuntimeException e) {
            }
            catch (Exception e) {
                log.error(e.getMessage());
            }
            return;
        }
    }

    private void initializeQuadKeyType() {
        String[] files = this.sourceFolder.list();
        Pattern p = Pattern.compile("([0123]+)\\.(png|gif|jpg)", 2);
        String fileExt = null;
        for (String file : files) {
            Matcher m = p.matcher(file);
            if (!m.matches()) continue;
            fileExt = m.group(2);
            break;
        }
        if (fileExt == null) {
            return;
        }
        this.fileSyntax = "%s." + fileExt;
        this.tileImageType = TileImageType.getTileImageType(fileExt);
        p = Pattern.compile("([0123]+)\\.(" + fileExt + ")", 2);
        int min = 22;
        int max = 1;
        for (String file : files) {
            Matcher m = p.matcher(file);
            if (!m.matches()) continue;
            if (this.fileSyntax == null) {
                this.fileSyntax = "%s." + m.group(2);
            }
            int z = m.group(1).length();
            min = Math.min(min, z);
            max = Math.max(max, z);
        }
        this.minZoom = min;
        this.maxZoom = max;
    }

    public byte[] getTileData(int zoom, int x, int y, MapSource.LoadMethod loadMethod) throws IOException, TileException, InterruptedException {
        String fileName;
        if (!this.initialized) {
            this.initialize();
        }
        if (this.fileSyntax == null) {
            return null;
        }
        if (log.isTraceEnabled()) {
            log.trace(String.format("Loading tile z=%d x=%d y=%d", zoom, x, y));
        }
        if (this.invertYCoordinate) {
            y = (1 << zoom) - y - 1;
        }
        switch (this.sourceType) {
            case DIR_ZOOM_X_Y: {
                fileName = String.format(this.fileSyntax, zoom, x, y);
                break;
            }
            case DIR_ZOOM_Y_X: {
                fileName = String.format(this.fileSyntax, zoom, y, x);
                break;
            }
            case QUADKEY: {
                fileName = String.format(this.fileSyntax, MapSourceTools.encodeQuadTree(zoom, x, y));
                break;
            }
            default: {
                throw new RuntimeException("Invalid source type");
            }
        }
        File file = new File(this.sourceFolder, fileName);
        try {
            return Utilities.getFileBytes(file);
        }
        catch (FileNotFoundException e) {
            log.debug("Map tile file not found: " + file.getAbsolutePath());
            return null;
        }
    }

    public BufferedImage getTileImage(int zoom, int x, int y, MapSource.LoadMethod loadMethod) throws IOException, TileException, InterruptedException {
        byte[] data = this.getTileData(zoom, x, y, loadMethod);
        if (data == null) {
            return null;
        }
        return ImageIO.read(new ByteArrayInputStream(data));
    }

    public TileImageType getTileImageType() {
        return this.tileImageType;
    }

    public int getMaxZoom() {
        return this.maxZoom;
    }

    public int getMinZoom() {
        return this.minZoom;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public MapSpace getMapSpace() {
        return this.mapSpace;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    @XmlTransient
    public MapSourceLoaderInfo getLoaderInfo() {
        return this.loaderInfo;
    }

    public void setLoaderInfo(MapSourceLoaderInfo loaderInfo) {
        this.loaderInfo = loaderInfo;
    }

    private static class NumericDirFileFilter
    implements FileFilter {
        private Pattern p = Pattern.compile("^\\d+$");

        private NumericDirFileFilter() {
        }

        public boolean accept(File f) {
            if (!f.isDirectory()) {
                return false;
            }
            return this.p.matcher(f.getName()).matches();
        }
    }
}

