/*
 * Decompiled with CFR 0.152.
 */
package mobac.gui.settings;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import mobac.gui.settings.SettingsGUI;
import mobac.mapsources.MapSourcesManager;
import mobac.program.interfaces.MapSource;
import mobac.program.tilestore.TileStore;
import mobac.program.tilestore.TileStoreInfo;
import mobac.program.tilestore.berkeleydb.DelayedInterruptThread;
import mobac.utilities.I18nUtils;
import mobac.utilities.Utilities;

public class SettingsGUITileStore
extends JPanel {
    public final JCheckBox tileStoreEnabled;
    private final JPanel tileStoreInfoPanel;
    private List<TileSourceInfoComponents> tileStoreInfoList = new LinkedList<TileSourceInfoComponents>();
    private JLabel totalTileCountLabel;
    private JLabel totalTileSizeLabel;
    protected DelayedInterruptThread tileStoreAsyncThread = null;

    public SettingsGUITileStore(SettingsGUI gui) {
        gui.addTab(I18nUtils.localizedStringForKey("set_tile_store_title", new Object[0]), this);
        this.tileStoreEnabled = new JCheckBox(I18nUtils.localizedStringForKey("set_tile_store_enable_checkbox", new Object[0]));
        JPanel tileStorePanel = new JPanel(new BorderLayout());
        tileStorePanel.setBorder(SettingsGUI.createSectionBorder(I18nUtils.localizedStringForKey("set_tile_store_settings", new Object[0])));
        tileStorePanel.add((Component)this.tileStoreEnabled, "Center");
        this.tileStoreInfoPanel = new JPanel(new GridBagLayout());
        this.prepareTileStoreInfoPanel();
        this.setLayout(new BorderLayout());
        this.add((Component)tileStorePanel, "North");
        JScrollPane scrollPane = new JScrollPane(this.tileStoreInfoPanel, 22, 31);
        this.tileStoreInfoPanel.setMinimumSize(new Dimension(200, 300));
        scrollPane.setPreferredSize(new Dimension(520, 100));
        scrollPane.setBorder(SettingsGUI.createSectionBorder(I18nUtils.localizedStringForKey("set_tile_store_information", new Object[0])));
        this.add((Component)scrollPane, "Center");
    }

    private void updateTileStoreInfoPanel(String updateStoreName) {
        try {
            TileStore tileStore = TileStore.getInstance();
            long totalTileCount = 0L;
            long totalTileSize = 0L;
            for (final TileSourceInfoComponents info : this.tileStoreInfoList) {
                long size;
                int count;
                String storeName = info.name;
                Utilities.checkForInterruption();
                if (updateStoreName == null || info.name.equals(updateStoreName)) {
                    TileStoreInfo tsi = tileStore.getStoreInfo(storeName);
                    count = tsi.getTileCount();
                    size = tsi.getStoreSize();
                    info.count = count;
                    info.size = size;
                    final String mapTileCountText = count < 0 ? "??" : Integer.toString(count);
                    final String mapTileSizeText = Utilities.formatBytes(size);
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            info.countLabel.setText("<html><b>" + mapTileCountText + "</b></html>");
                            info.sizeLabel.setText("<html><b>" + mapTileSizeText + "</b></html>");
                        }
                    });
                } else {
                    count = info.count;
                    size = info.size;
                }
                totalTileCount += (long)count;
                totalTileSize += size;
            }
            final String totalTileCountText = "<html><b>" + Long.toString(totalTileCount) + "</b></html>";
            final String totalTileSizeText = "<html><b>" + Utilities.formatBytes(totalTileSize) + "</b></html>";
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    SettingsGUITileStore.this.totalTileCountLabel.setText(totalTileCountText);
                    SettingsGUITileStore.this.totalTileSizeLabel.setText(totalTileSizeText);
                }
            });
        }
        catch (InterruptedException e) {
            SettingsGUI.log.debug("Tile store information retrieval was canceled");
        }
    }

    synchronized void updateTileStoreInfoPanelAsync(final String storeName) {
        if (this.tileStoreAsyncThread != null) {
            return;
        }
        this.tileStoreAsyncThread = new DelayedInterruptThread("TileStoreInfoRetriever"){

            public void run() {
                if (storeName == null) {
                    SettingsGUI.log.debug("Updating tilestore information in background");
                } else {
                    SettingsGUI.log.debug("Updating tilestore information for \"" + storeName + "\" in background");
                }
                SettingsGUITileStore.this.updateTileStoreInfoPanel(storeName);
                SettingsGUI.log.debug("Updating tilestore information finished");
                SettingsGUITileStore.this.tileStoreAsyncThread = null;
            }
        };
        this.tileStoreAsyncThread.start();
    }

    private void prepareTileStoreInfoPanel() {
        GridBagConstraints gbc_mapSource = new GridBagConstraints();
        gbc_mapSource.insets = new Insets(5, 10, 5, 10);
        gbc_mapSource.anchor = 17;
        GridBagConstraints gbc_mapTiles = new GridBagConstraints();
        gbc_mapTiles.insets = gbc_mapSource.insets;
        gbc_mapTiles.anchor = 13;
        GridBagConstraints gbc_eol = new GridBagConstraints();
        gbc_eol.gridwidth = 0;
        TileStore tileStore = TileStore.getInstance();
        MapSourcesManager mapSourcesManager = MapSourcesManager.getInstance();
        this.tileStoreInfoPanel.add((Component)new JLabel(I18nUtils.localizedStringForKey("set_tile_store_info_mapsrc", new Object[0])), gbc_mapSource);
        this.tileStoreInfoPanel.add((Component)new JLabel(I18nUtils.localizedStringForKey("set_tile_store_info_tiles", new Object[0])), gbc_mapTiles);
        this.tileStoreInfoPanel.add((Component)new JLabel(I18nUtils.localizedStringForKey("set_tile_store_info_size", new Object[0])), gbc_eol);
        ImageIcon trash = Utilities.loadResourceImageIcon("trash.png");
        for (String name : tileStore.getAllStoreNames()) {
            String mapTileCountText = "  ?  ";
            String mapTileSizeText = "    ?    ";
            MapSource mapSource = mapSourcesManager.getSourceByName(name);
            JLabel mapSourceNameLabel = mapSource != null ? new JLabel(name) : new JLabel(name + I18nUtils.localizedStringForKey("set_tile_store_info_disabled_subfix", new Object[0]));
            JLabel mapTileCountLabel = new JLabel(mapTileCountText);
            JLabel mapTileSizeLabel = new JLabel(mapTileSizeText);
            JButton deleteButton = new JButton(trash);
            TileSourceInfoComponents info = new TileSourceInfoComponents();
            info.name = name;
            info.countLabel = mapTileCountLabel;
            info.sizeLabel = mapTileSizeLabel;
            this.tileStoreInfoList.add(info);
            deleteButton.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
            deleteButton.setToolTipText(String.format(I18nUtils.localizedStringForKey("set_tile_store_info_delete_tips", new Object[0]), name));
            deleteButton.addActionListener(new ClearTileCacheAction(name));
            this.tileStoreInfoPanel.add((Component)mapSourceNameLabel, gbc_mapSource);
            this.tileStoreInfoPanel.add((Component)mapTileCountLabel, gbc_mapTiles);
            this.tileStoreInfoPanel.add((Component)mapTileSizeLabel, gbc_mapTiles);
            this.tileStoreInfoPanel.add((Component)deleteButton, gbc_eol);
        }
        JSeparator hr = new JSeparator(0);
        hr.setBorder(BorderFactory.createEtchedBorder(1));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.fill = 2;
        this.tileStoreInfoPanel.add((Component)hr, gbc);
        JLabel totalMapLabel = new JLabel(I18nUtils.localizedStringForKey("set_tile_store_info_total", new Object[0]));
        this.totalTileCountLabel = new JLabel("<html><b>??</b></html>");
        this.totalTileSizeLabel = new JLabel("<html><b>??</b></html>");
        this.tileStoreInfoPanel.add((Component)totalMapLabel, gbc_mapSource);
        this.tileStoreInfoPanel.add((Component)this.totalTileCountLabel, gbc_mapTiles);
        this.tileStoreInfoPanel.add((Component)this.totalTileSizeLabel, gbc_mapTiles);
    }

    public void stopThread() {
        DelayedInterruptThread t = this.tileStoreAsyncThread;
        if (t != null) {
            ((Thread)t).interrupt();
        }
    }

    private class ClearTileCacheAction
    implements ActionListener {
        String storeName;

        public ClearTileCacheAction(String storeName) {
            this.storeName = storeName;
        }

        public void actionPerformed(ActionEvent e) {
            JButton b = (JButton)e.getSource();
            b.setEnabled(false);
            b.setToolTipText(I18nUtils.localizedStringForKey("set_tile_store_info_deleteing_tips", new Object[0]));
            DelayedInterruptThread t = new DelayedInterruptThread("TileStore_" + this.storeName + "_DeleteThread"){

                public void run() {
                    try {
                        TileStore ts = TileStore.getInstance();
                        ts.clearStore(ClearTileCacheAction.this.storeName);
                        SettingsGUITileStore.this.updateTileStoreInfoPanelAsync(ClearTileCacheAction.this.storeName);
                        SettingsGUITileStore.this.repaint();
                    }
                    catch (Exception e) {
                        SettingsGUI.log.error("An error occured while cleaning tile cache: ", e);
                    }
                }
            };
            t.start();
        }
    }

    private static class TileSourceInfoComponents {
        JLabel sizeLabel;
        JLabel countLabel;
        String name;
        int count = -1;
        long size = 0L;

        private TileSourceInfoComponents() {
        }
    }
}

