/*
 * Decompiled with CFR 0.152.
 */
package mobac.gui.settings;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import mobac.exceptions.UpdateFailedException;
import mobac.gui.MainGUI;
import mobac.gui.actions.OpenInWebbrowser;
import mobac.gui.components.JDirectoryChooser;
import mobac.gui.components.JMapSizeCombo;
import mobac.gui.components.JTimeSlider;
import mobac.gui.settings.SettingsGUIPaper;
import mobac.gui.settings.SettingsGUITileStore;
import mobac.gui.settings.SettingsGUIWgsGrid;
import mobac.mapsources.MapSourcesManager;
import mobac.mapsources.loader.MapPackManager;
import mobac.program.interfaces.MapSource;
import mobac.program.model.MapSourcesListModel;
import mobac.program.model.ProxyType;
import mobac.program.model.Settings;
import mobac.program.model.UnitSystem;
import mobac.utilities.GBC;
import mobac.utilities.GUIExceptionHandler;
import mobac.utilities.I18nUtils;
import mobac.utilities.Utilities;
import org.apache.log4j.Logger;

public class SettingsGUI
extends JDialog {
    private static final long serialVersionUID = -5227934684609357198L;
    public static Logger log = Logger.getLogger(SettingsGUI.class);
    private static final Integer[] THREADCOUNT_LIST = new Integer[]{1, 2, 4, 6};
    private final Settings settings = Settings.getInstance();
    private JComboBox unitSystem;
    private JComboBox languageCombo;
    private JButton mapSourcesOnlineUpdate;
    private JTextField osmHikingTicket;
    private SettingsGUITileStore tileStoreTab;
    private JTimeSlider defaultExpirationTime;
    private JTimeSlider minExpirationTime;
    private JTimeSlider maxExpirationTime;
    private JMapSizeCombo mapSize;
    private JSpinner mapOverlapTiles;
    private JTextField atlasOutputDirectory;
    private JComboBox threadCount;
    private JComboBox bandwidth;
    private JComboBox proxyType;
    private JTextField proxyHost;
    private JTextField proxyPort;
    private JTextField proxyUserName;
    private JTextField proxyPassword;
    private JCheckBox ignoreDlErrors;
    private JButton okButton;
    private JButton cancelButton;
    private JTabbedPane tabbedPane;
    private JList enabledMapSources;
    private MapSourcesListModel enabledMapSourcesModel;
    private JList disabledMapSources;
    private MapSourcesListModel disabledMapSourcesModel;
    private final SettingsGUIPaper paperAtlas;
    private final SettingsGUIWgsGrid display;

    public static void showSettingsDialog(final JFrame owner) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                new SettingsGUI(owner);
            }
        });
    }

    private SettingsGUI(JFrame owner) {
        super(owner);
        this.setIconImages(MainGUI.MOBAC_ICONS);
        GUIExceptionHandler.registerForCurrentThread();
        this.setDefaultCloseOperation(2);
        this.setModal(true);
        this.setMinimumSize(new Dimension(300, 300));
        this.paperAtlas = new SettingsGUIPaper();
        this.display = new SettingsGUIWgsGrid();
        this.createJFrame();
        this.createTabbedPane();
        this.createJButtons();
        this.loadSettings();
        this.addListeners();
        this.pack();
        this.setMinimumSize(this.getSize());
        Dimension dScreen = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dScreen.width - this.getWidth()) / 2, (dScreen.height - this.getHeight()) / 2);
        this.setVisible(true);
    }

    private void createJFrame() {
        this.setLayout(new BorderLayout());
        this.setTitle(I18nUtils.localizedStringForKey("set_title", new Object[0]));
    }

    public void createTabbedPane() {
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.setBounds(0, 0, 492, 275);
        this.addDisplaySettingsPanel();
        try {
            this.addMapSourceSettingsPanel();
        }
        catch (URISyntaxException e) {
            log.error("", e);
        }
        this.addMapSourceManagerPanel();
        this.addTileUpdatePanel();
        this.tileStoreTab = new SettingsGUITileStore(this);
        this.addMapSizePanel();
        this.addDirectoriesPanel();
        this.addNetworkPanel();
        this.tabbedPane.addTab(this.paperAtlas.getName(), this.paperAtlas);
        this.add((Component)this.tabbedPane, "Center");
    }

    private JPanel createNewTab(String tabTitle) {
        JPanel tabPanel = new JPanel();
        this.addTab(tabTitle, tabPanel);
        return tabPanel;
    }

    protected void addTab(String tabTitle, JPanel tabPanel) {
        tabPanel.setName(tabTitle);
        tabPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.tabbedPane.add((Component)tabPanel, tabTitle);
    }

    private void addDisplaySettingsPanel() {
        JPanel tab = this.createNewTab(I18nUtils.localizedStringForKey("set_display_title", new Object[0]));
        tab.setLayout(new GridBagLayout());
        JPanel unitSystemPanel = new JPanel(new GridBagLayout());
        unitSystemPanel.setBorder(SettingsGUI.createSectionBorder(I18nUtils.localizedStringForKey("set_display_unit_system_title", new Object[0])));
        JPanel languagePanel = new JPanel(new GridBagLayout());
        languagePanel.setBorder(SettingsGUI.createSectionBorder(I18nUtils.localizedStringForKey("set_display_language", new Object[0])));
        this.languageCombo = new JComboBox<SupportLocale>(SupportLocale.values());
        this.languageCombo.setToolTipText(I18nUtils.localizedStringForKey("set_display_language_choose_tips", new Object[0]));
        this.languageCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String LocaleStr;
                Locale locale = ((SupportLocale)((Object)SettingsGUI.this.languageCombo.getSelectedItem())).locale;
                String currentLocaleStr = "" + ((SettingsGUI)SettingsGUI.this).settings.localeLanguage + ((SettingsGUI)SettingsGUI.this).settings.localeCountry;
                if (!currentLocaleStr.equals(LocaleStr = "" + locale.getLanguage() + locale.getCountry()) && SettingsGUI.this.isVisible()) {
                    ((SettingsGUI)SettingsGUI.this).settings.localeLanguage = locale.getLanguage();
                    ((SettingsGUI)SettingsGUI.this).settings.localeCountry = locale.getCountry();
                    int result = JOptionPane.showConfirmDialog(null, I18nUtils.localizedStringForKey("set_display_language_restart_desc", new Object[0]), I18nUtils.localizedStringForKey("set_display_language_msg_title", new Object[0]), 0, 3);
                    I18nUtils.updateLocalizedStringFormSettings();
                    if (result == 0) {
                        SettingsGUI.this.applySettings();
                        try {
                            String javaBin = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
                            File currentJar = new File(SettingsGUI.class.getProtectionDomain().getCodeSource().getLocation().toURI());
                            if (currentJar.getName().endsWith(".jar")) {
                                Runtime r = Runtime.getRuntime();
                                long maxMem = r.maxMemory();
                                ArrayList<String> command = new ArrayList<String>();
                                command.add(javaBin);
                                command.add("-jar");
                                command.add("-Xms64m");
                                if (Long.MAX_VALUE == maxMem) {
                                    command.add("-Xmx1024M");
                                } else {
                                    command.add("-Xmx" + maxMem / 0x100000L + "M");
                                }
                                command.add(currentJar.getPath());
                                log.debug("restarting MOBAC using the following command: \n\t" + Arrays.toString(command.toArray()));
                                ProcessBuilder builder = new ProcessBuilder(command);
                                builder.start();
                            }
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                        System.exit(0);
                    }
                }
            }
        });
        languagePanel.add((Component)new JLabel(I18nUtils.localizedStringForKey("set_display_language_choose", new Object[0])), GBC.std());
        languagePanel.add((Component)this.languageCombo, GBC.std());
        languagePanel.add(Box.createHorizontalGlue(), GBC.eol().fill(2));
        UnitSystem[] us = UnitSystem.values();
        this.unitSystem = new JComboBox<UnitSystem>(us);
        unitSystemPanel.add((Component)new JLabel(I18nUtils.localizedStringForKey("set_display_unit_system_scale_bar", new Object[0])), GBC.std());
        unitSystemPanel.add((Component)this.unitSystem, GBC.std());
        unitSystemPanel.add(Box.createHorizontalGlue(), GBC.eol().fill(2));
        tab.add((Component)unitSystemPanel, GBC.eol().fill(2));
        tab.add((Component)this.display, GBC.eol().fill(2));
        tab.add((Component)languagePanel, GBC.eol().fill(2));
        tab.add(Box.createVerticalGlue(), GBC.std().fill(3));
    }

    private void addMapSourceSettingsPanel() throws URISyntaxException {
        JPanel tab = this.createNewTab(I18nUtils.localizedStringForKey("set_mapsrc_config_title", new Object[0]));
        tab.setLayout(new GridBagLayout());
        JPanel updatePanel = new JPanel(new GridBagLayout());
        updatePanel.setBorder(SettingsGUI.createSectionBorder(I18nUtils.localizedStringForKey("set_mapsrc_config_online_update", new Object[0])));
        this.mapSourcesOnlineUpdate = new JButton(I18nUtils.localizedStringForKey("set_mapsrc_config_online_update_btn", new Object[0]));
        this.mapSourcesOnlineUpdate.addActionListener(new MapPacksOnlineUpdateAction());
        updatePanel.add((Component)this.mapSourcesOnlineUpdate, GBC.std());
        JPanel osmHikingPanel = new JPanel(new GridBagLayout());
        osmHikingPanel.setBorder(SettingsGUI.createSectionBorder(I18nUtils.localizedStringForKey("set_mapsrc_config_osmhiking", new Object[0])));
        this.osmHikingTicket = new JTextField(20);
        osmHikingPanel.add((Component)new JLabel(I18nUtils.localizedStringForKey("set_mapsrc_config_osmhiking_purchased", new Object[0])), GBC.std());
        osmHikingPanel.add((Component)this.osmHikingTicket, GBC.std().insets(2, 0, 10, 0));
        JLabel osmHikingTicketUrl = new JLabel(I18nUtils.localizedStringForKey("set_mapsrc_config_osmhiking_howto", new Object[0]));
        osmHikingTicketUrl.addMouseListener(new OpenInWebbrowser(I18nUtils.localizedStringForKey("set_mapsrc_config_osmhiking_howto_url", new Object[0])));
        osmHikingPanel.add((Component)osmHikingTicketUrl, GBC.eol());
        tab.add((Component)updatePanel, GBC.eol().fill(2));
        tab.add((Component)osmHikingPanel, GBC.eol().fill(2));
        tab.add(Box.createVerticalGlue(), GBC.eol().fill(3));
    }

    private void addMapSourceManagerPanel() {
        JPanel tab = this.createNewTab(I18nUtils.localizedStringForKey("set_mapsrc_mgr_title", new Object[0]));
        tab.setLayout(new GridBagLayout());
        JPanel leftPanel = new JPanel(new BorderLayout());
        leftPanel.setBorder(SettingsGUI.createSectionBorder(I18nUtils.localizedStringForKey("set_mapsrc_mgr_title_enabled", new Object[0])));
        JPanel centerPanel = new JPanel(new GridBagLayout());
        JPanel rightPanel = new JPanel(new BorderLayout());
        rightPanel.setBorder(SettingsGUI.createSectionBorder(I18nUtils.localizedStringForKey("set_mapsrc_mgr_title_disabled", new Object[0])));
        JButton up = new JButton(Utilities.loadResourceImageIcon("arrow_blue_up.png"));
        up.setToolTipText(I18nUtils.localizedStringForKey("set_mapsrc_mgr_move_up_tips", new Object[0]));
        JButton down = new JButton(Utilities.loadResourceImageIcon("arrow_blue_down.png"));
        down.setToolTipText(I18nUtils.localizedStringForKey("set_mapsrc_mgr_move_down_tips", new Object[0]));
        JButton toLeft = new JButton(Utilities.loadResourceImageIcon("arrow_blue_left.png"));
        toLeft.setToolTipText(I18nUtils.localizedStringForKey("set_mapsrc_mgr_move_left_tips", new Object[0]));
        JButton toRight = new JButton(Utilities.loadResourceImageIcon("arrow_blue_right.png"));
        toRight.setToolTipText(I18nUtils.localizedStringForKey("set_mapsrc_mgr_move_right_tips", new Object[0]));
        Insets buttonInsets = new Insets(4, 4, 4, 4);
        Dimension buttonDimension = new Dimension(40, 40);
        up.setPreferredSize(buttonDimension);
        down.setPreferredSize(buttonDimension);
        toLeft.setPreferredSize(buttonDimension);
        toRight.setPreferredSize(buttonDimension);
        up.setMargin(buttonInsets);
        down.setMargin(buttonInsets);
        toLeft.setMargin(buttonInsets);
        toRight.setMargin(buttonInsets);
        toLeft.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int[] idx = SettingsGUI.this.disabledMapSources.getSelectedIndices();
                for (int i = 0; i < idx.length; ++i) {
                    MapSource ms = SettingsGUI.this.disabledMapSourcesModel.removeElement(idx[i] - i);
                    SettingsGUI.this.enabledMapSourcesModel.addElement(ms);
                }
            }
        });
        toRight.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int[] idx = SettingsGUI.this.enabledMapSources.getSelectedIndices();
                for (int i = 0; i < idx.length; ++i) {
                    MapSource ms = SettingsGUI.this.enabledMapSourcesModel.removeElement(idx[i] - i);
                    SettingsGUI.this.disabledMapSourcesModel.addElement(ms);
                }
                SettingsGUI.this.disabledMapSourcesModel.sort();
            }
        });
        up.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int[] idx = SettingsGUI.this.enabledMapSources.getSelectedIndices();
                if (idx.length == 0) {
                    return;
                }
                for (int i = 0; i < idx.length; ++i) {
                    int index = idx[i];
                    if (index == 0) {
                        return;
                    }
                    if (!SettingsGUI.this.enabledMapSourcesModel.moveUp(index)) continue;
                    int n = i;
                    idx[n] = idx[n] - 1;
                }
                SettingsGUI.this.enabledMapSources.setSelectedIndices(idx);
                SettingsGUI.this.enabledMapSources.ensureIndexIsVisible(idx[0]);
            }
        });
        down.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int[] idx = SettingsGUI.this.enabledMapSources.getSelectedIndices();
                if (idx.length == 0) {
                    return;
                }
                for (int i = idx.length - 1; i >= 0; --i) {
                    int index = idx[i];
                    if (index == SettingsGUI.this.enabledMapSourcesModel.getSize() - 1) {
                        return;
                    }
                    if (!SettingsGUI.this.enabledMapSourcesModel.moveDown(index)) continue;
                    int n = i;
                    idx[n] = idx[n] + 1;
                }
                SettingsGUI.this.enabledMapSources.setSelectedIndices(idx);
                SettingsGUI.this.enabledMapSources.ensureIndexIsVisible(idx[idx.length - 1]);
            }
        });
        GBC buttonGbc = GBC.eol();
        centerPanel.add(Box.createVerticalStrut(25), GBC.eol());
        centerPanel.add((Component)toLeft, buttonGbc);
        centerPanel.add((Component)toRight, buttonGbc);
        centerPanel.add((Component)up, buttonGbc);
        centerPanel.add((Component)down, buttonGbc);
        centerPanel.add(Box.createVerticalGlue(), GBC.std().fill());
        MapSourcesManager msManager = MapSourcesManager.getInstance();
        this.enabledMapSourcesModel = new MapSourcesListModel(msManager.getEnabledOrderedMapSources());
        this.enabledMapSources = new JList(this.enabledMapSourcesModel);
        JScrollPane leftScrollPane = new JScrollPane(this.enabledMapSources, 20, 31);
        leftPanel.add((Component)leftScrollPane, "Center");
        this.disabledMapSourcesModel = new MapSourcesListModel(msManager.getDisabledMapSources());
        this.disabledMapSourcesModel.sort();
        this.disabledMapSources = new JList(this.disabledMapSourcesModel);
        JScrollPane rightScrollPane = new JScrollPane(this.disabledMapSources, 20, 31);
        rightPanel.add((Component)rightScrollPane, "Center");
        JPanel mapSourcesInnerPanel = new JPanel();
        Color c = UIManager.getColor("List.background");
        mapSourcesInnerPanel.setBackground(c);
        GBC lr = GBC.std().fill();
        lr.weightx = 1.0;
        tab.add((Component)leftPanel, lr);
        tab.add((Component)centerPanel, GBC.std().fill(3));
        tab.add((Component)rightPanel, lr);
    }

    private void addTileUpdatePanel() {
        JPanel backGround = this.createNewTab(I18nUtils.localizedStringForKey("set_tile_update_title", new Object[0]));
        backGround.setLayout(new GridBagLayout());
        ChangeListener sliderChangeListener = new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                JTimeSlider slider = (JTimeSlider)e.getSource();
                long x = slider.getTimeSecondsValue();
                JPanel panel = (JPanel)slider.getParent();
                TitledBorder tb = (TitledBorder)panel.getBorder();
                tb.setTitle(panel.getName() + ": " + Utilities.formatDurationSeconds(x));
                panel.repaint();
            }
        };
        GBC gbc_ef = GBC.eol().fill(2);
        JPanel defaultExpirationPanel = new JPanel(new GridBagLayout());
        defaultExpirationPanel.setName(I18nUtils.localizedStringForKey("set_tile_update_default_expiration", new Object[0]));
        defaultExpirationPanel.setBorder(SettingsGUI.createSectionBorder(""));
        this.defaultExpirationTime = new JTimeSlider();
        this.defaultExpirationTime.addChangeListener(sliderChangeListener);
        JLabel descr = new JLabel(I18nUtils.localizedStringForKey("set_tile_update_default_expiration_desc", new Object[0]), 0);
        defaultExpirationPanel.add((Component)descr, gbc_ef);
        defaultExpirationPanel.add((Component)this.defaultExpirationTime, gbc_ef);
        JPanel maxExpirationPanel = new JPanel(new BorderLayout());
        maxExpirationPanel.setName(I18nUtils.localizedStringForKey("set_tile_update_max_expiration", new Object[0]));
        maxExpirationPanel.setBorder(SettingsGUI.createSectionBorder(""));
        this.maxExpirationTime = new JTimeSlider();
        this.maxExpirationTime.addChangeListener(sliderChangeListener);
        maxExpirationPanel.add((Component)this.maxExpirationTime, "Center");
        JPanel minExpirationPanel = new JPanel(new BorderLayout());
        minExpirationPanel.setName(I18nUtils.localizedStringForKey("set_tile_update_min_expiration", new Object[0]));
        minExpirationPanel.setBorder(SettingsGUI.createSectionBorder(""));
        this.minExpirationTime = new JTimeSlider();
        this.minExpirationTime.addChangeListener(sliderChangeListener);
        minExpirationPanel.add((Component)this.minExpirationTime, "Center");
        descr = new JLabel(I18nUtils.localizedStringForKey("set_tile_update_desc", new Object[0]), 0);
        backGround.add((Component)descr, gbc_ef);
        backGround.add((Component)defaultExpirationPanel, gbc_ef);
        backGround.add((Component)minExpirationPanel, gbc_ef);
        backGround.add((Component)maxExpirationPanel, gbc_ef);
        backGround.add(Box.createVerticalGlue(), GBC.std().fill());
    }

    private void addMapSizePanel() {
        JPanel backGround = this.createNewTab(I18nUtils.localizedStringForKey("set_map_size_title", new Object[0]));
        backGround.setLayout(new GridBagLayout());
        this.mapSize = new JMapSizeCombo();
        this.mapSize.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                log.trace("Map size: " + SettingsGUI.this.mapSize.getValue());
            }
        });
        JLabel mapSizeLabel = new JLabel(I18nUtils.localizedStringForKey("set_map_size_max_size_of_rect", new Object[0]));
        JLabel mapSizeText = new JLabel(I18nUtils.localizedStringForKey("set_map_size_desc", new Object[0]));
        this.mapOverlapTiles = new JSpinner(new SpinnerNumberModel(0, 0, 5, 1));
        JLabel mapOverlapTilesLabel = new JLabel(I18nUtils.localizedStringForKey("set_map_size_overlap_tiles", new Object[0]));
        JPanel leftPanel = new JPanel(new GridBagLayout());
        leftPanel.setBorder(SettingsGUI.createSectionBorder(I18nUtils.localizedStringForKey("set_map_size_settings", new Object[0])));
        GBC gbc = GBC.eol().insets(0, 5, 0, 5);
        leftPanel.add((Component)mapSizeLabel, GBC.std());
        leftPanel.add((Component)this.mapSize, GBC.eol());
        leftPanel.add((Component)mapOverlapTilesLabel, GBC.std());
        leftPanel.add((Component)this.mapOverlapTiles, GBC.eol());
        leftPanel.add((Component)mapSizeText, gbc.fill(2));
        leftPanel.add(Box.createVerticalGlue(), GBC.std().fill(3));
        backGround.add((Component)leftPanel, GBC.std().fill(2).anchor(12));
        backGround.add(Box.createVerticalGlue(), GBC.std().fill(3));
    }

    private void addDirectoriesPanel() {
        JPanel backGround = this.createNewTab(I18nUtils.localizedStringForKey("set_directory_title", new Object[0]));
        backGround.setLayout(new GridBagLayout());
        JPanel atlasOutputDirPanel = new JPanel(new GridBagLayout());
        atlasOutputDirPanel.setBorder(SettingsGUI.createSectionBorder(I18nUtils.localizedStringForKey("set_directory_output", new Object[0])));
        this.atlasOutputDirectory = new JTextField();
        this.atlasOutputDirectory.setToolTipText(String.format(I18nUtils.localizedStringForKey("set_directory_output_tips", new Object[0]), this.settings.getAtlasOutputDirectory()));
        JButton selectAtlasOutputDirectory = new JButton(I18nUtils.localizedStringForKey("set_directory_output_select", new Object[0]));
        selectAtlasOutputDirectory.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JDirectoryChooser dc = new JDirectoryChooser();
                dc.setCurrentDirectory(SettingsGUI.this.settings.getAtlasOutputDirectory());
                if (dc.showDialog(SettingsGUI.this, I18nUtils.localizedStringForKey("set_directory_output_select_dlg_title", new Object[0])) != 0) {
                    return;
                }
                SettingsGUI.this.atlasOutputDirectory.setText(dc.getSelectedFile().getAbsolutePath());
            }
        });
        atlasOutputDirPanel.add((Component)this.atlasOutputDirectory, GBC.std().fillH());
        atlasOutputDirPanel.add((Component)selectAtlasOutputDirectory, GBC.std());
        backGround.add((Component)atlasOutputDirPanel, GBC.eol().fillH());
        backGround.add(Box.createVerticalGlue(), GBC.eol().fill(3));
    }

    private void addNetworkPanel() {
        JPanel backGround = this.createNewTab(I18nUtils.localizedStringForKey("set_net_title", new Object[0]));
        backGround.setLayout(new GridBagLayout());
        GBC gbc_eolh = GBC.eol().fill(2);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(SettingsGUI.createSectionBorder(I18nUtils.localizedStringForKey("set_net_connection", new Object[0])));
        this.threadCount = new JComboBox<Integer>(THREADCOUNT_LIST);
        this.threadCount.setMaximumRowCount(THREADCOUNT_LIST.length);
        panel.add((Component)this.threadCount, GBC.std().insets(5, 5, 5, 5).anchor(13));
        panel.add((Component)new JLabel(I18nUtils.localizedStringForKey("set_net_connection_desc", new Object[0])), GBC.eol().fill(2));
        this.bandwidth = new JComboBox<Bandwidth>(Bandwidth.values());
        this.bandwidth.setMaximumRowCount(this.bandwidth.getItemCount());
        panel.add((Component)this.bandwidth, GBC.std().insets(5, 5, 5, 5));
        panel.add((Component)new JLabel(I18nUtils.localizedStringForKey("set_net_bandwidth_desc", new Object[0])), GBC.eol().fill(2));
        backGround.add((Component)panel, gbc_eolh);
        panel = new JPanel(new GridBagLayout());
        panel.setBorder(SettingsGUI.createSectionBorder(I18nUtils.localizedStringForKey("set_net_proxy", new Object[0])));
        JLabel proxyTypeLabel = new JLabel(I18nUtils.localizedStringForKey("set_net_proxy_settings", new Object[0]));
        this.proxyType = new JComboBox<ProxyType>(ProxyType.values());
        this.proxyType.setSelectedItem((Object)this.settings.getProxyType());
        final JLabel proxyHostLabel = new JLabel(I18nUtils.localizedStringForKey("set_net_proxy_host", new Object[0]));
        this.proxyHost = new JTextField(this.settings.getCustomProxyHost());
        final JLabel proxyPortLabel = new JLabel(I18nUtils.localizedStringForKey("set_net_proxy_port", new Object[0]));
        this.proxyPort = new JTextField(this.settings.getCustomProxyPort());
        final JLabel proxyUserNameLabel = new JLabel(I18nUtils.localizedStringForKey("set_net_proxy_username", new Object[0]));
        this.proxyUserName = new JTextField(this.settings.getCustomProxyUserName());
        final JLabel proxyPasswordLabel = new JLabel(I18nUtils.localizedStringForKey("set_net_proxy_password", new Object[0]));
        this.proxyPassword = new JTextField(this.settings.getCustomProxyPassword());
        ActionListener al = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                boolean b = ProxyType.CUSTOM.equals(SettingsGUI.this.proxyType.getSelectedItem());
                boolean c = ProxyType.CUSTOM_W_AUTH.equals(SettingsGUI.this.proxyType.getSelectedItem());
                SettingsGUI.this.proxyHost.setEnabled(b || c);
                SettingsGUI.this.proxyPort.setEnabled(b || c);
                proxyHostLabel.setEnabled(b || c);
                proxyPortLabel.setEnabled(b || c);
                SettingsGUI.this.proxyUserName.setEnabled(c);
                SettingsGUI.this.proxyPassword.setEnabled(c);
                proxyUserNameLabel.setEnabled(c);
                proxyPasswordLabel.setEnabled(c);
            }
        };
        al.actionPerformed(null);
        this.proxyType.addActionListener(al);
        panel.add((Component)proxyTypeLabel, GBC.std());
        panel.add((Component)this.proxyType, gbc_eolh.insets(5, 2, 5, 2));
        panel.add((Component)proxyHostLabel, GBC.std());
        panel.add((Component)this.proxyHost, gbc_eolh);
        panel.add((Component)proxyPortLabel, GBC.std());
        panel.add((Component)this.proxyPort, gbc_eolh);
        panel.add((Component)proxyUserNameLabel, GBC.std());
        panel.add((Component)this.proxyUserName, gbc_eolh);
        panel.add((Component)proxyPasswordLabel, GBC.std());
        panel.add((Component)this.proxyPassword, gbc_eolh);
        backGround.add((Component)panel, GBC.eol().fillH());
        this.ignoreDlErrors = new JCheckBox(I18nUtils.localizedStringForKey("set_net_default_ignore_error", new Object[0]), this.settings.ignoreDlErrors);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(SettingsGUI.createSectionBorder(I18nUtils.localizedStringForKey("set_net_default", new Object[0])));
        jPanel.add((Component)this.ignoreDlErrors, GBC.std());
        jPanel.add(Box.createHorizontalGlue(), GBC.eol().fillH());
        backGround.add((Component)jPanel, GBC.eol().fillH());
        backGround.add(Box.createVerticalGlue(), GBC.eol().fill(3));
    }

    public void createJButtons() {
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        this.okButton = new JButton(I18nUtils.localizedStringForKey("OK", new Object[0]));
        this.cancelButton = new JButton(I18nUtils.localizedStringForKey("Cancel", new Object[0]));
        GBC gbc = GBC.std().insets(5, 5, 5, 5);
        buttonPanel.add((Component)this.okButton, gbc);
        buttonPanel.add((Component)this.cancelButton, gbc);
        this.add((Component)buttonPanel, "South");
    }

    private void loadSettings() {
        int index;
        Settings s = this.settings;
        this.unitSystem.setSelectedItem((Object)s.unitSystem);
        this.tileStoreTab.tileStoreEnabled.setSelected(s.tileStoreEnabled);
        this.languageCombo.setSelectedItem((Object)SupportLocale.localeOf(s.localeLanguage, s.localeCountry));
        this.mapSize.setValue(s.maxMapSize);
        this.mapOverlapTiles.setValue(s.mapOverlapTiles);
        this.atlasOutputDirectory.setText(s.getAtlasOutputDirectoryString());
        long limit = s.getBandwidthLimit();
        for (Bandwidth b : Bandwidth.values()) {
            if (limit > b.limit) continue;
            this.bandwidth.setSelectedItem((Object)b);
            break;
        }
        if ((index = Arrays.binarySearch((Object[])THREADCOUNT_LIST, (Object)s.downloadThreadCount)) < 0) {
            index = s.downloadThreadCount > THREADCOUNT_LIST[THREADCOUNT_LIST.length - 1] ? THREADCOUNT_LIST.length - 1 : 0;
        }
        this.threadCount.setSelectedIndex(index);
        this.defaultExpirationTime.setTimeMilliValue(s.tileDefaultExpirationTime);
        this.maxExpirationTime.setTimeMilliValue(s.tileMaxExpirationTime);
        this.minExpirationTime.setTimeMilliValue(s.tileMinExpirationTime);
        this.osmHikingTicket.setText(s.osmHikingTicket);
        this.ignoreDlErrors.setSelected(s.ignoreDlErrors);
        this.paperAtlas.loadSettings(s);
        this.display.loadSettings(s);
    }

    private void applySettings() {
        int threads;
        Settings s = this.settings;
        s.unitSystem = (UnitSystem)((Object)this.unitSystem.getSelectedItem());
        s.tileStoreEnabled = this.tileStoreTab.tileStoreEnabled.isSelected();
        s.tileDefaultExpirationTime = this.defaultExpirationTime.getTimeMilliValue();
        s.tileMinExpirationTime = this.minExpirationTime.getTimeMilliValue();
        s.tileMaxExpirationTime = this.maxExpirationTime.getTimeMilliValue();
        s.maxMapSize = this.mapSize.getValue();
        s.mapOverlapTiles = (Integer)this.mapOverlapTiles.getValue();
        Locale locale = ((SupportLocale)((Object)this.languageCombo.getSelectedItem())).locale;
        s.localeLanguage = locale.getLanguage();
        s.localeCountry = locale.getCountry();
        s.setAtlasOutputDirectory(this.atlasOutputDirectory.getText());
        s.downloadThreadCount = threads = ((Integer)this.threadCount.getSelectedItem()).intValue();
        s.setBandwidthLimit(((Bandwidth)((Object)this.bandwidth.getSelectedItem())).limit);
        s.setProxyType((ProxyType)((Object)this.proxyType.getSelectedItem()));
        s.setCustomProxyHost(this.proxyHost.getText());
        s.setCustomProxyPort(this.proxyPort.getText());
        s.setCustomProxyUserName(this.proxyUserName.getText());
        s.setCustomProxyPassword(this.proxyPassword.getText());
        s.applyProxySettings();
        Vector<String> disabledMaps = new Vector<String>();
        for (MapSource ms : this.disabledMapSourcesModel.getVector()) {
            disabledMaps.add(ms.getName());
        }
        s.mapSourcesDisabled = disabledMaps;
        Vector<String> enabledMaps = new Vector<String>();
        for (MapSource ms : this.enabledMapSourcesModel.getVector()) {
            enabledMaps.add(ms.getName());
        }
        s.mapSourcesEnabled = enabledMaps;
        s.ignoreDlErrors = this.ignoreDlErrors.isSelected();
        this.paperAtlas.applySettings(s);
        this.display.applySettings(s);
        if (MainGUI.getMainGUI() == null) {
            return;
        }
        MainGUI.getMainGUI().updateMapSourcesList();
        s.osmHikingTicket = this.osmHikingTicket.getText().trim();
        try {
            MainGUI.getMainGUI().checkAndSaveSettings();
        }
        catch (Exception e) {
            log.error("Error saving settings to file", e);
            JOptionPane.showMessageDialog(null, String.format(I18nUtils.localizedStringForKey("set_error_saving_msg", new Object[0]), e.getClass().getSimpleName()), I18nUtils.localizedStringForKey("set_error_saving_title", new Object[0]), 0);
        }
        MainGUI.getMainGUI().previewMap.repaint();
    }

    private void addListeners() {
        this.addWindowListener(new WindowCloseListener());
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SettingsGUI.this.applySettings();
                SettingsGUI.this.dispose();
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SettingsGUI.this.dispose();
            }
        });
        this.tabbedPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                if (SettingsGUI.this.tabbedPane.getSelectedComponent() == null) {
                    return;
                }
                if (SettingsGUI.this.tabbedPane.getSelectedComponent() == SettingsGUI.this.tileStoreTab) {
                    SettingsGUI.this.tabbedPane.removeChangeListener(this);
                    SettingsGUI.this.tileStoreTab.updateTileStoreInfoPanelAsync(null);
                }
            }
        });
        KeyStroke escapeKeyStroke = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction escapeAction = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                SettingsGUI.this.dispose();
            }
        };
        this.getRootPane().getInputMap(2).put(escapeKeyStroke, "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", escapeAction);
    }

    public static final TitledBorder createSectionBorder(String title) {
        TitledBorder tb = BorderFactory.createTitledBorder(title);
        Border border = BorderFactory.createEtchedBorder(1);
        EmptyBorder margin = new EmptyBorder(3, 3, 3, 3);
        tb.setBorder(new CompoundBorder(border, margin));
        return tb;
    }

    private class MapPacksOnlineUpdateAction
    implements ActionListener {
        private MapPacksOnlineUpdateAction() {
        }

        public void actionPerformed(ActionEvent event) {
            try {
                MapPackManager mpm = new MapPackManager(Settings.getInstance().getMapSourcesDirectory());
                int result = mpm.updateMapPacks();
                switch (result) {
                    case -1: {
                        JOptionPane.showMessageDialog(SettingsGUI.this, I18nUtils.localizedStringForKey("set_mapsrc_config_online_update_msg_outdate", new Object[0]), I18nUtils.localizedStringForKey("set_mapsrc_config_online_update_no_update", new Object[0]), 0);
                        break;
                    }
                    case 0: {
                        JOptionPane.showMessageDialog(SettingsGUI.this, I18nUtils.localizedStringForKey("set_mapsrc_config_online_update_msg_noneed", new Object[0]), I18nUtils.localizedStringForKey("set_mapsrc_config_online_update_no_update", new Object[0]), 1);
                        break;
                    }
                    default: {
                        JOptionPane.showMessageDialog(SettingsGUI.this, String.format(I18nUtils.localizedStringForKey("set_mapsrc_config_online_update_msg_done", new Object[0]), result), I18nUtils.localizedStringForKey("set_mapsrc_config_online_update_done", new Object[0]), 1);
                        break;
                    }
                }
            }
            catch (UpdateFailedException e) {
                JOptionPane.showMessageDialog(SettingsGUI.this, e.getMessage(), I18nUtils.localizedStringForKey("set_mapsrc_config_online_update_failed", new Object[0]), 0);
            }
            catch (Exception e) {
                Settings.getInstance().mapSourcesUpdate.etag = null;
                GUIExceptionHandler.processException(e);
            }
        }
    }

    private class WindowCloseListener
    extends WindowAdapter {
        private WindowCloseListener() {
        }

        public void windowClosed(WindowEvent event) {
            SettingsGUI.this.tileStoreTab.stopThread();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum SupportLocale {
        SupportLocaleEn(new Locale("en"), "English"),
        SupportLocaleFrFR(new Locale("fr", "FR"), "Fran\u00e7ais"),
        SupportLocaleJaJP(new Locale("ja", "JP"), "\u65e5\u672c\u8a9e"),
        SupportLocaleZhCN(new Locale("zh", "CN"), "\u7b80\u4f53\u4e2d\u6587"),
        SupportLocaleZhTW(new Locale("zh", "TW"), "\u7e41\u9ad4\u4e2d\u6587");

        private final Locale locale;
        private final String displayName;

        private SupportLocale(Locale locale, String displayName) {
            this.locale = locale;
            this.displayName = displayName;
        }

        public static SupportLocale localeOf(String lang, String contry) {
            for (SupportLocale l : SupportLocale.values()) {
                if (!l.locale.getLanguage().equals(lang) || !l.locale.getCountry().equals(contry)) continue;
                return l;
            }
            return SupportLocaleEn;
        }

        public String toString() {
            return this.displayName;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Bandwidth {
        UNLIMITED(I18nUtils.localizedStringForKey("set_net_bandwidth_unlimited", new Object[0]), 0L),
        MBit1("1 MBit", 125000L),
        MBit5("5 MBit", 625000L),
        MBit10("10 MBit", 1250000L),
        MBit15("15 MBit", 1875000L),
        MBit20("20 MBit", 2500000L);

        public final long limit;
        public final String description;

        private Bandwidth(String description, long limit) {
            this.description = description;
            this.limit = limit;
        }

        public String toString() {
            return this.description;
        }
    }
}

