/*
 * Decompiled with CFR 0.152.
 */
package mobac.gui.panels;

import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import mobac.data.gpx.gpx11.RteType;
import mobac.data.gpx.gpx11.TrkType;
import mobac.data.gpx.gpx11.TrksegType;
import mobac.data.gpx.gpx11.WptType;
import mobac.gui.actions.GpxAddPoint;
import mobac.gui.actions.GpxClear;
import mobac.gui.actions.GpxLoad;
import mobac.gui.actions.GpxNew;
import mobac.gui.actions.GpxSave;
import mobac.gui.components.JCollapsiblePanel;
import mobac.gui.gpxtree.GpxEntry;
import mobac.gui.gpxtree.GpxRootEntry;
import mobac.gui.gpxtree.GpxTreeListener;
import mobac.gui.gpxtree.RteEntry;
import mobac.gui.gpxtree.TrkEntry;
import mobac.gui.gpxtree.TrksegEntry;
import mobac.gui.gpxtree.WptEntry;
import mobac.gui.mapview.PreviewMap;
import mobac.gui.mapview.layer.GpxLayer;
import mobac.utilities.GBC;
import mobac.utilities.I18nUtils;

public class JGpxPanel
extends JCollapsiblePanel {
    private static final long serialVersionUID = 1L;
    private JTree tree;
    private DefaultMutableTreeNode rootNode;
    private DefaultTreeModel model;
    private ArrayList<String> openedFiles;
    private PreviewMap previewMap;

    public JGpxPanel(PreviewMap previewMap) {
        super("Gpx", new GridBagLayout());
        this.previewMap = previewMap;
        JButton newGpx = new JButton(I18nUtils.localizedStringForKey("rp_gpx_new_gpx", new Object[0]));
        newGpx.addActionListener(new GpxNew(this));
        JButton loadGpx = new JButton(I18nUtils.localizedStringForKey("rp_gpx_load_gpx", new Object[0]));
        loadGpx.addActionListener(new GpxLoad(this));
        JButton saveGpx = new JButton(I18nUtils.localizedStringForKey("rp_gpx_save_gpx", new Object[0]));
        saveGpx.addActionListener(new GpxSave(this));
        JButton clearGpx = new JButton(I18nUtils.localizedStringForKey("rp_gpx_clear_gpx", new Object[0]));
        clearGpx.addActionListener(new GpxClear(this));
        JButton addPointGpx = new JButton(I18nUtils.localizedStringForKey("rp_gpx_add_wpt", new Object[0]));
        addPointGpx.addActionListener(new GpxAddPoint(this));
        this.rootNode = new DefaultMutableTreeNode(I18nUtils.localizedStringForKey("rp_gpx_default_node_name", new Object[0]));
        this.tree = new JTree(this.rootNode);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        JScrollPane treeView = new JScrollPane(this.tree);
        this.model = (DefaultTreeModel)this.tree.getModel();
        this.tree.addMouseListener(new GpxTreeListener());
        this.openedFiles = new ArrayList();
        GBC eol = GBC.eol().fill(2);
        GBC std = GBC.std().fill(2);
        this.addContent(treeView, GBC.eol().fill());
        this.addContent(clearGpx, std);
        this.addContent(addPointGpx, eol);
        this.addContent(newGpx, std);
        this.addContent(loadGpx, std);
        this.addContent(saveGpx, eol);
    }

    public GpxRootEntry addGpxLayer(GpxLayer layer) {
        layer.setPanel(this);
        GpxRootEntry gpxEntry = new GpxRootEntry(layer);
        DefaultMutableTreeNode gpxNode = new DefaultMutableTreeNode(gpxEntry);
        this.model.insertNodeInto(gpxNode, this.rootNode, this.rootNode.getChildCount());
        TreePath path = new TreePath(gpxNode.getPath());
        this.tree.scrollPathToVisible(new TreePath(path));
        this.tree.setSelectionPath(path);
        this.addRtes(layer, gpxNode);
        this.addTrks(layer, gpxNode);
        this.addWpts(layer, gpxNode);
        if (layer.getFile() != null) {
            this.openedFiles.add(layer.getFile().getAbsolutePath());
        }
        this.previewMap.mapLayers.add(layer);
        return gpxEntry;
    }

    private void addWpts(GpxLayer layer, DefaultMutableTreeNode gpxNode) {
        List<WptType> wpts = layer.getGpx().getWpt();
        for (WptType wpt : wpts) {
            WptEntry wptEntry = new WptEntry(wpt, layer);
            DefaultMutableTreeNode wptNode = new DefaultMutableTreeNode(wptEntry);
            this.model.insertNodeInto(wptNode, gpxNode, gpxNode.getChildCount());
        }
    }

    private void addTrks(GpxLayer layer, DefaultMutableTreeNode gpxNode) {
        List<TrkType> trks = layer.getGpx().getTrk();
        for (TrkType trk : trks) {
            TrkEntry trkEntry = new TrkEntry(trk, layer);
            DefaultMutableTreeNode trkNode = new DefaultMutableTreeNode(trkEntry);
            this.model.insertNodeInto(trkNode, gpxNode, gpxNode.getChildCount());
            List<TrksegType> trksegs = trk.getTrkseg();
            int counter = 1;
            for (TrksegType trkseg : trksegs) {
                TrksegEntry trksegEntry = new TrksegEntry(trkseg, counter, layer);
                DefaultMutableTreeNode trksegNode = new DefaultMutableTreeNode(trksegEntry);
                this.model.insertNodeInto(trksegNode, trkNode, trkNode.getChildCount());
                ++counter;
                List<WptType> trkpts = trkseg.getTrkpt();
                for (WptType trkpt : trkpts) {
                    WptEntry trkptEntry = new WptEntry(trkpt, layer);
                    DefaultMutableTreeNode trkptNode = new DefaultMutableTreeNode(trkptEntry);
                    this.model.insertNodeInto(trkptNode, trksegNode, trksegNode.getChildCount());
                }
            }
        }
    }

    private void addRtes(GpxLayer layer, DefaultMutableTreeNode gpxNode) {
        List<RteType> rtes = layer.getGpx().getRte();
        for (RteType rte : rtes) {
            RteEntry rteEntry = new RteEntry(rte, layer);
            DefaultMutableTreeNode rteNode = new DefaultMutableTreeNode(rteEntry);
            this.model.insertNodeInto(rteNode, gpxNode, gpxNode.getChildCount());
            List<WptType> rtepts = rte.getRtept();
            for (WptType rtept : rtepts) {
                WptEntry rteptEntry = new WptEntry(rtept, layer);
                DefaultMutableTreeNode rteptNode = new DefaultMutableTreeNode(rteptEntry);
                this.model.insertNodeInto(rteptNode, rteNode, rteNode.getChildCount());
            }
        }
    }

    public void addWpt(WptType wpt, GpxEntry gpxEntry) {
        WptEntry wptEntry = new WptEntry(wpt, gpxEntry.getLayer());
        DefaultMutableTreeNode wptNode = new DefaultMutableTreeNode(wptEntry);
        this.model.insertNodeInto(wptNode, gpxEntry.getNode(), gpxEntry.getNode().getChildCount());
    }

    public void removeWpt(WptEntry wptEntry) {
        DefaultMutableTreeNode wptNode = wptEntry.getNode();
        this.model.removeNodeFromParent(wptNode);
    }

    public GpxEntry getSelectedEntry() {
        TreePath selection = this.tree.getSelectionPath();
        if (selection == null) {
            return null;
        }
        DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode)selection.getLastPathComponent();
        GpxEntry gpxEntry = null;
        try {
            gpxEntry = (GpxEntry)selectedNode.getUserObject();
            gpxEntry.setNode(selectedNode);
        }
        catch (ClassCastException e) {
            // empty catch block
        }
        return gpxEntry;
    }

    public boolean isFileOpen(String path) {
        return this.openedFiles.contains(path);
    }

    public void resetModel() {
        this.rootNode = new DefaultMutableTreeNode(I18nUtils.localizedStringForKey("rp_gpx_default_node_name", new Object[0]));
        this.model.setRoot(this.rootNode);
        this.openedFiles = new ArrayList();
    }

    public DefaultTreeModel getTreeModel() {
        return this.model;
    }
}

