/*
 * Decompiled with CFR 0.152.
 */
package mobac.gui.panels;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.ParseException;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import mobac.gui.components.FilledLayeredPane;
import mobac.gui.components.JCollapsiblePanel;
import mobac.gui.components.JCoordinateField;
import mobac.gui.components.JDropDownButton;
import mobac.program.interfaces.MapSource;
import mobac.program.model.CoordinateStringFormat;
import mobac.program.model.EastNorthCoordinate;
import mobac.program.model.MapSelection;
import mobac.program.model.MercatorPixelCoordinate;
import mobac.utilities.GBC;
import mobac.utilities.I18nUtils;

public class JCoordinatesPanel
extends JCollapsiblePanel {
    private static final long serialVersionUID = 1L;
    private JCoordinateField latMinTextField;
    private JCoordinateField latMaxTextField;
    private JCoordinateField lonMinTextField;
    private JCoordinateField lonMaxTextField;
    private JButton applySelectionButton;
    private CoordinateStringFormat csf = CoordinateStringFormat.DEG_ENG;

    public JCoordinatesPanel() {
        super(I18nUtils.localizedStringForKey("lp_coords_title", new Object[0]), new GridBagLayout());
        this.setName("Coordinates");
        this.latMaxTextField = new JCoordinateField(-85.0, 85.0);
        this.latMaxTextField.setActionCommand("latMaxTextField");
        this.lonMinTextField = new JCoordinateField(-179.0, 179.0);
        this.lonMinTextField.setActionCommand("longMinTextField");
        this.lonMaxTextField = new JCoordinateField(-179.0, 179.0);
        this.lonMaxTextField.setActionCommand("longMaxTextField");
        this.latMinTextField = new JCoordinateField(-85.0, 85.0);
        this.latMinTextField.setActionCommand("latMinTextField");
        this.applySelectionButton = new JButton(I18nUtils.localizedStringForKey("lp_coords_select_btn_title", new Object[0]));
        JLabel latMaxLabel = new JLabel(I18nUtils.localizedStringForKey("lp_coords_label_N", new Object[0]), 0);
        JLabel lonMinLabel = new JLabel(I18nUtils.localizedStringForKey("lp_coords_label_W", new Object[0]), 0);
        JLabel lonMaxLabel = new JLabel(I18nUtils.localizedStringForKey("lp_coords_label_E", new Object[0]), 0);
        JLabel latMinLabel = new JLabel(I18nUtils.localizedStringForKey("lp_coords_label_S", new Object[0]), 0);
        JPanel northPanel = new JPanel(new BorderLayout());
        FilledLayeredPane layeredPane = new FilledLayeredPane();
        JPanel northInnerPanel = new JPanel();
        northInnerPanel.add(latMaxLabel);
        northInnerPanel.add(this.latMaxTextField);
        JPanel formatButtonPanel = new JPanel(null);
        formatButtonPanel.setOpaque(false);
        JDropDownButton formatButton = new JDropDownButton(I18nUtils.localizedStringForKey("lp_coords_fmt_list_title", new Object[0]));
        formatButton.setMargin(new Insets(0, 5, 0, 0));
        formatButton.setBounds(2, 2, 55, 20);
        formatButtonPanel.add(formatButton);
        for (CoordinateStringFormat csf : CoordinateStringFormat.values()) {
            formatButton.addDropDownItem(new JNumberFormatMenuItem(csf));
        }
        layeredPane.add((Component)northInnerPanel, (Object)0);
        layeredPane.setMinimumSize(northInnerPanel.getMinimumSize());
        layeredPane.setPreferredSize(northInnerPanel.getPreferredSize());
        layeredPane.add((Component)formatButtonPanel, (Object)2);
        northPanel.add((Component)layeredPane, "Center");
        this.contentContainer.add((Component)northPanel, GBC.eol().fillH().insets(0, 5, 0, 0));
        JPanel eastWestPanel = new JPanel(new GridBagLayout());
        eastWestPanel.add((Component)lonMinLabel, GBC.std());
        eastWestPanel.add((Component)this.lonMinTextField, GBC.std());
        eastWestPanel.add((Component)lonMaxLabel, GBC.std().insets(10, 0, 0, 0));
        eastWestPanel.add((Component)this.lonMaxTextField, GBC.std());
        this.contentContainer.add((Component)eastWestPanel, GBC.eol().fill());
        JPanel southPanel = new JPanel();
        southPanel.add(latMinLabel);
        southPanel.add(this.latMinTextField);
        this.contentContainer.add((Component)southPanel, GBC.eol().anchor(10));
        this.contentContainer.add((Component)this.applySelectionButton, GBC.eol().anchor(10).insets(0, 5, 0, 0));
    }

    public void setNumberFormat(CoordinateStringFormat csf) {
        this.csf = csf;
        this.latMaxTextField.setNumberFormat(csf.getNumberFormatLatitude());
        this.latMinTextField.setNumberFormat(csf.getNumberFormatLatitude());
        this.lonMaxTextField.setNumberFormat(csf.getNumberFormatLongitude());
        this.lonMinTextField.setNumberFormat(csf.getNumberFormatLongitude());
    }

    public CoordinateStringFormat getNumberFormat() {
        return this.csf;
    }

    public void setSelection(MercatorPixelCoordinate max, MercatorPixelCoordinate min) {
        EastNorthCoordinate c1 = min.getEastNorthCoordinate();
        EastNorthCoordinate c2 = max.getEastNorthCoordinate();
        this.latMaxTextField.setCoordinate(c1.lat);
        this.lonMaxTextField.setCoordinate(c2.lon);
        this.latMinTextField.setCoordinate(c2.lat);
        this.lonMinTextField.setCoordinate(c1.lon);
    }

    public void correctMinMax() {
        String tmp;
        try {
            double lat1 = this.latMaxTextField.getCoordinate();
            double lat2 = this.latMinTextField.getCoordinate();
            if (lat1 < lat2) {
                tmp = this.latMaxTextField.getText();
                this.latMaxTextField.setText(this.latMinTextField.getText());
                this.latMinTextField.setText(tmp);
            }
        }
        catch (ParseException e) {
            // empty catch block
        }
        try {
            double lon1 = this.lonMaxTextField.getCoordinate();
            double lon2 = this.lonMinTextField.getCoordinate();
            if (lon1 < lon2) {
                tmp = this.lonMaxTextField.getText();
                this.lonMaxTextField.setText(this.lonMinTextField.getText());
                this.lonMinTextField.setText(tmp);
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    public MapSelection getMapSelection(MapSource mapSource) {
        EastNorthCoordinate max = this.getMaxCoordinate();
        EastNorthCoordinate min = this.getMinCoordinate();
        return new MapSelection(mapSource, max, min);
    }

    public EastNorthCoordinate getMaxCoordinate() {
        return new EastNorthCoordinate(this.latMaxTextField.getCoordinateOrNaN(), this.lonMaxTextField.getCoordinateOrNaN());
    }

    public EastNorthCoordinate getMinCoordinate() {
        return new EastNorthCoordinate(this.latMinTextField.getCoordinateOrNaN(), this.lonMinTextField.getCoordinateOrNaN());
    }

    public void addButtonActionListener(ActionListener l) {
        this.applySelectionButton.addActionListener(l);
    }

    protected class JNumberFormatMenuItem
    extends JMenuItem
    implements ActionListener {
        private static final long serialVersionUID = 1L;
        private final CoordinateStringFormat csf;

        public JNumberFormatMenuItem(CoordinateStringFormat csf) {
            super(csf.toString());
            this.csf = csf;
            this.addActionListener(this);
        }

        public void actionPerformed(ActionEvent e) {
            System.out.println(e);
            JCoordinatesPanel.this.setNumberFormat(this.csf);
        }
    }
}

