/*
 * Decompiled with CFR 0.152.
 */
package mobac.gui.mapview.layer;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.io.File;
import mobac.data.gpx.gpx11.Gpx;
import mobac.data.gpx.gpx11.RteType;
import mobac.data.gpx.gpx11.TrkType;
import mobac.data.gpx.gpx11.TrksegType;
import mobac.data.gpx.gpx11.WptType;
import mobac.gui.mapview.JMapViewer;
import mobac.gui.mapview.interfaces.MapLayer;
import mobac.gui.panels.JGpxPanel;
import mobac.program.interfaces.MapSpace;

public class GpxLayer
implements MapLayer {
    private static int POINT_RADIUS = 4;
    private static int POINT_DIAMETER = 2 * POINT_RADIUS;
    private Color wptPointColor = new Color(0, 0, 200);
    private Color trkPointColor = Color.RED;
    private Color rtePointColor = new Color(0, 200, 0);
    private Stroke outlineStroke = new BasicStroke(1.0f);
    private Stroke lineStroke = new BasicStroke(2.0f);
    private File file;
    private final Gpx gpx;
    private JGpxPanel panel;
    private boolean showWaypoints = true;
    private boolean showWaypointName = true;
    private boolean showTracks = true;
    private boolean showRoutes = true;
    private int lastTrackPointX = Integer.MIN_VALUE;
    private int lastTrackPointY = Integer.MIN_VALUE;

    public GpxLayer(Gpx gpx) {
        this.gpx = gpx;
    }

    public void paint(JMapViewer map, Graphics2D g, int zoom, int minX, int minY, int maxX, int maxY) {
        g.setColor(this.wptPointColor);
        MapSpace mapSpace = map.getMapSource().getMapSpace();
        if (this.showWaypoints) {
            for (WptType pt : this.gpx.getWpt()) {
                this.paintPoint(pt, this.wptPointColor, g, this.showWaypointName, mapSpace, zoom, minX, minY, maxX, maxY);
            }
        }
        if (this.showTracks) {
            for (TrkType trk : this.gpx.getTrk()) {
                for (TrksegType seg : trk.getTrkseg()) {
                    this.lastTrackPointX = Integer.MIN_VALUE;
                    this.lastTrackPointY = Integer.MIN_VALUE;
                    for (WptType pt : seg.getTrkpt()) {
                        this.paintTrack(pt, this.trkPointColor, g, mapSpace, zoom, minX, minY, maxX, maxY);
                    }
                }
            }
        }
        if (this.showRoutes) {
            for (RteType rte : this.gpx.getRte()) {
                this.lastTrackPointX = Integer.MIN_VALUE;
                this.lastTrackPointY = Integer.MIN_VALUE;
                for (WptType pt : rte.getRtept()) {
                    this.paintTrack(pt, this.rtePointColor, g, mapSpace, zoom, minX, minY, maxX, maxY);
                }
            }
        }
    }

    private boolean paintPoint(WptType point, Color color, Graphics2D g, boolean paintPointName, MapSpace mapSpace, int zoom, int minX, int minY, int maxX, int maxY) {
        int x = mapSpace.cLonToX(point.getLon().doubleValue(), zoom);
        if (x < minX || x > maxX) {
            return false;
        }
        int y = mapSpace.cLatToY(point.getLat().doubleValue(), zoom);
        if (y < minY || y > maxY) {
            return false;
        }
        g.setColor(color);
        g.fillOval((x -= minX) - POINT_RADIUS, (y -= minY) - POINT_RADIUS, POINT_DIAMETER, POINT_DIAMETER);
        g.setColor(Color.BLACK);
        g.setStroke(this.outlineStroke);
        g.drawOval(x - POINT_RADIUS, y - POINT_RADIUS, POINT_DIAMETER, POINT_DIAMETER);
        if (paintPointName && point.getName() != null) {
            g.drawString(point.getName(), x + POINT_RADIUS + 5, y - POINT_RADIUS);
        }
        return true;
    }

    private boolean paintTrack(WptType point, Color color, Graphics2D g, MapSpace mapSpace, int zoom, int minX, int minY, int maxX, int maxY) {
        int xAbs = mapSpace.cLonToX(point.getLon().doubleValue(), zoom);
        int yAbs = mapSpace.cLatToY(point.getLat().doubleValue(), zoom);
        int x = xAbs - minX;
        int y = yAbs - minY;
        g.setColor(color);
        if (this.lastTrackPointX != Integer.MIN_VALUE && this.lastTrackPointY != Integer.MIN_VALUE) {
            g.setStroke(this.lineStroke);
            g.drawLine(this.lastTrackPointX, this.lastTrackPointY, x, y);
        }
        this.lastTrackPointX = x;
        this.lastTrackPointY = y;
        return true;
    }

    public Gpx getGpx() {
        return this.gpx;
    }

    public void setPanel(JGpxPanel panel) {
        this.panel = panel;
    }

    public JGpxPanel getPanel() {
        return this.panel;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public File getFile() {
        return this.file;
    }
}

