/*
 * Decompiled with CFR 0.152.
 */
package mobac.gui.mapview.controller;

import java.awt.Point;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelListener;
import mobac.gui.mapview.PreviewMap;

public abstract class JMapController {
    protected final PreviewMap map;
    protected boolean enabled = false;

    public JMapController(PreviewMap map) {
        this.map = map;
    }

    public JMapController(PreviewMap map, boolean enabled) {
        this(map);
        if (enabled) {
            this.enable();
        }
    }

    public void enable() {
        if (this.enabled) {
            return;
        }
        if (this instanceof MouseListener) {
            this.map.addMouseListener((MouseListener)((Object)this));
        }
        if (this instanceof MouseWheelListener) {
            this.map.addMouseWheelListener((MouseWheelListener)((Object)this));
        }
        if (this instanceof MouseMotionListener) {
            this.map.addMouseMotionListener((MouseMotionListener)((Object)this));
        }
        this.enabled = true;
    }

    public void disable() {
        if (!this.enabled) {
            return;
        }
        if (this instanceof MouseListener) {
            this.map.removeMouseListener((MouseListener)((Object)this));
        }
        if (this instanceof MouseWheelListener) {
            this.map.removeMouseWheelListener((MouseWheelListener)((Object)this));
        }
        if (this instanceof MouseMotionListener) {
            this.map.removeMouseMotionListener((MouseMotionListener)((Object)this));
        }
        this.enabled = false;
    }

    protected Point convertToAbsolutePoint(Point p) {
        Point mapPoint = this.map.getTopLeftCoordinate();
        mapPoint.x = (int)((double)mapPoint.x + p.getX());
        mapPoint.y = (int)((double)mapPoint.y + p.getY());
        mapPoint = this.map.getMapSource().getMapSpace().changeZoom(mapPoint, this.map.getZoom(), 22);
        return mapPoint;
    }
}

