/*
 * Decompiled with CFR 0.152.
 */
package mobac.gui.gpxtree;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import mobac.gui.actions.GpxElementListener;
import mobac.gui.gpxtree.GpxEntry;
import mobac.utilities.I18nUtils;

public class GpxTreeListener
implements MouseListener {
    private JPopupMenu popup;

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.showPopup(e);
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.showPopup(e);
        }
    }

    private void showPopup(MouseEvent e) {
        JTree tree = (JTree)e.getSource();
        TreePath selPath = tree.getPathForLocation(e.getX(), e.getY());
        tree.setSelectionPath(selPath);
        if (selPath == null) {
            return;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)selPath.getLastPathComponent();
        GpxEntry gpxEntry = null;
        try {
            gpxEntry = (GpxEntry)node.getUserObject();
            gpxEntry.setNode(node);
        }
        catch (ClassCastException exc) {
            // empty catch block
        }
        this.popup = new JPopupMenu();
        JMenuItem delete = new JMenuItem(I18nUtils.localizedStringForKey("rp_gpx_pop_menu_delete_element", new Object[0]));
        delete.setName(GpxElementListener.MENU_NAME_DELETE);
        GpxElementListener listener = new GpxElementListener(gpxEntry);
        delete.addMouseListener(listener);
        this.popup.add(delete);
        JMenuItem rename = new JMenuItem(I18nUtils.localizedStringForKey("rp_gpx_pop_menu_rename_element", new Object[0]));
        rename.setName(GpxElementListener.MENU_NAME_RENAME);
        rename.addMouseListener(listener);
        this.popup.add(rename);
        this.popup.show((Component)e.getSource(), e.getX(), e.getY());
    }
}

