/*
 * Decompiled with CFR 0.152.
 */
package mobac.gui.dialogs;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import mobac.utilities.GBCTable;
import mobac.utilities.I18nUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FontChooser {
    private static final String[] FONT_NAMES = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
    private static final String[] STYLES = new String[]{"Plain", "Bold", "Italic", "Bold + Italic"};
    public static final Font DEFAULT = new Font("SansSerif", 0, 12);
    private final JDialog jDialog = new JDialog();
    private final JLabel jLabelPreview = new JLabel("DUMMY");
    private final JList<String> jListName = this.createJList(FONT_NAMES);
    private final JList<String> jListStyle = this.createJList(STYLES);
    private final JList<Integer> jListSize = this.createJList(new Integer[]{8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24});
    private final JButton jButtonOK = new JButton(I18nUtils.localizedStringForKey("OK", new Object[0]));
    private final JButton jButtonCancel = new JButton(I18nUtils.localizedStringForKey("Cancel", new Object[0]));
    private boolean wasCanceled;

    public static String encodeFont(Font font) {
        String style;
        switch (font.getStyle()) {
            case 0: {
                style = "PLAIN";
                break;
            }
            case 1: {
                style = "BOLD";
                break;
            }
            case 2: {
                style = "ITALIC";
                break;
            }
            case 3: {
                style = "BOLDITALIC";
                break;
            }
            default: {
                style = "PLAIN";
            }
        }
        return font.getName() + "-" + style + "-" + font.getSize();
    }

    private static JScrollPane scroll(JList<?> jList, String title) {
        JLabel jLabel = new JLabel(title);
        jLabel.setHorizontalAlignment(0);
        JScrollPane jScrollPane = new JScrollPane(jList);
        jScrollPane.setColumnHeaderView(jLabel);
        return jScrollPane;
    }

    public FontChooser() {
        this.jDialog.setTitle(I18nUtils.localizedStringForKey("dlg_font_choose_title", new Object[0]));
        this.jDialog.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.jLabelPreview.setHorizontalAlignment(0);
        this.jLabelPreview.setVerticalAlignment(0);
        this.jLabelPreview.setBorder(BorderFactory.createTitledBorder(I18nUtils.localizedStringForKey("dlg_font_choose_preview", new Object[0])));
        this.jButtonOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FontChooser.this.wasCanceled = false;
                FontChooser.this.jDialog.setVisible(false);
            }
        });
        this.jButtonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FontChooser.this.jDialog.setVisible(false);
            }
        });
        JPanel buttonPane = new JPanel();
        buttonPane.add(this.jButtonOK);
        buttonPane.add(this.jButtonCancel);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        GBCTable gbc = new GBCTable();
        jPanel.add((Component)FontChooser.scroll(this.jListName, I18nUtils.localizedStringForKey("dlg_font_choose_name", new Object[0])), gbc.begin().fill());
        jPanel.add((Component)FontChooser.scroll(this.jListStyle, I18nUtils.localizedStringForKey("dlg_font_choose_style", new Object[0])), gbc.incX().fill());
        jPanel.add((Component)FontChooser.scroll(this.jListSize, I18nUtils.localizedStringForKey("dlg_font_choose_size", new Object[0])), gbc.incX().fill());
        jPanel.add((Component)this.jLabelPreview, gbc.begin(1, 2).fillH().gridwidth(3));
        jPanel.add((Component)buttonPane, gbc.incY().fillH().gridwidth(3));
        this.jDialog.setContentPane(jPanel);
        this.jDialog.setSize(384, 384);
        this.jDialog.setMinimumSize(this.jDialog.getSize());
        this.setFont(DEFAULT);
    }

    private <E> JList<E> createJList(E[] objects) {
        JList<E> jList = new JList<E>(objects);
        jList.setSelectionMode(0);
        jList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    Font font = FontChooser.this.getFont();
                    FontChooser.this.jLabelPreview.setFont(font);
                    FontChooser.this.jLabelPreview.setText(FontChooser.encodeFont(font));
                }
            }
        });
        return jList;
    }

    public void setFont(Font font) {
        if (font == null) {
            font = DEFAULT;
        }
        this.jListName.setSelectedValue(font.getName(), true);
        this.jListStyle.setSelectedIndex(font.getStyle());
        this.jListSize.setSelectedValue(font.getSize(), true);
    }

    public Font getFont() {
        Integer size;
        int style;
        String name = this.jListName.getSelectedValue();
        if (name == null) {
            name = DEFAULT.getName();
        }
        if ((style = this.jListStyle.getSelectedIndex()) == -1) {
            style = DEFAULT.getStyle();
        }
        if ((size = this.jListSize.getSelectedValue()) == null) {
            size = DEFAULT.getSize();
        }
        return new Font(name, style, size);
    }

    public void show() {
        this.wasCanceled = true;
        this.jDialog.setLocationRelativeTo(this.jDialog.getParent());
        this.jDialog.setVisible(true);
    }

    public boolean wasCanceled() {
        return this.wasCanceled;
    }
}

